--
-- Currently The OpenRPT uses some non-standard format functions
-- in sql. The functions provided here are the base and can be
-- used to expand upon or simply to allow the formating to work
-- when rendering reports.
--
CREATE OR REPLACE FUNCTION formatRatio(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D999999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatUOMRatio(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D999999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatScrap(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(($1 * 100), ''99999990D00''), '' '') AS result
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatPrcnt(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(($1 * 100), ''99999990D00''), '' '') AS result
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatQty(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D99''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatQtyPer(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D9999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatMoney(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D99''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatCost(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D9999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatPrice(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D99''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatSalesPrice(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D9999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatPurchPrice(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D9999''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatExtPrice(NUMERIC) RETURNS TEXT IMMUTABLE AS '
SELECT LTRIM(TO_CHAR(COALESCE($1, 0), ''9,999,999,990D99''), '' '')
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatDate(TIMESTAMP WITH TIME ZONE) RETURNS TEXT IMMUTABLE AS '
SELECT TO_CHAR($1, ''MM/DD/YYYY'') AS result
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatDate(DATE) RETURNS TEXT IMMUTABLE AS '
SELECT TO_CHAR($1, ''MM/DD/YYYY'') AS result
' LANGUAGE 'sql';

CREATE OR REPLACE FUNCTION formatTime(TIMESTAMP WITH TIME ZONE) RETURNS TEXT IMMUTABLE AS '
SELECT TO_CHAR($1, ''HH24:MI:SS'') AS result
' LANGUAGE 'sql';


