//                                               -*- C++ -*-
/**
 *  @file  DesignProxy.hxx
 *  @brief Design matrix cached evaluation
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010)
 */
#ifndef OPENTURNS_DESIGNPROXY_HXX
#define OPENTURNS_DESIGNPROXY_HXX

#include "NumericalSample.hxx"
#include "Basis.hxx"
#include "PersistentObject.hxx"
#include "Basis.hxx"

BEGIN_NAMESPACE_OPENTURNS


/**
 * @class DesignProxy
 *
 * Design matrix cached evaluation
 */
class OT_API DesignProxy
  : public Object
{
  CLASSNAME;
public:

  /** Default constructor */
  DesignProxy();

  /** Parameters constructor */
  DesignProxy(const NumericalSample & x,
              const Basis & basis);

  /** Virtual constructor */
  virtual DesignProxy * clone() const;

  /** String converter */
  virtual String __repr__() const;

  /** Accessor to the design matrix values */
  NumericalScalar operator() (const UnsignedInteger xIndex,
                              const UnsignedInteger phiIndex) const;

  /** Accessors */
  NumericalSample getInputSample() const;
  Basis getBasis() const;

  /** Compute the design matrix with the provided basis terms indices */
  Matrix computeDesign(const Indices & indices) const;

  /** Sample indirections used to swap design experiment entries */
  void setXIndirections(const Indices & xIndirections) const;
  Indices getXIndirections() const;

protected:
  void initialize();

  /** Input sample */
  NumericalSample x_;

  /** Basis */
  Basis basis_;

  /** Design matrix cache */
  mutable Matrix designCache_;

  /** Extra column cache */
  mutable UnsignedInteger lastPhiIndex_;
  mutable NumericalSample lastColumn_;

  /** Indirection tables */
  mutable Indices columnsIndirections_;
  mutable Indices freeColumns_;
  mutable UnsignedInteger firstFreeColumnIndex_;

  /** External redirections */
  mutable Indices xIndirections_;

}; /* class DesignProxy */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_DESIGNPROXY_HXX */
