\name{computeLinearModel}
\alias{computeLinearModel}
\title{Computes a linear model}
\description{
This ROT function, called from a LinearModelFactory, is given two samples 
and a confidence level, and is used to compute a linear model. 
It returns the parameter estimates, confidence intervals and p-values.}
\usage{
computeLinearModel(x, y, testLevel = 0.95)
}
\arguments{
  \item{x}{A m-by-n matrix containing the explanatory variables.}
  \item{y}{A n-by-1 vector containng the response variables.}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
A list is returned, containing :
  \item{parameterEstimate}{The estimated parameters (vector).}
  \item{confidenceIntervalLow}{The parameters confidence interval lower bounds (vector).}
  \item{confidenceIntervalHigh}{The parameters confidence interval lower bounds (vector).}
  \item{pValues}{The parameters p-values.}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
x <- matrix(runif(40), 10, 4)
r <- matrix(c(1,2,3,4), 4, 1)
y <- x %*% r + matrix(rnorm(10, 0, 0.05), 10, 1)
computeLinearModel(x,y)
}
\keyword{ multivariate }