# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8307 (wordpress)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64610);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-8307 (wordpress)");

 desc = "The remote host is missing an update to wordpress
announced via advisory FEDORA-2009-8307.

Wordpress is an online publishing / weblog package that makes it very easy,
almost trivial, to get information out to people on the web.

Update Information:

Update to upstream version 2.8.3:
http://wordpress.org/development/2009/08/wordpress-2-8-3-security-release/

ChangeLog:

* Mon Aug  3 2009 Adrian Reber  - 2.8.3-1
- updated to 2.8.3 for security fixes
* Tue Jul 28 2009 Adrian Reber  - 2.8.2-1
- updated to 2.8.2 for security fixes - BZ 512900
- fixed wrong-script-end-of-line-encoding of license.txt
- correctly disable auto update check
- fixed an error message from 'find' during the build
* Mon Jul 27 2009 Fedora Release Engineering  - 2.8.1-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild
* Fri Jul 10 2009 Adrian Reber  - 2.8.1-1
- updated to 2.8.1 for security fixes - BZ 510745

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wordpress' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8307

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8307 (wordpress)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wordpress", rpm:"wordpress~2.8.3~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
