###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kaspersky_av_bof_vuln.nasl 1010 2009-02-13 13:40:29Z feb $
#
# Kaspersky AntiVirus Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800242);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_bugtraq_id(33561);
  script_cve_id("CVE-2009-0449");
  script_name("Kaspersky AntiVirus Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running Kaspersky AntiVirus or Workstation and is
  prone to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to an error in the klim5.sys driver when handling Kernel
  API calls IOCTL 0x80052110 which can overwrite callback function pointers
  and execute arbitrary codes into the context of the application.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application or may cause privilege escalation. 

  Impact level: Application/System

  Affected Software/OS:
  Kaspersky AntiVirus version 7.0.1.325 and prior on Windows.
  Kaspersky AntiVirus Workstation version 6.0.3.837 and prior on Windows.

  Fix: No solution or patch is available as on 16th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.kaspersky.com/productupdates?chapter=146274385

  References:
  http://secunia.com/advisories/33788
  http://www.wintercore.com/advisories/advisory_W020209.html

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Kaspersky AV/Workstation");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_kaspersky_av_detect.nasl");
  script_require_keys("Kaspersky/AV/Ver", "Kaspersky/AV-Workstation/Ver");
  exit(0);
}


include("version_func.inc");

kavVer = get_kb_item("Kaspersky/AV/Ver");
if(kavVer != NULL)
{
  if(version_is_less_equal(version:kavVer, test_version:"7.0.1.325")){
    security_hole(0);
    exit(0);
  }
}

kavwVer = get_kb_item("Kaspersky/AV-Workstation/Ver");
if(kavwVer != NULL)
{
  if(version_is_less_equal(version:kavwVer, test_version:"6.0.3.837")){
    security_hole(0);
  }
}
