###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for kernel 118855-36
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855148);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "SUNSolve", value: "118855-36");
  script_name( "Solaris Update for kernel 118855-36");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  kernel
  For more information please visit the below reference link.

  Affected Software/OS:
  kernel on solaris_5.10_x86

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-118855-36-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"i386", patch:"118855-36", package:"SUNWcpc.i SUNWpcmci SUNWadpu320 SUNWcnetr SUNWrmodu SUNWrcmdc SUNWixgb SUNWpsu SUNWfss SUNWatfsu SUNWadp SUNWscplp SUNWsacom SUNWpmu SUNWipfr SUNWaudd SUNWudapltu SUNWarc SUNWipfu SUNWintgige SUNWscpu SUNWbtool SUNWrmwbu SUNWxge SUNWbart SUNWradpu320 SUNWrsm SUNWkrbu SUNWsmapi SUNWtavor SUNWopenssl-commands SUNWgssk SUNWpsdcr SUNWipfh SUNWmdb SUNWsndmr SUNWrpcib SUNWncar SUNWpcelx SUNWmddr SUNWsndmu SUNWpppdu SUNWnfssu SUNWcadp SUNWxwdv SUNWkdcu SUNWmdr SUNWpsdir SUNWxcu4 SUNWudapltr SUNWdtrc SUNWxcu6 SUNWusbs SUNWopenssl-libraries SUNWllc SUNWad810 SUNWcsl SUNWrsgk SUNWcpcu SUNWugen SUNWvolu SUNWaac SUNWib SUNWkey SUNWnisu SUNWos86r SUNWuedg SUNWtoo SUNWsi3124 SUNWusbu SUNWpiclu SUNWav1394 SUNWnfssr SUNWmv88sx SUNWkvm.i SUNWppm SUNWuksp SUNWusb SUNWvolr SUNWroute SUNWckr SUNWcsr SUNWpppd SUNW1394 SUNWaudh SUNWrtls SUNWmdbr CADP160 SUNWpcu SUNWsbp2 SUNWarcr SUNWmdu SUNWtnfc SUNWrcapu SUNWpsh SUNWwbsup SUNWhea SUNWcakr.i SUNWqos SUNWnfsckr SUNWdtrp SUNWnfsskr SUNWatfsr SUNWcslr SUNWamr SUNWrmodr SUNWcsu SUNWnfscu SUNWesu SUNWcsd SUNWpcmem SUNWuprl SUNWzoneu SUNWdfbh SUNWnfscr SUNWscsa1394 SUNWftdur SUNWudfr SUNWipoib") < 0)
{
  security_hole(0);
  exit(0);
}