###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openssl vulnerabilities USN-522-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840078);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "522-1");
  script_cve_id("CVE-2007-3108", "CVE-2007-5135");
  script_name( "Ubuntu Update for openssl vulnerabilities USN-522-1");
  desc = "

  Vulnerability Insight:

  It was discovered that OpenSSL did not correctly perform Montgomery
  multiplications.  Local attackers might be able to reconstruct RSA
  private keys by examining another user's OpenSSL processes. (CVE-2007-3108)
  
  Moritz Jodeit discovered that OpenSSL's SSL_get_shared_ciphers function
  did not correctly check the size of the buffer it was writing to.
  A remote attacker could exploit this to write one NULL byte past the end of
  an application's cipher list buffer, possibly leading to arbitrary code
  execution or a denial of service. (CVE-2007-5135)

  Affected Software/OS:
  openssl vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-September/000599.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssl vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8a-7ubuntu0.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8a-7ubuntu0.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8a-7ubuntu0.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl", ver:"0.9.8a-7ubuntu0.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8b-2ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8b-2ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8b-2ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl", ver:"0.9.8b-2ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}