# This script was written by Jeff Adams <jeffrey.adams@hqda.army.mil>
# This script is Copyright (C) 2003 Jeff Adams

if(description)
{
 script_id(11888);
 script_bugtraq_id(8826);
 script_version("$Revision: 7588 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_cve_id("CAN-2003-0717");
 script_xref(name:"IAVA", value:"2003-B-0007");
 
 name = "Buffer Overrun in Messenger Service (828035)";
 
 script_name(name);
 
 desc = "
A security vulnerability exists in the Messenger Service that could allow 
arbitrary code execution on an affected system. An attacker who successfully 
exploited this vulnerability could be able to run code with Local System 
privileges on an affected system, or could cause the Messenger Service to fail.
Disabling the Messenger Service will prevent the possibility of attack. 

This plugin determined by reading the remote registry that the patch
MS03-043 has not been applied.

Solution : see http://www.microsoft.com/technet/security/bulletin/ms03-043.mspx
 
Risk factor : High";

 script_description(desc);
 
 summary = "Checks for hotfix Q828035";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2003 Jeff Adams");
 family = "Windows : Microsoft Bulletins";
 script_family(family);
  script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("secpod_reg.inc");

if ( hotfix_check_sp(nt:7, win2k:5, xp:2, win2003:1) <= 0 ) exit(0);
if ( hotfix_missing(name:"KB828035") > 0  )
	security_hole(get_kb_item("SMB/transport"));

