# OpenVAS
# $Id$
# Description: This script allows to set SSH credentials for target hosts.
#
# Authors:
# Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
# Felix Wolfsteller <felix.wolfsteller@intevation.de>
# Chandrashekhar B <bchandra@secpod.com>
#
# Copyright:
# Copyright (C) 2007,2008,2009 Intevation GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or, at your option, any later version as published by the
# Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.

if(description)
{
 script_id(90022);
 script_version ("2.3");
 script_tag(name:"risk_factor", value:"None");
 name = "SSH Authorization";

 script_name(name);

 desc = "
This script allows users to enter the information
required to authorize and login via a ssh key.

These data are stored in the knowledge base
and used by other tests.

With openvas-server >= 2.0.1 and OpenVAS-Client >= 2.0.2
the user can enter the login information on a per-target basis.

To use this new functionality, the corresponding checkbox
needs to be checked.

Definition of a single key for all target is deprecated and
will be removed latest with OpenVAS 3.0.

Risk factor: None";

 script_description(desc);

 summary = "Sets SSH key-based authorization, optionally on a per-target basis.";
 script_summary(summary);

 script_category(ACT_SETTINGS);

 script_copyright("Copyright 2007-2009 Intevation GmbH, License: GNU GPLv2+");
 family = "Credentials";
 script_family(family);

# Preference type to trigger client-side ssh-login selection per target
 script_add_preference(name:"Keys:", type:"sshlogin", value:"-");

# Preference to decide whether to use old-style "single" login or the "new" per-target-wise
# (deprecated: once openvas-server < 2.0.1 is not supported anymore this can be removed)
 script_add_preference(name:"Use per-target login information", type:"checkbox", value:"no");
# Following values will be used for the default case of "single" login definition for all targets
# (deprecated: once openvas-server < 2.0.1 is not supported anymore this can be removed)
 script_add_preference(name:"SSH login name:", type:"entry", value:"sshovas");
 script_add_preference(name:"SSH password (unsafe!):", type:"password", value:"");
 script_add_preference(name:"SSH public key:", type:"file", value:"");
 script_add_preference(name:"SSH private key:", type:"file", value:"");
 script_add_preference(name:"SSH key passphrase:", type:"password", value:"");

 script_dependencies("find_service.nes");

 exit(0);
}

# deprecated: once openvas-server < 2.0.1 is not supported anymore this all can be removed:

# Ignore "single"-login information?

include("ssh_func.inc");

use_new = script_get_preference("Use per-target login information");
if(use_new == "no")
{
  # Old-style "single" login for all targets
  ssh_login_name = script_get_preference("SSH login name:");
  ssh_password = script_get_preference("SSH password (unsafe!):");
  ssh_public_key = script_get_preference_file_content("SSH public key:");
  ssh_private_key = script_get_preference_file_content("SSH private key:");
  ssh_key_passphrase = script_get_preference("SSH key passphrase:");

  if (ssh_login_name) set_kb_item(name: "Secret/SSH/login", value: ssh_login_name);
  if (ssh_password) set_kb_item(name:"Secret/SSH/password", value:ssh_password);
  if (ssh_public_key) set_kb_item(name: "Secret/SSH/publickey", value: ssh_public_key);
  if (ssh_private_key) set_kb_item(name: "Secret/SSH/privatekey", value: ssh_private_key);
  if (ssh_key_passphrase) set_kb_item(name: "Secret/SSH/passphrase", value: ssh_key_passphrase);
}

# Check if port for us is known
port = get_kb_item("Services/ssh");
if(!port)
{
  log_message(data:'No port for an ssh connect was found open.\nHence local security checks might not work.');
  exit(0); # If port is not open
}

# Check if an account was defined either by the preferences ("old") or by the
# server ("new").
if(kb_ssh_login() && (kb_ssh_password() || kb_ssh_publickey()))
{
  sock = ssh_login_or_reuse_connection();
  if(!sock)
  {
    security_note(data: 'It was not possible to login using the SSH crendentials supplied.\nHence local security checks are not enabled.', port:port);
    ssh_close_connection();
    exit(0);
  }

  security_note(data:'It was possible to login using the SSH credentials supplied.\nHence local security check are enabled.', port:port);
  ssh_close_connection();
}
else
{
  log_message(data:'No SSH crendentials were supplied.\nHence local security checks are not enabled.', port:port);
}

exit(0);
