Minutes from 88th OpenVDB TSC meeting, April 27th, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: JT Nelson (Blender), Johannes Meng (Intel),
Roman Zulak (ImageWorks)

Regrets: *Ken* M.

Agenda:

1) Confirm Quorum
2) Secretary
3) Screen Sharing
4) Website
5) TBB 2021 CI Update
6) AX Updates
7) PR 1040 - Build Config Update
8) TypedAttributeArray
9) VDB Transform
10) PR 1038 - VDB Resampling Bug
11) OpenVDB Merge and OpenVDB Vector Merge
12) Support for CI for ICC
13) Next Meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Screen Sharing

Nick tried to do share screen by following the instructions given by John Mertic.

4) SOP Extrapolate Update

Jeff received comments from people testing SOP Extrapolate:
 - It will be nice to have one way extrapolation, e.g. for velocity field.
 - World space dilation. Jeff has a PR he owes to add to VDB Activate.
 - Fill Inside as dilation option
 - Separate iso contour for SDF and Fog
   The problem with having one isovalue for both SDF and Fog is that when a user
   changes the mode of operation in SOP Extrapolate (e.g. from renormalize to
   convert to SDF), a specific isovalue can give a meaningful result for an SDF, but
   not for a fog. It will be good to separate the two values.

5) TBB 2021 CI Update

Nick added a CI for TBB 2021 update in his fork. Intel has a 2021 containers, which
requires an EULA. Nick added a github action for testing against TBB 2021. Nick will
reach out to John Mertic so that ASWF can figure out the legal implication of adding an
EULA. The CI is building OpenVDB with TBB 2021 and the build is currently failing.

6) AX Updates

There are two updates: (a) Fix for a crash in the AX Houdini SOP with an empty
PointDataGrid input (PR 1041) (b) the active tiles streaming (PR 1042).
The latter is a big feature update on AX. Nick mentions that he solved the problem
he encountered using the InternalNode API by const-casting the table. This is a
better temporary solution than changing the API in the OpenVDB library.

7) PR 1040 - Build Config Update

This was first introduced by Jeff when he was working on the use of Half in OpenVDB.
Several improvements to the build config includes:
 - The PR moves the logic from BuildConfig.h.in to version.h.in, which will generate
   version.h. Defining OpenVDB major, minor, and path versions is now located in one place.
 - The PR introduces OpenVDB_USE_BLOSC and OpenVDB_USE_ZLIB.
 - The PR moves some specific defines from CMake to Platform.h (NOMINMAX _USE_MATH_DEFINES).
   Previously they were defined as compiled definitions for OpenVDB. This affects
   the header includes for OpenVDB, e.g. in the unit test.

8) TypedAttributeArray

Nick wants TypedAttributeArray in OpenVDB points and also for the codecs compress buffer.
He wants to do a flat loop over the data. Dan agrees that there is a use of this. Dan is
happy to provide something like that, but he is worried that this will limit having a codec
that can change size based on its location or value. Nick does not think that giving
an access to the buffer will limit a codec like that. Dan also says that we need to make sure
that the data has been loaded and is not out-of-core at the time and for a uniform value to
return a pointer to a single value.

Jeff says that for Page Handle, they always have a 1k handle of the type, so when you read
it will decompress the 1k page into a buffer so you can do a direct buffer access of your
native type. So the algorithm does not need to care about the codec. So random access can be
meaningless, but a bulk access is meaningful and fast.

9) VDB Transform

Nick says that he had a conversation with Jeff about one DOP that seems to consistently
produce a transform that does not convert nicely to a uniform voxel size in OpenVDB.
Nick believes that we have not solved the problem. Jeff thinks that they have solved the
problem, but he admits that he may be mistaken.

Nick encounters this problem in the pyro solver. Jeff says that this is because of resizing
of fields. Houdini volume stores its size and position. OpenVDB grid stores a transform.
Houdini volume computes volume by computing the resolution divided by the size.
If Nick can provide an example on where the transform fails, it will be helpful for Jeff.

10) PR 1038 - VDB Resampling Bug

VDB resample SOP always creates a new linear transform and applying voxel size/scale.
The current PR takes the transform from the input VDB.

In order to be backward-compatible, Jeff suggests adding a toggle so that the user can
use an axis-aligned linear transform. Previous version of OpenVDB will have the toggle
to be turned on by default, so that it will not cause a change of behavior in old hip
files. Going forward the toggle is off by default. We will support both code paths.

11) OpenVDB Merge and OpenVDB Vector Merge

OpenVDB Vector Merge combines groups of up to three scalar grids into vector grids.
The merge tools contain functions to efficiently merge grids together. It may be useful
to come up with a better name for either the OpenVDB Vector Merge or the OpenVDB Merge tool.
Possible candidate names include: join or collate. Jeff will ask people for better names.

12) Support for CI for ICC

Andre asks if we want to add support for CI for compiling with ICC. Nick says that we need
to ask ASWF to provide a docker container which includes icc compiler.

13) Next Meeting

Next meeting is May 4th, 2021. 12pm-1pm EST (GMT-5).
