/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DatabaseCorrelationList.h>
#include <DataNode.h>
#include <DatabaseCorrelation.h>

//
// Enum conversion methods for DatabaseCorrelationList::WhenToCorrelate
//

static const char *WhenToCorrelate_strings[] = {
"CorrelateAlways", "CorrelateNever", "CorrelateOnlyIfSameLength"
};

std::string
DatabaseCorrelationList::WhenToCorrelate_ToString(DatabaseCorrelationList::WhenToCorrelate t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return WhenToCorrelate_strings[index];
}

std::string
DatabaseCorrelationList::WhenToCorrelate_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return WhenToCorrelate_strings[index];
}

bool
DatabaseCorrelationList::WhenToCorrelate_FromString(const std::string &s, DatabaseCorrelationList::WhenToCorrelate &val)
{
    val = DatabaseCorrelationList::CorrelateAlways;
    for(int i = 0; i < 3; ++i)
    {
        if(s == WhenToCorrelate_strings[i])
        {
            val = (WhenToCorrelate)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Init utility for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DatabaseCorrelationList::Init()
{
    needPermission = true;
    defaultCorrelationMethod = 0;
    whenToCorrelate = CorrelateOnlyIfSameLength;

    DatabaseCorrelationList::SelectAll();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Copy utility for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DatabaseCorrelationList::Copy(const DatabaseCorrelationList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the correlations field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
    correlations.clear();
    if(obj.correlations.size() > 0)
        correlations.reserve(obj.correlations.size());
    // Duplicate the correlations from obj.
    for(pos = obj.correlations.begin(); pos != obj.correlations.end(); ++pos)
    {
        DatabaseCorrelation *oldDatabaseCorrelation = (DatabaseCorrelation *)(*pos);
        DatabaseCorrelation *newDatabaseCorrelation = new DatabaseCorrelation(*oldDatabaseCorrelation);
        correlations.push_back(newDatabaseCorrelation);
    }

    needPermission = obj.needPermission;
    defaultCorrelationMethod = obj.defaultCorrelationMethod;
    whenToCorrelate = obj.whenToCorrelate;

    DatabaseCorrelationList::SelectAll();
}

// Type map format string
const char *DatabaseCorrelationList::TypeMapFormatString = DATABASECORRELATIONLIST_TMFS;
const AttributeGroup::private_tmfs_t DatabaseCorrelationList::TmfsStruct = {DATABASECORRELATIONLIST_TMFS};


// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Default constructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList() : 
    AttributeSubject(DatabaseCorrelationList::TypeMapFormatString)
{
    DatabaseCorrelationList::Init();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Constructor for the derived classes of DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DatabaseCorrelationList::Init();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Copy constructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList(const DatabaseCorrelationList &obj) : 
    AttributeSubject(DatabaseCorrelationList::TypeMapFormatString)
{
    DatabaseCorrelationList::Copy(obj);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Copy constructor for derived classes of the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList(const DatabaseCorrelationList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DatabaseCorrelationList::Copy(obj);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::~DatabaseCorrelationList
//
// Purpose: 
//   Destructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::~DatabaseCorrelationList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the correlations field.
    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator = 
//
// Purpose: 
//   Assignment operator for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList& 
DatabaseCorrelationList::operator = (const DatabaseCorrelationList &obj)
{
    if (this == &obj) return *this;

    DatabaseCorrelationList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator == 
//
// Purpose: 
//   Comparison operator == for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::operator == (const DatabaseCorrelationList &obj) const
{
    bool correlations_equal = (obj.correlations.size() == correlations.size());
    for(size_t i = 0; (i < correlations.size()) && correlations_equal; ++i)
    {
        // Make references to DatabaseCorrelation from AttributeGroup *.
        const DatabaseCorrelation &correlations1 = *((const DatabaseCorrelation *)(correlations[i]));
        const DatabaseCorrelation &correlations2 = *((const DatabaseCorrelation *)(obj.correlations[i]));
        correlations_equal = (correlations1 == correlations2);
    }

    // Create the return value
    return (correlations_equal &&
            (needPermission == obj.needPermission) &&
            (defaultCorrelationMethod == obj.defaultCorrelationMethod) &&
            (whenToCorrelate == obj.whenToCorrelate));
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator != 
//
// Purpose: 
//   Comparison operator != for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::operator != (const DatabaseCorrelationList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DatabaseCorrelationList::TypeName
//
// Purpose: 
//   Type name method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DatabaseCorrelationList::TypeName() const
{
    return "DatabaseCorrelationList";
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DatabaseCorrelationList *tmp = (const DatabaseCorrelationList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DatabaseCorrelationList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DatabaseCorrelationList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::NewInstance
//
// Purpose: 
//   NewInstance method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DatabaseCorrelationList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DatabaseCorrelationList(*this);
    else
        retval = new DatabaseCorrelationList;

    return retval;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::SelectAll()
{
    Select(ID_correlations,             (void *)&correlations);
    Select(ID_needPermission,           (void *)&needPermission);
    Select(ID_defaultCorrelationMethod, (void *)&defaultCorrelationMethod);
    Select(ID_whenToCorrelate,          (void *)&whenToCorrelate);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
DatabaseCorrelationList::CreateSubAttributeGroup(int)
{
    return new DatabaseCorrelation;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Mar 1 16:55:46 PST 2004
//
// Modifications:
//   Brad Whitlock, Thu Mar 25 16:45:47 PST 2004
//   I modified the code so the correlation list is only saved when
//   completeSave is true.
//
// ****************************************************************************

bool
DatabaseCorrelationList::CreateNode(DataNode *parentNode, bool completeSave, bool)
{
    if(parentNode == 0)
        return false;

    // Only save the correlations on a complete save.
    DataNode *node = new DataNode("DatabaseCorrelationList");
    if(completeSave)
    {
        for(size_t i = 0; i < correlations.size(); ++i)
            correlations[i]->CreateNode(node, completeSave, true);
    }

    node->AddNode(new DataNode("needPermission", needPermission));
    node->AddNode(new DataNode("defaultCorrelationMethod", defaultCorrelationMethod));
    node->AddNode(new DataNode("whenToCorrelate", WhenToCorrelate_ToString(whenToCorrelate)));

    // Add the node to the parent node.
    parentNode->AddNode(node);

    return true;
}
// ****************************************************************************
// Method: DatabaseCorrelationList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DatabaseCorrelationList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;

    // Clear all the DatabaseCorrelations if we got any.
    bool clearedCorrelations = false;
    // Go through all of the children and construct a new
    // DatabaseCorrelation for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("DatabaseCorrelation"))
            {
                if (!clearedCorrelations)
                {
                    ClearCorrelations();
                    clearedCorrelations = true;
                }
                DatabaseCorrelation temp;
                temp.SetFromNode(children[i]);
                AddCorrelations(temp);
            }
        }
    }

    if((node = searchNode->GetNode("needPermission")) != 0)
        SetNeedPermission(node->AsBool());
    if((node = searchNode->GetNode("defaultCorrelationMethod")) != 0)
        SetDefaultCorrelationMethod(node->AsInt());
    if((node = searchNode->GetNode("whenToCorrelate")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetWhenToCorrelate(WhenToCorrelate(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            WhenToCorrelate value;
            if(WhenToCorrelate_FromString(node->AsString(), value))
                SetWhenToCorrelate(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DatabaseCorrelationList::SetNeedPermission(bool needPermission_)
{
    needPermission = needPermission_;
    Select(ID_needPermission, (void *)&needPermission);
}

void
DatabaseCorrelationList::SetDefaultCorrelationMethod(int defaultCorrelationMethod_)
{
    defaultCorrelationMethod = defaultCorrelationMethod_;
    Select(ID_defaultCorrelationMethod, (void *)&defaultCorrelationMethod);
}

void
DatabaseCorrelationList::SetWhenToCorrelate(DatabaseCorrelationList::WhenToCorrelate whenToCorrelate_)
{
    whenToCorrelate = whenToCorrelate_;
    Select(ID_whenToCorrelate, (void *)&whenToCorrelate);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
DatabaseCorrelationList::GetCorrelations() const
{
    return correlations;
}

AttributeGroupVector &
DatabaseCorrelationList::GetCorrelations()
{
    return correlations;
}

bool
DatabaseCorrelationList::GetNeedPermission() const
{
    return needPermission;
}

int
DatabaseCorrelationList::GetDefaultCorrelationMethod() const
{
    return defaultCorrelationMethod;
}

DatabaseCorrelationList::WhenToCorrelate
DatabaseCorrelationList::GetWhenToCorrelate() const
{
    return WhenToCorrelate(whenToCorrelate);
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DatabaseCorrelationList::SelectCorrelations()
{
    Select(ID_correlations, (void *)&correlations);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::AddCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::AddCorrelations(const DatabaseCorrelation &obj)
{
    DatabaseCorrelation *newDatabaseCorrelation = new DatabaseCorrelation(obj);
    correlations.push_back(newDatabaseCorrelation);

    // Indicate that things have changed by selecting it.
    Select(ID_correlations, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::ClearCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::ClearCorrelations()
{
    AttributeGroupVector::iterator pos;

    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
    correlations.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_correlations, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::RemoveCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::RemoveCorrelations(int index)
{
    AttributeGroupVector::iterator pos = correlations.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != correlations.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != correlations.end())
    {
        delete *pos;
        correlations.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_correlations, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetNumCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
DatabaseCorrelationList::GetNumCorrelations() const
{
    return (int)correlations.size();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelation &
DatabaseCorrelationList::GetCorrelations(int i)
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const DatabaseCorrelation &
DatabaseCorrelationList::GetCorrelations(int i) const
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator []
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelation &
DatabaseCorrelationList::operator [] (int i)
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator []
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const DatabaseCorrelation &
DatabaseCorrelationList::operator [] (int i) const
{
    return *((DatabaseCorrelation *)correlations[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DatabaseCorrelationList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_correlations:             return "correlations";
    case ID_needPermission:           return "needPermission";
    case ID_defaultCorrelationMethod: return "defaultCorrelationMethod";
    case ID_whenToCorrelate:          return "whenToCorrelate";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DatabaseCorrelationList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_correlations:             return FieldType_attVector;
    case ID_needPermission:           return FieldType_bool;
    case ID_defaultCorrelationMethod: return FieldType_int;
    case ID_whenToCorrelate:          return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DatabaseCorrelationList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_correlations:             return "attVector";
    case ID_needPermission:           return "bool";
    case ID_defaultCorrelationMethod: return "int";
    case ID_whenToCorrelate:          return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DatabaseCorrelationList &obj = *((const DatabaseCorrelationList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_correlations:
        {  // new scope
        bool correlations_equal = (obj.correlations.size() == correlations.size());
        for(size_t i = 0; (i < correlations.size()) && correlations_equal; ++i)
        {
            // Make references to DatabaseCorrelation from AttributeGroup *.
            const DatabaseCorrelation &correlations1 = *((const DatabaseCorrelation *)(correlations[i]));
            const DatabaseCorrelation &correlations2 = *((const DatabaseCorrelation *)(obj.correlations[i]));
            correlations_equal = (correlations1 == correlations2);
        }

        retval = correlations_equal;
        }
        break;
    case ID_needPermission:
        {  // new scope
        retval = (needPermission == obj.needPermission);
        }
        break;
    case ID_defaultCorrelationMethod:
        {  // new scope
        retval = (defaultCorrelationMethod == obj.defaultCorrelationMethod);
        }
        break;
    case ID_whenToCorrelate:
        {  // new scope
        retval = (whenToCorrelate == obj.whenToCorrelate);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

DatabaseCorrelation *
DatabaseCorrelationList::FindCorrelation(const std::string &name) const
{
    DatabaseCorrelation *retval = 0;

    for(size_t i = 0; i < correlations.size(); ++i)
    {
        DatabaseCorrelation *c = (DatabaseCorrelation *)correlations[i];
        if(name == c->GetName())
        {
            retval = c;
            break;
        } 
    }

    return retval;
}

ostream &
operator << (ostream &os, const DatabaseCorrelationList &cL)
{
   os << "{";
   for(int i = 0; i < cL.GetNumCorrelations(); ++i)
   {
      os << cL[i] << ", " << endl;
   }
   os << "}";    
   return os;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::RemoveCorrelation
//
// Purpose: 
//   Removes the named correlation from the list.
//
// Arguments:
//   name : The name of the correlation to remove.
//
// Programmer: Brad Whitlock
// Creation:   Sun Jan 25 02:29:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::RemoveCorrelation(const std::string &name)
{
    int delIndex = -1;
    for(int i = 0; i < GetNumCorrelations(); ++i)
    {
       const DatabaseCorrelation &c = GetCorrelations(i);
       if(c.GetName() == name)
       {
           delIndex = i;
           break;
       }
    }

    if(delIndex >= 0)
       RemoveCorrelations(delIndex);

    return (delIndex>=0);
}

