<?xml version="1.0"?>
<!--

                    XSL for Photo Description Markup Language
                      Version: 0.07     Date: 26 October 2007

             Copyright (c) 2002-2005   Oskar Ojala  omojala@cc.hut.fi

             Note: This style sheet is still under development.

             Licence: Use of this XSLT is subject to the terms of the
             GNU General Public License (version 2), a copy of which
             is distributed with this XSL, and is also available from
             http://www.gnu.org/licenses/.

-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

 <xsl:output method="xml" indent="yes"
	     doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
	     encoding="utf-8"/>

 <!-- Include the XSL encapsulating the CSS definition -->
 <xsl:include href="cssinc.xsl"/>

 <!-- Stylesheet parameter determining the primary font size -->
 <xsl:param name="font-size">11</xsl:param>

  <xsl:template match="/">
    <html>
      <head>
	<title>Photo description</title>

        <xsl:call-template name="include-stylesheet">
          <xsl:with-param name="font-size" select="$font-size"/>
        </xsl:call-template>

      </head>
      <body>
	<h1>Photography Data</h1>
	<xsl:for-each select="photo">
	  <xsl:for-each select="defaults|roll|sheet|digital">
	    <xsl:apply-templates select="."/>
	  </xsl:for-each>
	</xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="roll">
    <h2>
      Roll id: <xsl:value-of select="@id"/>
      <xsl:if test="@cid">
	cid: <xsl:value-of select="@cid"/>
      </xsl:if>
    </h2>

    <xsl:if test="description">
      <p>
        Description: <xsl:value-of select="description"/>
      </p>
    </xsl:if>

    <xsl:apply-templates select="collection"/>
    <xsl:apply-templates select="film"/>
    <xsl:apply-templates select="processing"/>

    <xsl:for-each select="load|defaults|frame-set/defaults|
                          frame|frame-set/frame|unload">
      <xsl:apply-templates select="."/>
    </xsl:for-each>

    <xsl:if test="note">
      <h3>NOTE: <xsl:value-of select="note"/></h3>
    </xsl:if>
  </xsl:template>


  <xsl:template match="sheet">
    <h2>
      Sheet id: <xsl:value-of select="@id"/>
      <xsl:if test="@cid">
	cid: <xsl:value-of select="@cid"/>
      </xsl:if>
    </h2>

    <xsl:if test="description">
      <p>
        Description: <xsl:value-of select="description"/>
      </p>
    </xsl:if>

    <xsl:apply-templates select="collection"/>
    <xsl:apply-templates select="film"/>
    <xsl:apply-templates select="processing"/>
    <xsl:apply-templates select="load"/>
    <xsl:apply-templates select="frame"/>
    <xsl:apply-templates select="unload"/>

    <xsl:if test="note">
      <h3>NOTE: <xsl:value-of select="note"/></h3>
    </xsl:if>
  </xsl:template>


  <xsl:template match="digital">
    <h2>
      Digital id: <xsl:value-of select="@id"/>
      <xsl:if test="@cid">
	cid: <xsl:value-of select="@cid"/>
      </xsl:if>
    </h2>

    <xsl:if test="description">
      <p>
        Description: <xsl:value-of select="description"/>
      </p>
    </xsl:if>

    <xsl:apply-templates select="collection"/>

    <xsl:for-each select="defaults|frame-set/defaults|frame|frame-set/frame">
      <xsl:apply-templates select="."/>
    </xsl:for-each>

    <xsl:if test="note">
      <h3>NOTE: <xsl:value-of select="note"/></h3>
    </xsl:if>
  </xsl:template>


  <xsl:template match="collection">
    <h2>
      Collection id: <xsl:value-of select="@id"/>
      <xsl:if test="@cgid">
	cgid: <xsl:value-of select="@cgid"/>
      </xsl:if>
      <xsl:if test="@fstfid">
	fstfid: <xsl:value-of select="@fstfid"/>
      </xsl:if>
      <xsl:if test="@lstfid">
	lstfid: <xsl:value-of select="@lstfid"/>
      </xsl:if>
    </h2>

    <xsl:if test="description">
      <p>
        Description: <xsl:value-of select="description"/>
      </p>
    </xsl:if>

    <xsl:if test="note">
      <h3>NOTE: <xsl:value-of select="note"/></h3>
    </xsl:if>
  </xsl:template>


  <xsl:template match="load">
    <h3>
      Loaded: 
      <xsl:value-of select="date"/>
      <xsl:value-of select="note"/>
    </h3>
  </xsl:template>


  <xsl:template match="unload">
    <h3>
      Unloaded:
      <xsl:value-of select="date"/>
      <xsl:value-of select="note"/>
    </h3>
  </xsl:template>


  <xsl:template match="defaults">
    <p/>
    <table style="background-color: rgb(230,255,245);">
       <tr><td style="background-color: transparent">
       <h3>Defaults</h3>
         <xsl:if test="@combine">
           combine mode: <xsl:value-of select="@combine"/>
         </xsl:if>
	    <xsl:apply-templates select="film"/>
	    <xsl:apply-templates select="processing"/>
	    <xsl:apply-templates select="frame"/>
	</td></tr>
     </table>
  </xsl:template>


  <xsl:template match="film">
    <h3>Film</h3>
    <table>
      <tr>
	<th>Make</th>
	<th>Name</th>
	<th>Speed</th>
	<th>Process</th>
	<th>Type</th>
	<th>Format</th>
	<th>Notes</th>
      </tr>
      <tr>
	<td><xsl:value-of select="make"/></td>
	<td><xsl:value-of select="name"/></td>
	<td><xsl:value-of select="speed"/></td>
	<td><xsl:value-of select="process"/></td>
	<td><xsl:value-of select="type"/></td>
	<td><xsl:value-of select="format"/></td>
	<td><xsl:value-of select="note"/></td>
      </tr>
    </table>
  </xsl:template>

  <!-- empty spaces need to be added after selects in order to improve legibility -->

  <xsl:template match="processing">
    <h3>Processing</h3>
    <table>
      <tr>
	<th>Lab</th>
	<th>Tag</th>
	<th>Date</th>
	<th>Developing</th>
	<th>Notes</th>
      </tr>
      <tr>
	<td>
	  <xsl:for-each select="lab">
	    <table class="nb">
	      <xsl:if test="name">
		<tr><td class="plain"><xsl:value-of select="name"/></td></tr>
	      </xsl:if>
	      <xsl:if test="address">
		<tr><td class="plain"><xsl:value-of select="address"/></td></tr>
	      </xsl:if>
	      <xsl:if test="phone">
		<tr><td class="plain">Phone: <xsl:value-of select="phone"/></td></tr>
	      </xsl:if>
	      <xsl:if test="fax">
		<tr><td class="plain">Fax: <xsl:value-of select="fax"/></td></tr>
	      </xsl:if>
	      <xsl:if test="email">
		<tr><td class="plain"><xsl:value-of select="email"/></td></tr>
	      </xsl:if>
	      <xsl:if test="www">
		<tr><td class="plain"><xsl:value-of select="www"/></td></tr>
	      </xsl:if>
	      <xsl:if test="note">
		<tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	      </xsl:if>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:value-of select="tag"/></td>
	<td><xsl:value-of select="date"/></td>

	<td>
	  <xsl:for-each select="developing">
	    <table class="nb">
	      <xsl:if test="process">
		<tr><td class="plain"><xsl:value-of select="process"/></td></tr>
	      </xsl:if>
	      <xsl:if test="shift">
		<tr>
		  <td class="plain"><xsl:value-of select="@type"/>:
		    <xsl:value-of select="shift"/></td>
		</tr>
	      </xsl:if>
	      <xsl:if test="developer">
		<tr><td class="plain">
		    <xsl:value-of select="developer/type"/><xsl:text> </xsl:text>
		    <xsl:value-of select="developer/dilution"/><xsl:text> </xsl:text>
		    <xsl:value-of select="developer/note"/></td>
		</tr>
	      </xsl:if>
	      <xsl:if test="method">
		<tr><td class="plain"><xsl:value-of select="method"/></td></tr>
	      </xsl:if>
	      <xsl:if test="agitation">
		<tr><td class="plain"><xsl:value-of select="agitation"/></td></tr>
	      </xsl:if>
	      <xsl:if test="temperature">
		<tr><td class="plain"><xsl:value-of select="temperature"/>C</td></tr>
	      </xsl:if>
	      <xsl:if test="duration">
		<tr><td class="plain"><xsl:value-of select="duration"/> mm:ss</td></tr>
	      </xsl:if>
	      <xsl:if test="note">
		<tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	      </xsl:if>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:value-of select="note"/></td>
      </tr>
    </table>
  </xsl:template>


  <!-- lists might also be considered instead of tables for formatting innermost
  elements -->

  <!-- should column-width be limited/forced? -->


  <xsl:template match="frame">
    <h3>
      Frame <xsl:value-of select="@id"/>
    <xsl:if test="@fn">
      (fn: <xsl:value-of select="@fn"/>)
    </xsl:if>
     </h3>
    <table style="table-layout: fixed">
      <tr>
	<th>Photographer</th>
	<th>Intellectual Property Rights</th>
	<th>Scene</th>
	<th>Equipment</th>
	<th>Exposure</th>
	<th>Focus</th>
	<th>Condition</th>
	<th>Image</th>
	<th>Notes</th>
      </tr>
      <tr>
	<td><xsl:for-each select="photographer">
	    <table class="nb">
	      <tr><td class="plain"><xsl:value-of select="name"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="address"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="phone"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="fax"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="email"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="www"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:for-each select="ipr">
	    <xsl:if test="copyright">
	      <xsl:value-of select="copyright"/><br/>
	    </xsl:if>
	    <xsl:for-each select="owner">
	      <table class="nb">
		<tr><td class="plain"><xsl:value-of select="name"/></td></tr>
		<tr><td class="plain"><xsl:value-of select="address"/></td></tr>
		<tr><td class="plain"><xsl:value-of select="phone"/></td></tr>
		<tr><td class="plain"><xsl:value-of select="fax"/></td></tr>
		<tr><td class="plain"><xsl:value-of select="email"/></td></tr>
		<tr><td class="plain"><xsl:value-of select="www"/></td></tr>
	      </table><br/>
	    </xsl:for-each>
	    <xsl:value-of select="note"/>
	  </xsl:for-each>
	</td>

	<td><xsl:for-each select="scene">
	    <table class="nb">
	      <tr><td class="plain"><xsl:value-of select="type"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="keywords"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="caption"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="description"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="occasion"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="location"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="content"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:for-each select="equipment">
	    <table class="nb">
	      <tr><td class="plain"><xsl:value-of select="body"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="body-attachment"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="lens"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="lens-attachment"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="illumination"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="support"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:for-each select="exposure">
	    <table class="nb">
	      <xsl:if test="aperture">
		<tr><td class="plain">Aperture: f/<xsl:value-of select="aperture"/></td></tr>
	      </xsl:if>
	      <xsl:if test="shutter">
		<tr><td class="plain">Shutter: <xsl:value-of select="shutter"/></td></tr>
	      </xsl:if>
	      <xsl:if test="exp-comp">
		<tr><td class="plain">Exp-comp: <xsl:value-of select="exp-comp"/></td></tr>
	      </xsl:if>
	      <xsl:if test="flash">
		<tr><td class="plain">Flash: <xsl:value-of select="flash"/></td></tr>
	      </xsl:if>
	      <xsl:if test="flash-comp">
		<tr><td class="plain">Flash-comp: <xsl:value-of select="flash-comp"/></td></tr>
	      </xsl:if>
	      <xsl:if test="rated-speed">
		<tr><td class="plain">Rated-speed: <xsl:value-of select="rated-speed"/></td></tr>
	      </xsl:if>
	      <xsl:if test="mode">
		<tr><td class="plain">Exp-mode: <xsl:value-of select="mode"/></td></tr>
	      </xsl:if>
	      <xsl:if test="metering">
		<tr><td class="plain">Metering: <xsl:value-of select="metering"/></td></tr>
	      </xsl:if>
	      <xsl:if test="note">
		<tr><td class="plain">Note: <xsl:value-of select="note"/></td></tr>
	      </xsl:if>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:for-each select="focus">
	    <table class="nb">
	      <tr><td class="plain"><xsl:value-of select="focal-length"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="focal-distance"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="mode"/></td></tr>
	      <tr><td class="plain"><xsl:value-of select="note"/></td></tr>
	    </table>
	  </xsl:for-each>
	</td>

	<td><xsl:value-of select="condition"/></td>

	<td><xsl:value-of select="image"/></td>

	<td><xsl:value-of select="note"/></td>

      </tr>
    </table>
  </xsl:template>

</xsl:stylesheet>
