---
title: PICOTOOL-PICOTOOL
section: 1
header: User Commands
---
# NAME

picotool\-picotool \- Tool for interacting with RP\-series device\(s\) in BOOTSEL mode, or with an RP\-series binary

# SYNOPSIS

picotool info \[\-b\] \[\-m\] \[\-p\] \[\-d\] \[\-\-debug\] \[\-l\] \[\-a\] \[device\-selection\]

picotool info \[\-b\] \[\-m\] \[\-p\] \[\-d\] \[\-\-debug\] \[\-l\] \[\-a\] \<filename\> \[\-t \<type\>\]

picotool config \[\-s \<key\> \<value\>\] \[\-g \<group\>\] \[device\-selection\]

picotool config \[\-s \<key\> \<value\>\] \[\-g \<group\>\] \<filename\> \[\-t \<type\>\]

picotool load \[\-\-ignore\-partitions\] \[\-\-family \<family\_id\>\] \[\-p \<partition\>\] \[\-n\] \[\-N\] \[\-u\] \[\-v\] \[\-x\] \<filename\> \[\-t \<type\>\] \[\-o \<offset\>\] \[device\-selection\]

picotool link \[\-\-quiet\] \[\-\-verbose\] \<outfile\> \[\-t \<type\>\] \<infile1\> \[\-t \<type\>\] \<infile2\> \[\-t \<type\>\] \[\<infile3\>\] \[\-t \<type\>\] \[\-p \<pad\>\]

picotool save \[\-p\] \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool save \-a \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool save \-r \<from\> \<to\> \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool erase \[\-a\] \[device\-selection\]

picotool erase \-p \<partition\> \[device\-selection\]

picotool erase \-r \<from\> \<to\> \[device\-selection\]

picotool verify \<filename\> \[\-t \<type\>\] \[device\-selection\] \[\-r \<from\> \<to\>\] \[\-o \<offset\>\] \[device\-selection\]

picotool reboot \[\-a\] \[\-u\] \[\-g \<partition\>\] \[\-c \<cpu\>\] \[device\-selection\]

picotool otp list\|get\|set\|load\|dump\|permissions\|white\-label

picotool partition info\|create

picotool uf2 info\|convert

picotool version \[\-s\] \[\<version\>\]

picotool coprodis \[\-\-quiet\] \[\-\-verbose\] \<infile\> \<outfile\>

picotool help \[\<cmd\>\]


# COMMANDS

**info**
: Display information from the target device\(s\) or file\.Without any arguments, this will display basic information forall connected RP\-series devices in BOOTSEL mode

**config**
: Display or change program configuration settings from the targetdevice\(s\) or file\.

**load**
: Load the program / memory range stored in a file onto thedevice\.

**link**
: Link multiple binaries into one block loop\.

**save**
: Save the program / memory stored in flash on the device to afile\.

**erase**
: Erase the program / memory stored in flash on the device\.

**verify**
: Check that the device contents match those in the file\.

**reboot**
: Reboot the device

**otp**
: Commands related to the RP2350 OTP \(One\-Time\-Programmable\)Memory

**partition**
: Commands related to RP2350 Partition Tables

**uf2**
: Commands related to UF2 creation and status

**version**
: Display picotool version

**coprodis**
: Post\-process coprocessor instructions in disassembly files\.

**help**
: Show general help or help for a specific command

