#!/usr/dist/share/perl,v5.003/5bin.sun4/perl5 -w
# Lookup in Address Book
# using PilotManager SyncAB comma delimited file (.csvAddr)
# 10 Apr 98 andy.poggio@Sun.COM
# Adapted from SyncAB.pm by Alan Harder
# and pilot_names by Dave Brillhart.
# This code doesn't write any files and so is safe

my ($Filename);
my ($RCFILE) = "$ENV{HOME}/.pilotmgr/SyncAB/SyncAB.prefs";
my ($dashline) = "---------------------\n";
my ($debug) = 0;
my ($VERSION) = ('0.800');

my ($gCSVorder) = ([ 'rolo_id', 'lastname', 'firstname', 'company',
		     'phone1', 'phone2', 'phone3', 'phone4', 'phone5',
		     'address', 'city', 'state', 'zip', 'country', 'title',
		     'custom1', 'custom2', 'custom3', 'custom4', 'note',
		     'whichphone', 'phonetypes', 'category' ]);
		     
my ($lastname, $firstname, $company);
my ($phone1, $phone2, $phone3, $phone4, $phone5, $phonetypes);
my ($address, $city, $state, $zip, $country, $note);

my ($searchnum) = 0;
my ($PREFS, $gdb);

# get the csv filename
&loadPrefs;
$Filename = $PREFS->{'CSVFile'};

# -- Collect command line args
if (($arg = shift(@ARGV))) {
  $searchnum = 1;
  $syscmd = "grep -i $arg $Filename |";
}
while (($arg = shift(@ARGV))) {
  $syscmd = $syscmd . " grep -i $arg |";
}
if ( !$searchnum) {
  printf("\nError:  must specify at least one search argument\n");
  exit(3);
}

# -- Read the grep'd csvAddr file and print out entries
  &readCSV( $syscmd);

exit(0);

sub loadPrefs
{
    my ($lines);

    open(FD, "<$RCFILE") || return;
    $lines = join('', <FD>);
    close(FD);
    eval $lines;
}

sub readCSV
{
    my ($cmdline) = @_;
    my ($rec, $key, $fld, $val, $line);

    if (!open(FD, $cmdline))
      {printf("ERROR: failed command ($cmdline)"); exit(3);}

    while (<FD>)
    {
	($val, $_) = &popCSV($_); #rolo id
	($val, $_) = &popCSV($_);
	$lastname = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$firstname = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$company = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$phone1 = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$phone2 = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$phone3 = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$phone4 = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$phone5 = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$address = &CSVToStr($val);
        ($val, $_) = &popCSV($_);
	$city = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$state = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$zip = &CSVToStr($val);
	($val, $_) = &popCSV($_);
	$country = &CSVToStr($val);
	($val, $_) = &popCSV($_); #title
	($val, $_) = &popCSV($_); #c1
	($val, $_) = &popCSV($_); #c2
	($val, $_) = &popCSV($_); #c3
	($val, $_) = &popCSV($_); #c4
	($val, $_) = &popCSV($_);
	$note = &CSVToStr($val);
	($val, $_) = &popCSV($_); #whichphone
	($val, $_) = &popCSV($_);
	$phonetypes = &CSVToStr($val);
	($val, $_) = &popCSV($_); #category
	
	&printcsv;
    }
    close(FD);
}

sub printcsv
{
my ($phonenames) = { '0' => 'Work:  ', '1' => 'Home:  ', '2' => 'Fax:   ',
		'3' => 'Other: ', '4' => 'Email: ', '5' =>'Main:  ',
		'6' => 'Pager: ', '7' => 'Mobile:' };
my ($pt1, $pt2, $pt3, $pt4, $pt5);

$phonetypes =~ s/(.) //; $pt1 = $phonenames->{"$1"};
$phonetypes =~ s/(.) //; $pt2 = $phonenames->{"$1"};
$phonetypes =~ s/(.) //; $pt3 = $phonenames->{"$1"};
$phonetypes =~ s/(.) //; $pt4 = $phonenames->{"$1"};
$phonetypes =~ s/(.)//; $pt5 = $phonenames->{"$1"};

printf($dashline);
if ($lastname || $firstname) {
    printf("%s %s\n", $firstname, $lastname);
}
if ($company) {
    printf("%s\n", $company);
}

if ($address) { printf("%s\n", $address);}
if ($city || $state || $zip || $country) {
  printf("%s", $city);
  if ($state || $zip || $country) { printf(", ");}
  printf( "%s %s %s\n", $state, $zip, $country);
}

if ($phone1) { printf("%s  %s\n", $pt1, $phone1);}
if ($phone2) { printf("%s  %s\n", $pt2, $phone2);}
if ($phone3) { printf("%s  %s\n", $pt3, $phone3);}
if ($phone4) { printf("%s  %s\n", $pt4, $phone4);}
if ($phone5) { printf("%s  %s\n", $pt5, $phone5);}

if ($note) { printf( "Note:    %s\n", $note); }
}

sub popCSV
{
    my ($str) = @_;

    if ($str =~ s/^("([^"]|"")*")(,|$)//)
    {
	return($1, $str);
    }
    elsif ($str =~ s/^(.*?)(,|$)//)
    {
	return($1, $str);
    }

    return($str, '');
}

sub CSVToStr
{
    my ($str) = @_;

    if ($str =~ /^"(.*)"$/)
    {
	$str = $1;
	$str =~ s/""/"/g;
    }
    $str =~ s/((\\\\)*)(\\)?n/'\\' x (length($1)\/2) . ($3 ? "\n" : 'n')/ge;
    while ($str =~ /\n$/) #remove trailing newlines
    {
	$str =~ s/\n$//;
    }
    return $str;
}
