/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.pmml.BuiltInArithmetic;
import weka.core.pmml.BuiltInMath;
import weka.core.pmml.BuiltInString;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Function
implements Serializable {
    private static final long serialVersionUID = -6997738288201933171L;
    protected String m_functionName;
    protected ArrayList<Attribute> m_parameterDefs = null;

    public String getName() {
        return this.m_functionName;
    }

    public abstract String[] getParameterNames();

    public abstract void setParameterDefs(ArrayList<Attribute> var1) throws Exception;

    public abstract Attribute getOutputDef();

    public abstract double getResult(double[] var1) throws Exception;

    public static Function getFunction(String name) {
        Function result = null;
        if ((name = name.trim()).equals("+")) {
            result = new BuiltInArithmetic(BuiltInArithmetic.Operator.ADDITION);
        } else if (name.equals("-")) {
            result = new BuiltInArithmetic(BuiltInArithmetic.Operator.SUBTRACTION);
        } else if (name.equals("*")) {
            result = new BuiltInArithmetic(BuiltInArithmetic.Operator.MULTIPLICATION);
        } else if (name.equals("/")) {
            result = new BuiltInArithmetic(BuiltInArithmetic.Operator.DIVISION);
        } else if (name.equals(BuiltInMath.MathFunc.MIN.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.MIN);
        } else if (name.equals(BuiltInMath.MathFunc.MAX.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.MAX);
        } else if (name.equals(BuiltInMath.MathFunc.SUM.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.SUM);
        } else if (name.equals(BuiltInMath.MathFunc.AVG.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.AVG);
        } else if (name.equals(BuiltInMath.MathFunc.LOG10.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.LOG10);
        } else if (name.equals(BuiltInMath.MathFunc.LN.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.LN);
        } else if (name.equals(BuiltInMath.MathFunc.SQRT.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.SQRT);
        } else if (name.equals(BuiltInMath.MathFunc.ABS.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.ABS);
        } else if (name.equals(BuiltInMath.MathFunc.EXP.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.EXP);
        } else if (name.equals(BuiltInMath.MathFunc.POW.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.POW);
        } else if (name.equals(BuiltInMath.MathFunc.THRESHOLD.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.THRESHOLD);
        } else if (name.equals(BuiltInMath.MathFunc.FLOOR.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.FLOOR);
        } else if (name.equals(BuiltInMath.MathFunc.CEIL.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.CEIL);
        } else if (name.equals(BuiltInMath.MathFunc.ROUND.toString())) {
            result = new BuiltInMath(BuiltInMath.MathFunc.ROUND);
        } else if (name.equals((Object)BuiltInString.StringFunc.SUBSTRING)) {
            result = new BuiltInString(BuiltInString.StringFunc.SUBSTRING);
        } else if (name.equals((Object)BuiltInString.StringFunc.TRIMBLANKS)) {
            result = new BuiltInString(BuiltInString.StringFunc.TRIMBLANKS);
        }
        return result;
    }

    public static Function getFunction(String name, TransformationDictionary transDict) throws Exception {
        Function result = Function.getFunction(name);
        if (result == null && transDict != null) {
            result = transDict.getFunction(name);
        }
        if (result == null) {
            throw new Exception("[Function] unknown/unsupported function " + name);
        }
        return result;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        return pad + this.getClass().getName();
    }
}

