/*
 * @BEGIN LICENSE
 *
 * Psi4: an open-source quantum chemistry software package
 *
 * Copyright (c) 2007-2019 The Psi4 Developers.
 *
 * The copyrights for code used from other parties are included in
 * the corresponding files.
 *
 * This file is part of Psi4.
 *
 * Psi4 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * Psi4 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with Psi4; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * @END LICENSE
 */

/*
** The new PSI standard header file for atomic masses.
**
** Created by Matt Leininger, July 1995
**
** This file contains three arrays.  The first is a list of atomic masses
** for a number of isotopes.  The second is a list of isotope labels which
** correspond to the masses in the first array.  The mass labels given
** are the same as those in W. D. Allen's INTDER95.  The final array is a
** list of atomic masses for the first several elements, with the most
** common isotopomer mass given.  This last array is most useful for
** converting an atomic number into an atomic mass.
**
** Please be sure that any modifications to this file are reflected in
** _all three_ arrays if necessary.
**
** Modifications:
** 10/08/99 EFV - Changed an2masses[0] to 0.0000
**                (ghost atom's weight should be 0)
**
** 08/16/02 EFV - Updated atomic_masses[] and an2masses for H-Ar using NIST database
**                of Atomic Weights and Isotopic Compositions (www.nist.gov)
**
** 08/23/02 EFV - Use lithium isotope 7 as the default (most abundant)
**
** 03/03/08 MT - extended set of atoms by data from mathematica script. For an2masses
**               for naturally occurring atoms, the most abundant is used, otherwise the
**               atom with the longest halflife time.
**
** 08/31/18 LAB - autogenerated from NIST json publication via qcelemental. Corrects Kr
**                and some unstable element masses.
**
** AUTOGENERATED, DO NOT EDIT!
**
*/

#ifndef _qcelemental_masses_h_
#define _qcelemental_masses_h_

/* This file is autogenerated from the QCElemental python module */

static const char *atomic_labels[] = {
    "X",  "H",  "HE", "LI", "BE", "B",  "C",  "N",  "O",  "F",  "NE", "NA", "MG", "AL", "SI", "P",  "S",
    "CL", "AR", "K",  "CA", "SC", "TI", "V",  "CR", "MN", "FE", "CO", "NI", "CU", "ZN", "GA", "GE", "AS",
    "SE", "BR", "KR", "RB", "SR", "Y",  "ZR", "NB", "MO", "TC", "RU", "RH", "PD", "AG", "CD", "IN", "SN",
    "SB", "TE", "I",  "XE", "CS", "BA", "LA", "CE", "PR", "ND", "PM", "SM", "EU", "GD", "TB", "DY", "HO",
    "ER", "TM", "YB", "LU", "HF", "TA", "W",  "RE", "OS", "IR", "PT", "AU", "HG", "TL", "PB", "BI", "PO",
    "AT", "RN", "FR", "RA", "AC", "TH", "PA", "U",  "NP", "PU", "AM", "CM", "BK", "CF", "ES", "FM", "MD",
    "NO", "LR", "RF", "DB", "SG", "BH", "HS", "MT", "DS", "RG", "CN", "NH", "FL", "MC", "LV", "TS"};

static const double an2masses[] = {0,
                                   1.00782503223,
                                   4.00260325413,
                                   7.0160034366,
                                   9.012183065,
                                   11.00930536,
                                   12.0000000,
                                   14.00307400443,
                                   15.99491461957,
                                   18.99840316273,
                                   19.9924401762,
                                   22.9897692820,
                                   23.985041697,
                                   26.98153853,
                                   27.97692653465,
                                   30.97376199842,
                                   31.9720711744,
                                   34.968852682,
                                   39.9623831237,
                                   38.9637064864,
                                   39.962590863,
                                   44.95590828,
                                   47.94794198,
                                   50.94395704,
                                   51.94050623,
                                   54.93804391,
                                   55.93493633,
                                   58.93319429,
                                   57.93534241,
                                   62.92959772,
                                   63.92914201,
                                   68.9255735,
                                   73.921177761,
                                   74.92159457,
                                   79.9165218,
                                   78.9183376,
                                   83.9114977282,
                                   84.9117897379,
                                   87.9056125,
                                   88.9058403,
                                   89.9046977,
                                   92.9063730,
                                   97.90540482,
                                   97.9072124,
                                   101.9043441,
                                   102.9054980,
                                   105.9034804,
                                   106.9050916,
                                   113.90336509,
                                   114.903878776,
                                   119.90220163,
                                   120.9038120,
                                   129.906222748,
                                   126.9044719,
                                   131.9041550856,
                                   132.9054519610,
                                   137.90524700,
                                   138.9063563,
                                   139.9054431,
                                   140.9076576,
                                   141.9077290,
                                   144.9127559,
                                   151.9197397,
                                   152.9212380,
                                   157.9241123,
                                   158.9253547,
                                   163.9291819,
                                   164.9303288,
                                   165.9302995,
                                   168.9342179,
                                   173.9388664,
                                   174.9407752,
                                   179.9465570,
                                   180.9479958,
                                   183.95093092,
                                   186.9557501,
                                   191.9614770,
                                   192.9629216,
                                   194.9647917,
                                   196.96656879,
                                   201.97064340,
                                   204.9744278,
                                   207.9766525,
                                   208.9803991,
                                   208.9824308,
                                   209.9871479,
                                   222.0175782,
                                   223.0197360,
                                   226.0254103,
                                   227.0277523,
                                   232.0380558,
                                   231.0358842,
                                   238.0507884,
                                   237.0481736,
                                   244.0642053,
                                   243.0613813,
                                   247.0703541,
                                   247.0703073,
                                   251.0795886,
                                   252.082980,
                                   257.0951061,
                                   258.0984315,
                                   259.10103,
                                   266.11983,
                                   267.12179,
                                   268.12567,
                                   271.13393,
                                   270.13336,
                                   269.13375,
                                   278.15631,
                                   281.16451,
                                   282.16912,
                                   285.17712,
                                   286.18221,
                                   289.19042,
                                   289.19363,
                                   293.20449,
                                   294.21046};

static const char *mass_labels[] = {
    "H1",    "H2",    "D",     "H3",    "T",     "H4",    "H5",    "H6",    "H7",    "H",     "HE3",   "HE4",   "HE5",
    "HE6",   "HE7",   "HE8",   "HE9",   "HE10",  "HE",    "LI3",   "LI4",   "LI5",   "LI6",   "LI7",   "LI8",   "LI9",
    "LI10",  "LI11",  "LI12",  "LI13",  "LI",    "BE5",   "BE6",   "BE7",   "BE8",   "BE9",   "BE10",  "BE11",  "BE12",
    "BE13",  "BE14",  "BE15",  "BE16",  "BE",    "B6",    "B7",    "B8",    "B9",    "B10",   "B11",   "B12",   "B13",
    "B14",   "B15",   "B16",   "B17",   "B18",   "B19",   "B20",   "B21",   "B",     "C8",    "C9",    "C10",   "C11",
    "C12",   "C13",   "C14",   "C15",   "C16",   "C17",   "C18",   "C19",   "C20",   "C21",   "C22",   "C23",   "C",
    "N10",   "N11",   "N12",   "N13",   "N14",   "N15",   "N16",   "N17",   "N18",   "N19",   "N20",   "N21",   "N22",
    "N23",   "N24",   "N25",   "N",     "O12",   "O13",   "O14",   "O15",   "O16",   "O17",   "O18",   "O19",   "O20",
    "O21",   "O22",   "O23",   "O24",   "O25",   "O26",   "O27",   "O28",   "O",     "F14",   "F15",   "F16",   "F17",
    "F18",   "F19",   "F20",   "F21",   "F22",   "F23",   "F24",   "F25",   "F26",   "F27",   "F28",   "F29",   "F30",
    "F31",   "F",     "NE16",  "NE17",  "NE18",  "NE19",  "NE20",  "NE21",  "NE22",  "NE23",  "NE24",  "NE25",  "NE26",
    "NE27",  "NE28",  "NE29",  "NE30",  "NE31",  "NE32",  "NE33",  "NE34",  "NE",    "NA18",  "NA19",  "NA20",  "NA21",
    "NA22",  "NA23",  "NA24",  "NA25",  "NA26",  "NA27",  "NA28",  "NA29",  "NA30",  "NA31",  "NA32",  "NA33",  "NA34",
    "NA35",  "NA36",  "NA37",  "NA",    "MG19",  "MG20",  "MG21",  "MG22",  "MG23",  "MG24",  "MG25",  "MG26",  "MG27",
    "MG28",  "MG29",  "MG30",  "MG31",  "MG32",  "MG33",  "MG34",  "MG35",  "MG36",  "MG37",  "MG38",  "MG39",  "MG40",
    "MG",    "AL21",  "AL22",  "AL23",  "AL24",  "AL25",  "AL26",  "AL27",  "AL28",  "AL29",  "AL30",  "AL31",  "AL32",
    "AL33",  "AL34",  "AL35",  "AL36",  "AL37",  "AL38",  "AL39",  "AL40",  "AL41",  "AL42",  "AL43",  "AL",    "SI22",
    "SI23",  "SI24",  "SI25",  "SI26",  "SI27",  "SI28",  "SI29",  "SI30",  "SI31",  "SI32",  "SI33",  "SI34",  "SI35",
    "SI36",  "SI37",  "SI38",  "SI39",  "SI40",  "SI41",  "SI42",  "SI43",  "SI44",  "SI45",  "SI",    "P24",   "P25",
    "P26",   "P27",   "P28",   "P29",   "P30",   "P31",   "P32",   "P33",   "P34",   "P35",   "P36",   "P37",   "P38",
    "P39",   "P40",   "P41",   "P42",   "P43",   "P44",   "P45",   "P46",   "P47",   "P",     "S26",   "S27",   "S28",
    "S29",   "S30",   "S31",   "S32",   "S33",   "S34",   "S35",   "S36",   "S37",   "S38",   "S39",   "S40",   "S41",
    "S42",   "S43",   "S44",   "S45",   "S46",   "S47",   "S48",   "S49",   "S",     "CL28",  "CL29",  "CL30",  "CL31",
    "CL32",  "CL33",  "CL34",  "CL35",  "CL36",  "CL37",  "CL38",  "CL39",  "CL40",  "CL41",  "CL42",  "CL43",  "CL44",
    "CL45",  "CL46",  "CL47",  "CL48",  "CL49",  "CL50",  "CL51",  "CL",    "AR30",  "AR31",  "AR32",  "AR33",  "AR34",
    "AR35",  "AR36",  "AR37",  "AR38",  "AR39",  "AR40",  "AR41",  "AR42",  "AR43",  "AR44",  "AR45",  "AR46",  "AR47",
    "AR48",  "AR49",  "AR50",  "AR51",  "AR52",  "AR53",  "AR",    "K32",   "K33",   "K34",   "K35",   "K36",   "K37",
    "K38",   "K39",   "K40",   "K41",   "K42",   "K43",   "K44",   "K45",   "K46",   "K47",   "K48",   "K49",   "K50",
    "K51",   "K52",   "K53",   "K54",   "K55",   "K56",   "K",     "CA34",  "CA35",  "CA36",  "CA37",  "CA38",  "CA39",
    "CA40",  "CA41",  "CA42",  "CA43",  "CA44",  "CA45",  "CA46",  "CA47",  "CA48",  "CA49",  "CA50",  "CA51",  "CA52",
    "CA53",  "CA54",  "CA55",  "CA56",  "CA57",  "CA58",  "CA",    "SC36",  "SC37",  "SC38",  "SC39",  "SC40",  "SC41",
    "SC42",  "SC43",  "SC44",  "SC45",  "SC46",  "SC47",  "SC48",  "SC49",  "SC50",  "SC51",  "SC52",  "SC53",  "SC54",
    "SC55",  "SC56",  "SC57",  "SC58",  "SC59",  "SC60",  "SC61",  "SC",    "TI38",  "TI39",  "TI40",  "TI41",  "TI42",
    "TI43",  "TI44",  "TI45",  "TI46",  "TI47",  "TI48",  "TI49",  "TI50",  "TI51",  "TI52",  "TI53",  "TI54",  "TI55",
    "TI56",  "TI57",  "TI58",  "TI59",  "TI60",  "TI61",  "TI62",  "TI63",  "TI",    "V40",   "V41",   "V42",   "V43",
    "V44",   "V45",   "V46",   "V47",   "V48",   "V49",   "V50",   "V51",   "V52",   "V53",   "V54",   "V55",   "V56",
    "V57",   "V58",   "V59",   "V60",   "V61",   "V62",   "V63",   "V64",   "V65",   "V66",   "V",     "CR42",  "CR43",
    "CR44",  "CR45",  "CR46",  "CR47",  "CR48",  "CR49",  "CR50",  "CR51",  "CR52",  "CR53",  "CR54",  "CR55",  "CR56",
    "CR57",  "CR58",  "CR59",  "CR60",  "CR61",  "CR62",  "CR63",  "CR64",  "CR65",  "CR66",  "CR67",  "CR68",  "CR",
    "MN44",  "MN45",  "MN46",  "MN47",  "MN48",  "MN49",  "MN50",  "MN51",  "MN52",  "MN53",  "MN54",  "MN55",  "MN56",
    "MN57",  "MN58",  "MN59",  "MN60",  "MN61",  "MN62",  "MN63",  "MN64",  "MN65",  "MN66",  "MN67",  "MN68",  "MN69",
    "MN70",  "MN71",  "MN",    "FE45",  "FE46",  "FE47",  "FE48",  "FE49",  "FE50",  "FE51",  "FE52",  "FE53",  "FE54",
    "FE55",  "FE56",  "FE57",  "FE58",  "FE59",  "FE60",  "FE61",  "FE62",  "FE63",  "FE64",  "FE65",  "FE66",  "FE67",
    "FE68",  "FE69",  "FE70",  "FE71",  "FE72",  "FE73",  "FE74",  "FE",    "CO47",  "CO48",  "CO49",  "CO50",  "CO51",
    "CO52",  "CO53",  "CO54",  "CO55",  "CO56",  "CO57",  "CO58",  "CO59",  "CO60",  "CO61",  "CO62",  "CO63",  "CO64",
    "CO65",  "CO66",  "CO67",  "CO68",  "CO69",  "CO70",  "CO71",  "CO72",  "CO73",  "CO74",  "CO75",  "CO76",  "CO",
    "NI48",  "NI49",  "NI50",  "NI51",  "NI52",  "NI53",  "NI54",  "NI55",  "NI56",  "NI57",  "NI58",  "NI59",  "NI60",
    "NI61",  "NI62",  "NI63",  "NI64",  "NI65",  "NI66",  "NI67",  "NI68",  "NI69",  "NI70",  "NI71",  "NI72",  "NI73",
    "NI74",  "NI75",  "NI76",  "NI77",  "NI78",  "NI79",  "NI",    "CU52",  "CU53",  "CU54",  "CU55",  "CU56",  "CU57",
    "CU58",  "CU59",  "CU60",  "CU61",  "CU62",  "CU63",  "CU64",  "CU65",  "CU66",  "CU67",  "CU68",  "CU69",  "CU70",
    "CU71",  "CU72",  "CU73",  "CU74",  "CU75",  "CU76",  "CU77",  "CU78",  "CU79",  "CU80",  "CU81",  "CU82",  "CU",
    "ZN54",  "ZN55",  "ZN56",  "ZN57",  "ZN58",  "ZN59",  "ZN60",  "ZN61",  "ZN62",  "ZN63",  "ZN64",  "ZN65",  "ZN66",
    "ZN67",  "ZN68",  "ZN69",  "ZN70",  "ZN71",  "ZN72",  "ZN73",  "ZN74",  "ZN75",  "ZN76",  "ZN77",  "ZN78",  "ZN79",
    "ZN80",  "ZN81",  "ZN82",  "ZN83",  "ZN84",  "ZN85",  "ZN",    "GA56",  "GA57",  "GA58",  "GA59",  "GA60",  "GA61",
    "GA62",  "GA63",  "GA64",  "GA65",  "GA66",  "GA67",  "GA68",  "GA69",  "GA70",  "GA71",  "GA72",  "GA73",  "GA74",
    "GA75",  "GA76",  "GA77",  "GA78",  "GA79",  "GA80",  "GA81",  "GA82",  "GA83",  "GA84",  "GA85",  "GA86",  "GA87",
    "GA",    "GE58",  "GE59",  "GE60",  "GE61",  "GE62",  "GE63",  "GE64",  "GE65",  "GE66",  "GE67",  "GE68",  "GE69",
    "GE70",  "GE71",  "GE72",  "GE73",  "GE74",  "GE75",  "GE76",  "GE77",  "GE78",  "GE79",  "GE80",  "GE81",  "GE82",
    "GE83",  "GE84",  "GE85",  "GE86",  "GE87",  "GE88",  "GE89",  "GE90",  "GE",    "AS60",  "AS61",  "AS62",  "AS63",
    "AS64",  "AS65",  "AS66",  "AS67",  "AS68",  "AS69",  "AS70",  "AS71",  "AS72",  "AS73",  "AS74",  "AS75",  "AS76",
    "AS77",  "AS78",  "AS79",  "AS80",  "AS81",  "AS82",  "AS83",  "AS84",  "AS85",  "AS86",  "AS87",  "AS88",  "AS89",
    "AS90",  "AS91",  "AS92",  "AS",    "SE64",  "SE65",  "SE66",  "SE67",  "SE68",  "SE69",  "SE70",  "SE71",  "SE72",
    "SE73",  "SE74",  "SE75",  "SE76",  "SE77",  "SE78",  "SE79",  "SE80",  "SE81",  "SE82",  "SE83",  "SE84",  "SE85",
    "SE86",  "SE87",  "SE88",  "SE89",  "SE90",  "SE91",  "SE92",  "SE93",  "SE94",  "SE95",  "SE",    "BR67",  "BR68",
    "BR69",  "BR70",  "BR71",  "BR72",  "BR73",  "BR74",  "BR75",  "BR76",  "BR77",  "BR78",  "BR79",  "BR80",  "BR81",
    "BR82",  "BR83",  "BR84",  "BR85",  "BR86",  "BR87",  "BR88",  "BR89",  "BR90",  "BR91",  "BR92",  "BR93",  "BR94",
    "BR95",  "BR96",  "BR97",  "BR98",  "BR",    "KR69",  "KR70",  "KR71",  "KR72",  "KR73",  "KR74",  "KR75",  "KR76",
    "KR77",  "KR78",  "KR79",  "KR80",  "KR81",  "KR82",  "KR83",  "KR84",  "KR85",  "KR86",  "KR87",  "KR88",  "KR89",
    "KR90",  "KR91",  "KR92",  "KR93",  "KR94",  "KR95",  "KR96",  "KR97",  "KR98",  "KR99",  "KR100", "KR101", "KR",
    "RB71",  "RB72",  "RB73",  "RB74",  "RB75",  "RB76",  "RB77",  "RB78",  "RB79",  "RB80",  "RB81",  "RB82",  "RB83",
    "RB84",  "RB85",  "RB86",  "RB87",  "RB88",  "RB89",  "RB90",  "RB91",  "RB92",  "RB93",  "RB94",  "RB95",  "RB96",
    "RB97",  "RB98",  "RB99",  "RB100", "RB101", "RB102", "RB103", "RB",    "SR73",  "SR74",  "SR75",  "SR76",  "SR77",
    "SR78",  "SR79",  "SR80",  "SR81",  "SR82",  "SR83",  "SR84",  "SR85",  "SR86",  "SR87",  "SR88",  "SR89",  "SR90",
    "SR91",  "SR92",  "SR93",  "SR94",  "SR95",  "SR96",  "SR97",  "SR98",  "SR99",  "SR100", "SR101", "SR102", "SR103",
    "SR104", "SR105", "SR106", "SR107", "SR",    "Y76",   "Y77",   "Y78",   "Y79",   "Y80",   "Y81",   "Y82",   "Y83",
    "Y84",   "Y85",   "Y86",   "Y87",   "Y88",   "Y89",   "Y90",   "Y91",   "Y92",   "Y93",   "Y94",   "Y95",   "Y96",
    "Y97",   "Y98",   "Y99",   "Y100",  "Y101",  "Y102",  "Y103",  "Y104",  "Y105",  "Y106",  "Y107",  "Y108",  "Y109",
    "Y",     "ZR78",  "ZR79",  "ZR80",  "ZR81",  "ZR82",  "ZR83",  "ZR84",  "ZR85",  "ZR86",  "ZR87",  "ZR88",  "ZR89",
    "ZR90",  "ZR91",  "ZR92",  "ZR93",  "ZR94",  "ZR95",  "ZR96",  "ZR97",  "ZR98",  "ZR99",  "ZR100", "ZR101", "ZR102",
    "ZR103", "ZR104", "ZR105", "ZR106", "ZR107", "ZR108", "ZR109", "ZR110", "ZR111", "ZR112", "ZR",    "NB81",  "NB82",
    "NB83",  "NB84",  "NB85",  "NB86",  "NB87",  "NB88",  "NB89",  "NB90",  "NB91",  "NB92",  "NB93",  "NB94",  "NB95",
    "NB96",  "NB97",  "NB98",  "NB99",  "NB100", "NB101", "NB102", "NB103", "NB104", "NB105", "NB106", "NB107", "NB108",
    "NB109", "NB110", "NB111", "NB112", "NB113", "NB114", "NB115", "NB",    "MO83",  "MO84",  "MO85",  "MO86",  "MO87",
    "MO88",  "MO89",  "MO90",  "MO91",  "MO92",  "MO93",  "MO94",  "MO95",  "MO96",  "MO97",  "MO98",  "MO99",  "MO100",
    "MO101", "MO102", "MO103", "MO104", "MO105", "MO106", "MO107", "MO108", "MO109", "MO110", "MO111", "MO112", "MO113",
    "MO114", "MO115", "MO116", "MO117", "MO",    "TC85",  "TC86",  "TC87",  "TC88",  "TC89",  "TC90",  "TC91",  "TC92",
    "TC93",  "TC94",  "TC95",  "TC96",  "TC97",  "TC98",  "TC99",  "TC100", "TC101", "TC102", "TC103", "TC104", "TC105",
    "TC106", "TC107", "TC108", "TC109", "TC110", "TC111", "TC112", "TC113", "TC114", "TC115", "TC116", "TC117", "TC118",
    "TC119", "TC120", "TC",    "RU87",  "RU88",  "RU89",  "RU90",  "RU91",  "RU92",  "RU93",  "RU94",  "RU95",  "RU96",
    "RU97",  "RU98",  "RU99",  "RU100", "RU101", "RU102", "RU103", "RU104", "RU105", "RU106", "RU107", "RU108", "RU109",
    "RU110", "RU111", "RU112", "RU113", "RU114", "RU115", "RU116", "RU117", "RU118", "RU119", "RU120", "RU121", "RU122",
    "RU123", "RU124", "RU",    "RH89",  "RH90",  "RH91",  "RH92",  "RH93",  "RH94",  "RH95",  "RH96",  "RH97",  "RH98",
    "RH99",  "RH100", "RH101", "RH102", "RH103", "RH104", "RH105", "RH106", "RH107", "RH108", "RH109", "RH110", "RH111",
    "RH112", "RH113", "RH114", "RH115", "RH116", "RH117", "RH118", "RH119", "RH120", "RH121", "RH122", "RH123", "RH124",
    "RH125", "RH126", "RH",    "PD91",  "PD92",  "PD93",  "PD94",  "PD95",  "PD96",  "PD97",  "PD98",  "PD99",  "PD100",
    "PD101", "PD102", "PD103", "PD104", "PD105", "PD106", "PD107", "PD108", "PD109", "PD110", "PD111", "PD112", "PD113",
    "PD114", "PD115", "PD116", "PD117", "PD118", "PD119", "PD120", "PD121", "PD122", "PD123", "PD124", "PD125", "PD126",
    "PD127", "PD128", "PD",    "AG93",  "AG94",  "AG95",  "AG96",  "AG97",  "AG98",  "AG99",  "AG100", "AG101", "AG102",
    "AG103", "AG104", "AG105", "AG106", "AG107", "AG108", "AG109", "AG110", "AG111", "AG112", "AG113", "AG114", "AG115",
    "AG116", "AG117", "AG118", "AG119", "AG120", "AG121", "AG122", "AG123", "AG124", "AG125", "AG126", "AG127", "AG128",
    "AG129", "AG130", "AG",    "CD95",  "CD96",  "CD97",  "CD98",  "CD99",  "CD100", "CD101", "CD102", "CD103", "CD104",
    "CD105", "CD106", "CD107", "CD108", "CD109", "CD110", "CD111", "CD112", "CD113", "CD114", "CD115", "CD116", "CD117",
    "CD118", "CD119", "CD120", "CD121", "CD122", "CD123", "CD124", "CD125", "CD126", "CD127", "CD128", "CD129", "CD130",
    "CD131", "CD132", "CD133", "CD",    "IN97",  "IN98",  "IN99",  "IN100", "IN101", "IN102", "IN103", "IN104", "IN105",
    "IN106", "IN107", "IN108", "IN109", "IN110", "IN111", "IN112", "IN113", "IN114", "IN115", "IN116", "IN117", "IN118",
    "IN119", "IN120", "IN121", "IN122", "IN123", "IN124", "IN125", "IN126", "IN127", "IN128", "IN129", "IN130", "IN131",
    "IN132", "IN133", "IN134", "IN135", "IN",    "SN99",  "SN100", "SN101", "SN102", "SN103", "SN104", "SN105", "SN106",
    "SN107", "SN108", "SN109", "SN110", "SN111", "SN112", "SN113", "SN114", "SN115", "SN116", "SN117", "SN118", "SN119",
    "SN120", "SN121", "SN122", "SN123", "SN124", "SN125", "SN126", "SN127", "SN128", "SN129", "SN130", "SN131", "SN132",
    "SN133", "SN134", "SN135", "SN136", "SN137", "SN138", "SN",    "SB103", "SB104", "SB105", "SB106", "SB107", "SB108",
    "SB109", "SB110", "SB111", "SB112", "SB113", "SB114", "SB115", "SB116", "SB117", "SB118", "SB119", "SB120", "SB121",
    "SB122", "SB123", "SB124", "SB125", "SB126", "SB127", "SB128", "SB129", "SB130", "SB131", "SB132", "SB133", "SB134",
    "SB135", "SB136", "SB137", "SB138", "SB139", "SB140", "SB",    "TE105", "TE106", "TE107", "TE108", "TE109", "TE110",
    "TE111", "TE112", "TE113", "TE114", "TE115", "TE116", "TE117", "TE118", "TE119", "TE120", "TE121", "TE122", "TE123",
    "TE124", "TE125", "TE126", "TE127", "TE128", "TE129", "TE130", "TE131", "TE132", "TE133", "TE134", "TE135", "TE136",
    "TE137", "TE138", "TE139", "TE140", "TE141", "TE142", "TE143", "TE",    "I107",  "I108",  "I109",  "I110",  "I111",
    "I112",  "I113",  "I114",  "I115",  "I116",  "I117",  "I118",  "I119",  "I120",  "I121",  "I122",  "I123",  "I124",
    "I125",  "I126",  "I127",  "I128",  "I129",  "I130",  "I131",  "I132",  "I133",  "I134",  "I135",  "I136",  "I137",
    "I138",  "I139",  "I140",  "I141",  "I142",  "I143",  "I144",  "I145",  "I",     "XE109", "XE110", "XE111", "XE112",
    "XE113", "XE114", "XE115", "XE116", "XE117", "XE118", "XE119", "XE120", "XE121", "XE122", "XE123", "XE124", "XE125",
    "XE126", "XE127", "XE128", "XE129", "XE130", "XE131", "XE132", "XE133", "XE134", "XE135", "XE136", "XE137", "XE138",
    "XE139", "XE140", "XE141", "XE142", "XE143", "XE144", "XE145", "XE146", "XE147", "XE148", "XE",    "CS112", "CS113",
    "CS114", "CS115", "CS116", "CS117", "CS118", "CS119", "CS120", "CS121", "CS122", "CS123", "CS124", "CS125", "CS126",
    "CS127", "CS128", "CS129", "CS130", "CS131", "CS132", "CS133", "CS134", "CS135", "CS136", "CS137", "CS138", "CS139",
    "CS140", "CS141", "CS142", "CS143", "CS144", "CS145", "CS146", "CS147", "CS148", "CS149", "CS150", "CS151", "CS",
    "BA114", "BA115", "BA116", "BA117", "BA118", "BA119", "BA120", "BA121", "BA122", "BA123", "BA124", "BA125", "BA126",
    "BA127", "BA128", "BA129", "BA130", "BA131", "BA132", "BA133", "BA134", "BA135", "BA136", "BA137", "BA138", "BA139",
    "BA140", "BA141", "BA142", "BA143", "BA144", "BA145", "BA146", "BA147", "BA148", "BA149", "BA150", "BA151", "BA152",
    "BA153", "BA",    "LA116", "LA117", "LA118", "LA119", "LA120", "LA121", "LA122", "LA123", "LA124", "LA125", "LA126",
    "LA127", "LA128", "LA129", "LA130", "LA131", "LA132", "LA133", "LA134", "LA135", "LA136", "LA137", "LA138", "LA139",
    "LA140", "LA141", "LA142", "LA143", "LA144", "LA145", "LA146", "LA147", "LA148", "LA149", "LA150", "LA151", "LA152",
    "LA153", "LA154", "LA155", "LA",    "CE119", "CE120", "CE121", "CE122", "CE123", "CE124", "CE125", "CE126", "CE127",
    "CE128", "CE129", "CE130", "CE131", "CE132", "CE133", "CE134", "CE135", "CE136", "CE137", "CE138", "CE139", "CE140",
    "CE141", "CE142", "CE143", "CE144", "CE145", "CE146", "CE147", "CE148", "CE149", "CE150", "CE151", "CE152", "CE153",
    "CE154", "CE155", "CE156", "CE157", "CE",    "PR121", "PR122", "PR123", "PR124", "PR125", "PR126", "PR127", "PR128",
    "PR129", "PR130", "PR131", "PR132", "PR133", "PR134", "PR135", "PR136", "PR137", "PR138", "PR139", "PR140", "PR141",
    "PR142", "PR143", "PR144", "PR145", "PR146", "PR147", "PR148", "PR149", "PR150", "PR151", "PR152", "PR153", "PR154",
    "PR155", "PR156", "PR157", "PR158", "PR159", "PR",    "ND124", "ND125", "ND126", "ND127", "ND128", "ND129", "ND130",
    "ND131", "ND132", "ND133", "ND134", "ND135", "ND136", "ND137", "ND138", "ND139", "ND140", "ND141", "ND142", "ND143",
    "ND144", "ND145", "ND146", "ND147", "ND148", "ND149", "ND150", "ND151", "ND152", "ND153", "ND154", "ND155", "ND156",
    "ND157", "ND158", "ND159", "ND160", "ND161", "ND",    "PM126", "PM127", "PM128", "PM129", "PM130", "PM131", "PM132",
    "PM133", "PM134", "PM135", "PM136", "PM137", "PM138", "PM139", "PM140", "PM141", "PM142", "PM143", "PM144", "PM145",
    "PM146", "PM147", "PM148", "PM149", "PM150", "PM151", "PM152", "PM153", "PM154", "PM155", "PM156", "PM157", "PM158",
    "PM159", "PM160", "PM161", "PM162", "PM163", "PM",    "SM128", "SM129", "SM130", "SM131", "SM132", "SM133", "SM134",
    "SM135", "SM136", "SM137", "SM138", "SM139", "SM140", "SM141", "SM142", "SM143", "SM144", "SM145", "SM146", "SM147",
    "SM148", "SM149", "SM150", "SM151", "SM152", "SM153", "SM154", "SM155", "SM156", "SM157", "SM158", "SM159", "SM160",
    "SM161", "SM162", "SM163", "SM164", "SM165", "SM",    "EU130", "EU131", "EU132", "EU133", "EU134", "EU135", "EU136",
    "EU137", "EU138", "EU139", "EU140", "EU141", "EU142", "EU143", "EU144", "EU145", "EU146", "EU147", "EU148", "EU149",
    "EU150", "EU151", "EU152", "EU153", "EU154", "EU155", "EU156", "EU157", "EU158", "EU159", "EU160", "EU161", "EU162",
    "EU163", "EU164", "EU165", "EU166", "EU167", "EU",    "GD133", "GD134", "GD135", "GD136", "GD137", "GD138", "GD139",
    "GD140", "GD141", "GD142", "GD143", "GD144", "GD145", "GD146", "GD147", "GD148", "GD149", "GD150", "GD151", "GD152",
    "GD153", "GD154", "GD155", "GD156", "GD157", "GD158", "GD159", "GD160", "GD161", "GD162", "GD163", "GD164", "GD165",
    "GD166", "GD167", "GD168", "GD169", "GD",    "TB135", "TB136", "TB137", "TB138", "TB139", "TB140", "TB141", "TB142",
    "TB143", "TB144", "TB145", "TB146", "TB147", "TB148", "TB149", "TB150", "TB151", "TB152", "TB153", "TB154", "TB155",
    "TB156", "TB157", "TB158", "TB159", "TB160", "TB161", "TB162", "TB163", "TB164", "TB165", "TB166", "TB167", "TB168",
    "TB169", "TB170", "TB171", "TB",    "DY138", "DY139", "DY140", "DY141", "DY142", "DY143", "DY144", "DY145", "DY146",
    "DY147", "DY148", "DY149", "DY150", "DY151", "DY152", "DY153", "DY154", "DY155", "DY156", "DY157", "DY158", "DY159",
    "DY160", "DY161", "DY162", "DY163", "DY164", "DY165", "DY166", "DY167", "DY168", "DY169", "DY170", "DY171", "DY172",
    "DY173", "DY",    "HO140", "HO141", "HO142", "HO143", "HO144", "HO145", "HO146", "HO147", "HO148", "HO149", "HO150",
    "HO151", "HO152", "HO153", "HO154", "HO155", "HO156", "HO157", "HO158", "HO159", "HO160", "HO161", "HO162", "HO163",
    "HO164", "HO165", "HO166", "HO167", "HO168", "HO169", "HO170", "HO171", "HO172", "HO173", "HO174", "HO175", "HO",
    "ER142", "ER143", "ER144", "ER145", "ER146", "ER147", "ER148", "ER149", "ER150", "ER151", "ER152", "ER153", "ER154",
    "ER155", "ER156", "ER157", "ER158", "ER159", "ER160", "ER161", "ER162", "ER163", "ER164", "ER165", "ER166", "ER167",
    "ER168", "ER169", "ER170", "ER171", "ER172", "ER173", "ER174", "ER175", "ER176", "ER177", "ER",    "TM144", "TM145",
    "TM146", "TM147", "TM148", "TM149", "TM150", "TM151", "TM152", "TM153", "TM154", "TM155", "TM156", "TM157", "TM158",
    "TM159", "TM160", "TM161", "TM162", "TM163", "TM164", "TM165", "TM166", "TM167", "TM168", "TM169", "TM170", "TM171",
    "TM172", "TM173", "TM174", "TM175", "TM176", "TM177", "TM178", "TM179", "TM",    "YB148", "YB149", "YB150", "YB151",
    "YB152", "YB153", "YB154", "YB155", "YB156", "YB157", "YB158", "YB159", "YB160", "YB161", "YB162", "YB163", "YB164",
    "YB165", "YB166", "YB167", "YB168", "YB169", "YB170", "YB171", "YB172", "YB173", "YB174", "YB175", "YB176", "YB177",
    "YB178", "YB179", "YB180", "YB181", "YB",    "LU150", "LU151", "LU152", "LU153", "LU154", "LU155", "LU156", "LU157",
    "LU158", "LU159", "LU160", "LU161", "LU162", "LU163", "LU164", "LU165", "LU166", "LU167", "LU168", "LU169", "LU170",
    "LU171", "LU172", "LU173", "LU174", "LU175", "LU176", "LU177", "LU178", "LU179", "LU180", "LU181", "LU182", "LU183",
    "LU184", "LU185", "LU",    "HF153", "HF154", "HF155", "HF156", "HF157", "HF158", "HF159", "HF160", "HF161", "HF162",
    "HF163", "HF164", "HF165", "HF166", "HF167", "HF168", "HF169", "HF170", "HF171", "HF172", "HF173", "HF174", "HF175",
    "HF176", "HF177", "HF178", "HF179", "HF180", "HF181", "HF182", "HF183", "HF184", "HF185", "HF186", "HF187", "HF188",
    "HF189", "HF",    "TA155", "TA156", "TA157", "TA158", "TA159", "TA160", "TA161", "TA162", "TA163", "TA164", "TA165",
    "TA166", "TA167", "TA168", "TA169", "TA170", "TA171", "TA172", "TA173", "TA174", "TA175", "TA176", "TA177", "TA178",
    "TA179", "TA180", "TA181", "TA182", "TA183", "TA184", "TA185", "TA186", "TA187", "TA188", "TA189", "TA190", "TA191",
    "TA192", "TA",    "W157",  "W158",  "W159",  "W160",  "W161",  "W162",  "W163",  "W164",  "W165",  "W166",  "W167",
    "W168",  "W169",  "W170",  "W171",  "W172",  "W173",  "W174",  "W175",  "W176",  "W177",  "W178",  "W179",  "W180",
    "W181",  "W182",  "W183",  "W184",  "W185",  "W186",  "W187",  "W188",  "W189",  "W190",  "W191",  "W192",  "W193",
    "W194",  "W",     "RE159", "RE160", "RE161", "RE162", "RE163", "RE164", "RE165", "RE166", "RE167", "RE168", "RE169",
    "RE170", "RE171", "RE172", "RE173", "RE174", "RE175", "RE176", "RE177", "RE178", "RE179", "RE180", "RE181", "RE182",
    "RE183", "RE184", "RE185", "RE186", "RE187", "RE188", "RE189", "RE190", "RE191", "RE192", "RE193", "RE194", "RE195",
    "RE196", "RE197", "RE198", "RE",    "OS161", "OS162", "OS163", "OS164", "OS165", "OS166", "OS167", "OS168", "OS169",
    "OS170", "OS171", "OS172", "OS173", "OS174", "OS175", "OS176", "OS177", "OS178", "OS179", "OS180", "OS181", "OS182",
    "OS183", "OS184", "OS185", "OS186", "OS187", "OS188", "OS189", "OS190", "OS191", "OS192", "OS193", "OS194", "OS195",
    "OS196", "OS197", "OS198", "OS199", "OS200", "OS201", "OS202", "OS",    "IR164", "IR165", "IR166", "IR167", "IR168",
    "IR169", "IR170", "IR171", "IR172", "IR173", "IR174", "IR175", "IR176", "IR177", "IR178", "IR179", "IR180", "IR181",
    "IR182", "IR183", "IR184", "IR185", "IR186", "IR187", "IR188", "IR189", "IR190", "IR191", "IR192", "IR193", "IR194",
    "IR195", "IR196", "IR197", "IR198", "IR199", "IR200", "IR201", "IR202", "IR203", "IR204", "IR",    "PT166", "PT167",
    "PT168", "PT169", "PT170", "PT171", "PT172", "PT173", "PT174", "PT175", "PT176", "PT177", "PT178", "PT179", "PT180",
    "PT181", "PT182", "PT183", "PT184", "PT185", "PT186", "PT187", "PT188", "PT189", "PT190", "PT191", "PT192", "PT193",
    "PT194", "PT195", "PT196", "PT197", "PT198", "PT199", "PT200", "PT201", "PT202", "PT203", "PT204", "PT205", "PT206",
    "PT",    "AU169", "AU170", "AU171", "AU172", "AU173", "AU174", "AU175", "AU176", "AU177", "AU178", "AU179", "AU180",
    "AU181", "AU182", "AU183", "AU184", "AU185", "AU186", "AU187", "AU188", "AU189", "AU190", "AU191", "AU192", "AU193",
    "AU194", "AU195", "AU196", "AU197", "AU198", "AU199", "AU200", "AU201", "AU202", "AU203", "AU204", "AU205", "AU206",
    "AU207", "AU208", "AU209", "AU210", "AU",    "HG171", "HG172", "HG173", "HG174", "HG175", "HG176", "HG177", "HG178",
    "HG179", "HG180", "HG181", "HG182", "HG183", "HG184", "HG185", "HG186", "HG187", "HG188", "HG189", "HG190", "HG191",
    "HG192", "HG193", "HG194", "HG195", "HG196", "HG197", "HG198", "HG199", "HG200", "HG201", "HG202", "HG203", "HG204",
    "HG205", "HG206", "HG207", "HG208", "HG209", "HG210", "HG211", "HG212", "HG213", "HG214", "HG215", "HG216", "HG",
    "TL176", "TL177", "TL178", "TL179", "TL180", "TL181", "TL182", "TL183", "TL184", "TL185", "TL186", "TL187", "TL188",
    "TL189", "TL190", "TL191", "TL192", "TL193", "TL194", "TL195", "TL196", "TL197", "TL198", "TL199", "TL200", "TL201",
    "TL202", "TL203", "TL204", "TL205", "TL206", "TL207", "TL208", "TL209", "TL210", "TL211", "TL212", "TL213", "TL214",
    "TL215", "TL216", "TL217", "TL218", "TL",    "PB178", "PB179", "PB180", "PB181", "PB182", "PB183", "PB184", "PB185",
    "PB186", "PB187", "PB188", "PB189", "PB190", "PB191", "PB192", "PB193", "PB194", "PB195", "PB196", "PB197", "PB198",
    "PB199", "PB200", "PB201", "PB202", "PB203", "PB204", "PB205", "PB206", "PB207", "PB208", "PB209", "PB210", "PB211",
    "PB212", "PB213", "PB214", "PB215", "PB216", "PB217", "PB218", "PB219", "PB220", "PB",    "BI184", "BI185", "BI186",
    "BI187", "BI188", "BI189", "BI190", "BI191", "BI192", "BI193", "BI194", "BI195", "BI196", "BI197", "BI198", "BI199",
    "BI200", "BI201", "BI202", "BI203", "BI204", "BI205", "BI206", "BI207", "BI208", "BI209", "BI210", "BI211", "BI212",
    "BI213", "BI214", "BI215", "BI216", "BI217", "BI218", "BI219", "BI220", "BI221", "BI222", "BI223", "BI224", "BI",
    "PO186", "PO187", "PO188", "PO189", "PO190", "PO191", "PO192", "PO193", "PO194", "PO195", "PO196", "PO197", "PO198",
    "PO199", "PO200", "PO201", "PO202", "PO203", "PO204", "PO205", "PO206", "PO207", "PO208", "PO209", "PO210", "PO211",
    "PO212", "PO213", "PO214", "PO215", "PO216", "PO217", "PO218", "PO219", "PO220", "PO221", "PO222", "PO223", "PO224",
    "PO225", "PO226", "PO227", "PO",    "AT191", "AT192", "AT193", "AT194", "AT195", "AT196", "AT197", "AT198", "AT199",
    "AT200", "AT201", "AT202", "AT203", "AT204", "AT205", "AT206", "AT207", "AT208", "AT209", "AT210", "AT211", "AT212",
    "AT213", "AT214", "AT215", "AT216", "AT217", "AT218", "AT219", "AT220", "AT221", "AT222", "AT223", "AT224", "AT225",
    "AT226", "AT227", "AT228", "AT229", "AT",    "RN193", "RN194", "RN195", "RN196", "RN197", "RN198", "RN199", "RN200",
    "RN201", "RN202", "RN203", "RN204", "RN205", "RN206", "RN207", "RN208", "RN209", "RN210", "RN211", "RN212", "RN213",
    "RN214", "RN215", "RN216", "RN217", "RN218", "RN219", "RN220", "RN221", "RN222", "RN223", "RN224", "RN225", "RN226",
    "RN227", "RN228", "RN229", "RN230", "RN231", "RN",    "FR199", "FR200", "FR201", "FR202", "FR203", "FR204", "FR205",
    "FR206", "FR207", "FR208", "FR209", "FR210", "FR211", "FR212", "FR213", "FR214", "FR215", "FR216", "FR217", "FR218",
    "FR219", "FR220", "FR221", "FR222", "FR223", "FR224", "FR225", "FR226", "FR227", "FR228", "FR229", "FR230", "FR231",
    "FR232", "FR233", "FR",    "RA201", "RA202", "RA203", "RA204", "RA205", "RA206", "RA207", "RA208", "RA209", "RA210",
    "RA211", "RA212", "RA213", "RA214", "RA215", "RA216", "RA217", "RA218", "RA219", "RA220", "RA221", "RA222", "RA223",
    "RA224", "RA225", "RA226", "RA227", "RA228", "RA229", "RA230", "RA231", "RA232", "RA233", "RA234", "RA235", "RA",
    "AC206", "AC207", "AC208", "AC209", "AC210", "AC211", "AC212", "AC213", "AC214", "AC215", "AC216", "AC217", "AC218",
    "AC219", "AC220", "AC221", "AC222", "AC223", "AC224", "AC225", "AC226", "AC227", "AC228", "AC229", "AC230", "AC231",
    "AC232", "AC233", "AC234", "AC235", "AC236", "AC237", "AC",    "TH208", "TH209", "TH210", "TH211", "TH212", "TH213",
    "TH214", "TH215", "TH216", "TH217", "TH218", "TH219", "TH220", "TH221", "TH222", "TH223", "TH224", "TH225", "TH226",
    "TH227", "TH228", "TH229", "TH230", "TH231", "TH232", "TH233", "TH234", "TH235", "TH236", "TH237", "TH238", "TH239",
    "TH",    "PA212", "PA213", "PA214", "PA215", "PA216", "PA217", "PA218", "PA219", "PA220", "PA221", "PA222", "PA223",
    "PA224", "PA225", "PA226", "PA227", "PA228", "PA229", "PA230", "PA231", "PA232", "PA233", "PA234", "PA235", "PA236",
    "PA237", "PA238", "PA239", "PA240", "PA241", "PA",    "U217",  "U218",  "U219",  "U220",  "U221",  "U222",  "U223",
    "U224",  "U225",  "U226",  "U227",  "U228",  "U229",  "U230",  "U231",  "U232",  "U233",  "U234",  "U235",  "U236",
    "U237",  "U238",  "U239",  "U240",  "U241",  "U242",  "U243",  "U",     "NP219", "NP220", "NP221", "NP222", "NP223",
    "NP224", "NP225", "NP226", "NP227", "NP228", "NP229", "NP230", "NP231", "NP232", "NP233", "NP234", "NP235", "NP236",
    "NP237", "NP238", "NP239", "NP240", "NP241", "NP242", "NP243", "NP244", "NP245", "NP",    "PU228", "PU229", "PU230",
    "PU231", "PU232", "PU233", "PU234", "PU235", "PU236", "PU237", "PU238", "PU239", "PU240", "PU241", "PU242", "PU243",
    "PU244", "PU245", "PU246", "PU247", "PU",    "AM230", "AM231", "AM232", "AM233", "AM234", "AM235", "AM236", "AM237",
    "AM238", "AM239", "AM240", "AM241", "AM242", "AM243", "AM244", "AM245", "AM246", "AM247", "AM248", "AM249", "AM",
    "CM232", "CM233", "CM234", "CM235", "CM236", "CM237", "CM238", "CM239", "CM240", "CM241", "CM242", "CM243", "CM244",
    "CM245", "CM246", "CM247", "CM248", "CM249", "CM250", "CM251", "CM252", "CM",    "BK234", "BK235", "BK236", "BK237",
    "BK238", "BK239", "BK240", "BK241", "BK242", "BK243", "BK244", "BK245", "BK246", "BK247", "BK248", "BK249", "BK250",
    "BK251", "BK252", "BK253", "BK254", "BK",    "CF237", "CF238", "CF239", "CF240", "CF241", "CF242", "CF243", "CF244",
    "CF245", "CF246", "CF247", "CF248", "CF249", "CF250", "CF251", "CF252", "CF253", "CF254", "CF255", "CF256", "CF",
    "ES239", "ES240", "ES241", "ES242", "ES243", "ES244", "ES245", "ES246", "ES247", "ES248", "ES249", "ES250", "ES251",
    "ES252", "ES253", "ES254", "ES255", "ES256", "ES257", "ES258", "ES",    "FM241", "FM242", "FM243", "FM244", "FM245",
    "FM246", "FM247", "FM248", "FM249", "FM250", "FM251", "FM252", "FM253", "FM254", "FM255", "FM256", "FM257", "FM258",
    "FM259", "FM260", "FM",    "MD245", "MD246", "MD247", "MD248", "MD249", "MD250", "MD251", "MD252", "MD253", "MD254",
    "MD255", "MD256", "MD257", "MD258", "MD259", "MD260", "MD261", "MD262", "MD",    "NO248", "NO249", "NO250", "NO251",
    "NO252", "NO253", "NO254", "NO255", "NO256", "NO257", "NO258", "NO259", "NO260", "NO261", "NO262", "NO263", "NO264",
    "NO",    "LR251", "LR252", "LR253", "LR254", "LR255", "LR256", "LR257", "LR258", "LR259", "LR260", "LR261", "LR262",
    "LR263", "LR264", "LR265", "LR266", "LR",    "RF253", "RF254", "RF255", "RF256", "RF257", "RF258", "RF259", "RF260",
    "RF261", "RF262", "RF263", "RF264", "RF265", "RF266", "RF267", "RF268", "RF",    "DB255", "DB256", "DB257", "DB258",
    "DB259", "DB260", "DB261", "DB262", "DB263", "DB264", "DB265", "DB266", "DB267", "DB268", "DB269", "DB270", "DB",
    "SG258", "SG259", "SG260", "SG261", "SG262", "SG263", "SG264", "SG265", "SG266", "SG267", "SG268", "SG269", "SG270",
    "SG271", "SG272", "SG273", "SG",    "BH260", "BH261", "BH262", "BH263", "BH264", "BH265", "BH266", "BH267", "BH268",
    "BH269", "BH270", "BH271", "BH272", "BH273", "BH274", "BH275", "BH",    "HS263", "HS264", "HS265", "HS266", "HS267",
    "HS268", "HS269", "HS270", "HS271", "HS272", "HS273", "HS274", "HS275", "HS276", "HS277", "HS",    "MT265", "MT266",
    "MT267", "MT268", "MT269", "MT270", "MT271", "MT272", "MT273", "MT274", "MT275", "MT276", "MT277", "MT278", "MT279",
    "MT",    "DS267", "DS268", "DS269", "DS270", "DS271", "DS272", "DS273", "DS274", "DS275", "DS276", "DS277", "DS278",
    "DS279", "DS280", "DS281", "DS",    "RG272", "RG273", "RG274", "RG275", "RG276", "RG277", "RG278", "RG279", "RG280",
    "RG281", "RG282", "RG283", "RG",    "CN276", "CN277", "CN278", "CN279", "CN280", "CN281", "CN282", "CN283", "CN284",
    "CN285", "CN",    "NH278", "NH279", "NH280", "NH281", "NH282", "NH283", "NH284", "NH285", "NH286", "NH287", "NH",
    "FL285", "FL286", "FL287", "FL288", "FL289", "FL",    "MC287", "MC288", "MC289", "MC290", "MC291", "MC",    "LV289",
    "LV290", "LV291", "LV292", "LV293", "LV",    "TS291", "TS292", "TS293", "TS294", "TS"};

static const double atomic_masses[] = {
    1.00782503223,  2.01410177812,  2.01410177812,  3.0160492779,   3.0160492779,  4.02643,        5.035311,
    6.04496,        7.0527,         1.00782503223,  3.0160293201,   4.00260325413, 5.012057,       6.018885891,
    7.0279907,      8.033934390,    9.043946,       10.05279,       4.00260325413, 3.0308,         4.02719,
    5.012538,       6.0151228874,   7.0160034366,   8.022486246,    9.02679019,    10.035483,      11.04372358,
    12.052517,      13.06263,       7.0160034366,   5.0399,         6.0197264,     7.016928717,    8.005305102,
    9.012183065,    10.013534695,   11.02166108,    12.0269221,     13.036135,     14.04289,       15.05342,
    16.06167,       9.012183065,    6.0508,         7.029712,       8.0246073,     9.01332965,     10.01293695,
    11.00930536,    12.0143527,     13.0177802,     14.025404,      15.031088,     16.039842,      17.04699,
    18.05566,       19.06310,       20.07207,       21.08129,       11.00930536,   8.037643,       9.0310372,
    10.01685331,    11.0114336,     12.0000000,     13.00335483507, 14.0032419884, 15.01059926,    16.0147013,
    17.022577,      18.026751,      19.03480,       20.04032,       21.04900,      22.05753,       23.0689,
    12.0000000,     10.04165,       11.026091,      12.0186132,     13.00573861,   14.00307400443, 15.00010889888,
    16.0061019,     17.008449,      18.014078,      19.017022,      20.023366,     21.02711,       22.03439,
    23.04114,       24.05039,       25.06010,       14.00307400443, 12.034262,     13.024815,      14.00859636,
    15.00306562,    15.99491461957, 16.99913175650, 17.99915961286, 19.0035780,    20.00407535,    21.008655,
    22.009966,      23.015696,      24.01986,       25.02936,       26.03729,      27.04772,       28.05591,
    15.99491461957, 14.034315,      15.018043,      16.0114657,     17.00209524,   18.00093733,    18.99840316273,
    19.999981252,   20.9999489,     22.002999,      23.003557,      24.008115,     25.012199,      26.020038,
    27.02644,       28.03534,       29.04254,       30.05165,       31.05971,      18.99840316273, 16.025750,
    17.01771396,    18.00570870,    19.00188091,    19.9924401762,  20.993846685,  21.991385114,   22.99446691,
    23.99361065,    24.997789,      26.000515,      27.007553,      28.01212,      29.01975,       30.02473,
    31.0331,        32.03972,       33.04938,       34.05673,       19.9924401762, 18.02688,       19.013880,
    20.0073544,     20.99765469,    21.99443741,    22.9897692820,  23.990962950,  24.9899540,     25.9926346,
    26.9940765,     27.998939,      29.0028771,     30.0090979,     31.013163,     32.02019,       33.02573,
    34.03359,       35.04062,       36.04929,       37.05705,       22.9897692820, 19.034169,      20.018850,
    21.011716,      21.99957065,    22.99412421,    23.985041697,   24.985836976,  25.982592968,   26.984340624,
    27.9838767,     28.988617,      29.9904629,     30.9966480,     31.9991102,    33.0053271,     34.008935,
    35.01679,       36.02188,       37.03037,       38.03658,       39.04538,      40.05218,       23.985041697,
    21.02897,       22.01954,       23.00724435,    23.9999489,     24.99042810,   25.986891904,   26.98153853,
    27.98191021,    28.9804565,     29.982960,      30.983945,      31.988085,     32.990909,      33.996705,
    34.999764,      36.00639,       37.01053,       38.01740,       39.02254,      40.03003,       41.03638,
    42.04384,       43.05147,       26.98153853,    22.03579,       23.02544,      24.011535,      25.004109,
    25.99233384,    26.98670481,    27.97692653465, 28.97649466490, 29.973770136,  30.975363194,   31.97415154,
    32.97797696,    33.978576,      34.984583,      35.986695,      36.992921,     37.995523,      39.002491,
    40.00583,       41.01301,       42.01778,       43.02480,       44.03061,      45.03995,       27.97692653465,
    24.03577,       25.02119,       26.01178,       26.999224,      27.9923266,    28.98180079,    29.97831375,
    30.97376199842, 31.973907643,   32.9717257,     33.97364589,    34.9733141,    35.978260,      36.979607,
    37.984252,      38.986227,      39.99133,       40.994654,      42.00108,      43.00502,       44.01121,
    45.01645,       46.02446,       47.03139,       30.97376199842, 26.02907,      27.01828,       28.00437,
    28.996611,      29.98490703,    30.97955701,    31.9720711744,  32.9714589098, 33.967867004,   34.969032310,
    35.96708071,    36.97112551,    37.9711633,     38.975134,      39.9754826,    40.9795935,     41.9810651,
    42.9869076,     43.9901188,     44.99572,       46.00004,       47.00795,      48.01370,       49.02276,
    31.9720711744,  28.02954,       29.01478,       30.00477,       30.992414,     31.98568464,    32.97745199,
    33.973762485,   34.968852682,   35.968306809,   36.965902602,   37.96801044,   38.9680082,     39.970415,
    40.970685,      41.97325,       42.97389,       43.97787,       44.98029,      45.98517,       46.98916,
    47.99564,       49.00123,       50.00905,       51.01554,       34.968852682,  30.02307,       31.01212,
    31.9976378,     32.98992555,    33.980270090,   34.97525759,    35.967545105,  36.96677633,    37.96273211,
    38.9643130,     39.9623831237,  40.96450057,    41.9630457,     42.9656361,    43.9649238,     44.96803973,
    45.968083,      46.972935,      47.97591,       48.98190,       49.98613,      50.99370,       51.99896,
    53.00729,       39.9623831237,  32.02265,       33.00756,       33.99869,      34.98800541,    35.98130201,
    36.97337589,    37.96908112,    38.9637064864,  39.963998166,   40.9618252579, 41.96240231,    42.96073470,
    43.96158699,    44.96069149,    45.96198159,    46.9616616,     47.96534119,   48.96821075,    49.9723800,
    50.975828,      51.98224,       52.98746,       53.99463,       55.00076,      56.00851,       38.9637064864,
    34.01487,       35.00514,       35.993074,      36.98589785,    37.97631922,   38.97071081,    39.962590863,
    40.96227792,    41.95861783,    42.95876644,    43.95548156,    44.95618635,   45.9536890,     46.9545424,
    47.95252276,    48.95566274,    49.9574992,     50.960989,      51.963217,     52.96945,       53.97340,
    54.98030,       55.98508,       56.99262,       57.99794,       39.962590863,  36.01648,       37.00374,
    37.99512,       38.984785,      39.9779673,     40.969251105,   41.96551653,   42.9611505,     43.9594029,
    44.95590828,    45.95516826,    46.9524037,     47.9522236,     48.9500146,    49.952176,      50.953592,
    51.95688,       52.95909,       53.96393,       54.96782,       55.97345,      56.97777,       57.98403,
    58.98894,       59.99565,       61.00100,       44.95590828,    38.01145,      39.00236,       39.99050,
    40.983148,      41.97304903,    42.9685225,     43.95968995,    44.95812198,   45.95262772,    46.95175879,
    47.94794198,    48.94786568,    49.94478689,    50.94661065,    51.9468930,    52.94973,       53.95105,
    54.95527,       55.95791,       56.96364,       57.96660,       58.97247,      59.97603,       60.98245,
    61.98651,       62.99375,       47.94794198,    40.01276,       41.00021,      41.99182,       42.980766,
    43.97411,       44.9657748,     45.96019878,    46.95490491,    47.9522522,    48.94851180,    49.94715601,
    50.94395704,    51.94477301,    52.9443367,     53.946439,      54.94724,      55.95048,       56.95252,
    57.95672,       58.95939,       59.96431,       60.96725,       61.97265,      62.97639,       63.98264,
    64.98750,       65.99398,       50.94395704,    42.00670,       42.99753,      43.98536,       44.979050,
    45.968359,      46.9628974,     47.9540291,     48.9513333,     49.94604183,   50.94476502,    51.94050623,
    52.94064815,    53.93887916,    54.94083843,    55.9406531,     56.9436130,    57.94435,       58.94859,
    59.95008,       60.95442,       61.95610,       62.96165,       63.96408,      64.96996,       65.97366,
    66.98016,       67.98403,       51.94050623,    44.00715,       44.99449,      45.98609,       46.975775,
    47.96852,       48.959595,      49.95423778,    50.94820847,    51.9455639,    52.94128889,    53.9403576,
    54.93804391,    55.93890369,    56.9382861,     57.9400666,     58.9403911,    59.9431366,     60.9444525,
    61.94795,       62.9496647,     63.9538494,     64.9560198,     65.960547,     66.96424,       67.96962,
    68.97366,       69.97937,       70.98368,       54.93804391,    45.01442,      46.00063,       46.99185,
    47.98023,       48.973429,      49.962975,      50.9568410,     51.9481131,    52.9453064,     53.93960899,
    54.93829199,    55.93493633,    56.93539284,    57.93327443,    58.93487434,   59.9340711,     60.9367462,
    61.9367918,     62.9402727,     63.9409878,     64.9450115,     65.9462500,    66.95054,       67.95295,
    68.95807,       69.96102,       70.96672,       71.96983,       72.97572,      73.97935,       55.93493633,
    47.01057,       48.00093,       48.98891,       49.98091,       50.970647,     51.96351,       52.9542041,
    53.94845987,    54.94199720,    55.93983880,    56.93629057,    57.9357521,    58.93319429,    59.93381630,
    60.93247662,    61.934059,      62.933600,      63.935811,      64.9364621,    65.939443,      66.9406096,
    67.94426,       68.94614,       69.94963,       70.95237,       71.95729,      72.96039,       73.96515,
    74.96876,       75.97413,       58.93319429,    48.01769,       49.00770,      49.99474,       50.98611,
    51.97480,       52.968190,      53.957892,      54.95133063,    55.94212855,   56.93979218,    57.93534241,
    58.93434620,    59.93078588,    60.93105557,    61.92834537,    62.92966963,   63.92796682,    64.93008517,
    65.9291393,     66.9315694,     67.9318688,     68.9356103,     69.9364313,    70.9405190,     71.9417859,
    72.9462067,     73.94798,       74.95250,       75.95533,       76.96055,      77.96336,       78.97025,
    57.93534241,    51.99671,       52.98459,       53.97666,       54.96604,      55.95895,       56.94921250,
    57.94453305,    58.93949748,    59.9373645,     60.9334576,     61.93259541,   62.92959772,    63.92976434,
    64.92778970,    65.92886903,    66.9277303,     67.9296109,     68.9294293,    69.9323921,     70.9326768,
    71.9358203,     72.9366744,     73.9398749,     74.9415226,     75.9452750,    76.94792,       77.95223,
    78.95502,       79.96089,       80.96587,       81.97244,       62.92959772,   53.99204,       54.98398,
    55.97254,       56.96506,       57.954591,      58.94931266,    59.94184210,   60.939507,      61.93433397,
    62.9332115,     63.92914201,    64.92924077,    65.92603381,    66.92712775,   67.92484455,    68.9265507,
    69.9253192,     70.9277196,     71.9268428,     72.9295826,     73.9294073,    74.9328402,     75.9331150,
    76.9368872,     77.9382892,     78.9426381,     79.9445529,     80.9504026,    81.95426,       82.96056,
    83.96521,       84.97226,       63.92914201,    55.99536,       56.98320,      57.97478,       58.96353,
    59.95729,       60.949399,      61.94419025,    62.9392942,     63.9368404,    64.93273459,    65.9315894,
    66.9282025,     67.9279805,     68.9255735,     69.9260219,     70.92470258,   71.92636747,    72.9251747,
    73.9269457,     74.9265002,     75.9288276,     76.9291543,     77.9316088,    78.9328523,     79.9364208,
    80.9381338,     81.9431765,     82.9471203,     83.95246,       84.95699,      85.96301,       86.96824,
    68.9255735,     57.99172,       58.98249,       59.97036,       60.96379,      61.95502,       62.949628,
    63.9416899,     64.9393681,     65.9338621,     66.9327339,     67.9280953,    68.9279645,     69.92424875,
    70.92495233,    71.922075826,   72.923458956,   73.921177761,   74.922858370,  75.921402726,   76.923549843,
    77.9228529,     78.925360,      79.9253508,     80.9288329,     81.9297740,    82.9345391,     83.9375751,
    84.9429697,     85.94658,       86.95268,       87.95691,       88.96379,      89.96863,       73.921177761,
    59.99388,       60.98112,       61.97361,       62.96390,       63.95743,      64.949611,      65.9441488,
    66.93925111,    67.9367741,     68.932246,      69.930926,      70.9271138,    71.9267523,     72.9238291,
    73.9239286,     74.92159457,    75.92239202,    76.9206476,     77.921828,     78.9209484,     79.9224746,
    80.9221323,     81.9247412,     82.9252069,     83.9293033,     84.9321637,    85.9367015,     86.9402917,
    87.94555,       88.94976,       89.95563,       90.96039,       91.96674,      74.92159457,    63.97109,
    64.96440,       65.95559,       66.949994,      67.94182524,    68.9394148,    69.9335155,     70.9322094,
    71.9271405,     72.9267549,     73.922475934,   74.922522870,   75.919213704,  76.919914154,   77.91730928,
    78.91849929,    79.9165218,     80.9179930,     81.9166995,     82.9191186,    83.9184668,     84.9222608,
    85.9243117,     86.9286886,     87.9314175,     88.9366691,     89.94010,      90.94596,       91.94984,
    92.95629,       93.96049,       94.96730,       79.9165218,     66.96465,      67.95873,       68.950497,
    69.944792,      70.9393422,     71.9365886,     72.9316715,     73.9299102,    74.9258105,     75.924542,
    76.9213792,     77.9211459,     78.9183376,     79.9185298,     80.9162897,    81.9168032,     82.9151756,
    83.916496,      84.9156458,     85.9188054,     86.9206740,     87.9240833,    88.9267046,     89.9312928,
    90.9343986,     91.9396316,     92.94313,       93.94890,       94.95301,      95.95903,       96.96344,
    97.96946,       78.9183376,     68.96518,       69.95604,       70.95027,      71.9420924,     72.9392892,
    73.9330840,     74.9309457,     75.9259103,     76.9246700,     77.92036494,   78.9200829,     79.91637808,
    80.9165912,     81.91348273,    82.91412716,    83.9114977282,  84.9125273,    85.9106106269,  86.91335476,
    87.9144479,     88.9178355,     89.9195279,     90.9238063,     91.9261731,    92.9311472,     93.934140,
    94.939711,      95.943017,      96.94909,       97.95243,       98.95839,      99.96237,       100.96873,
    83.9114977282,  70.96532,       71.95908,       72.95053,       73.9442659,    74.9385732,     75.9350730,
    76.9304016,     77.9281419,     78.9239899,     79.9225164,     80.9189939,    81.9182090,     82.9151142,
    83.9143752,     84.9117897379,  85.91116743,    86.9091805310,  87.91131559,   88.9122783,     89.9147985,
    90.9165372,     91.9197284,     92.9220393,     93.9263948,     94.929260,     95.9341334,     96.9371771,
    97.9416869,     98.94503,       99.95003,       100.95404,      101.95952,     102.96392,      84.9117897379,
    72.96570,       73.95617,       74.94995,       75.941763,      76.9379455,    77.9321800,     78.9297077,
    79.9245175,     80.9232114,     81.9183999,     82.9175544,     83.9134191,    84.9129320,     85.9092606,
    86.9088775,     87.9056125,     88.9074511,     89.9077300,     90.9101954,    91.9110382,     92.9140242,
    93.9153556,     94.9193529,     95.9217066,     96.9263740,     97.9286888,    98.9328907,     99.935770,
    100.940352,     101.943791,     102.94909,      103.95265,      104.95855,     105.96265,      106.96897,
    87.9056125,     75.95856,       76.949781,      77.94361,       78.93735,      79.9343561,     80.9294556,
    81.9269314,     82.922485,      83.9206721,     84.916433,      85.914886,     86.9108761,     87.9095016,
    88.9058403,     89.9071439,     90.9072974,     91.9089451,     92.909578,     93.9115906,     94.9128161,
    95.9158968,     96.9182741,     97.9223821,     98.9241480,     99.927715,     100.9301477,    101.9343277,
    102.937243,     103.94196,      104.94544,      105.95056,      106.95452,     107.95996,      108.96436,
    88.9058403,     77.95566,       78.94948,       79.9404,        80.93731,      81.93135,       82.9292421,
    83.9233269,     84.9214444,     85.9162972,     86.9148180,     87.9102213,    88.9088814,     89.9046977,
    90.9056396,     91.9050347,     92.9064699,     93.9063108,     94.9080385,    95.9082714,     96.9109512,
    97.9127289,     98.916667,      99.9180006,     100.9214480,    101.9231409,   102.927191,     103.929436,
    104.934008,     105.93676,      106.94174,      107.94487,      108.95041,     109.95396,      110.95968,
    111.96370,      89.9046977,     80.94960,       81.94396,       82.93729,      83.93449,       84.9288458,
    85.9257828,     86.9206937,     87.918222,      88.913445,      89.9112584,    90.9069897,     91.9071881,
    92.9063730,     93.9072788,     94.90683240,    95.9080973,     96.9080959,    97.9103265,     98.911613,
    99.9143276,     100.9153103,    101.9180772,    102.9194572,    103.9228925,   104.9249465,    105.9289317,
    106.9315937,    107.9360748,    108.93922,      109.94403,      110.94753,     111.95247,      112.95651,
    113.96201,      114.96634,      92.9063730,     82.94988,       83.94149,      84.938261,      85.9311748,
    86.9281962,     87.9219678,     88.9194682,     89.9139309,     90.9117453,    91.90680796,    92.90680958,
    93.90508490,    94.90583877,    95.90467612,    96.90601812,    97.90540482,   98.90770851,    99.9074718,
    100.9103414,    101.9102834,    102.913079,     103.9137344,    104.916969,    105.918259,     106.922106,
    107.924033,     108.928424,     109.930704,     110.935654,     111.93831,     112.94335,      113.94653,
    114.95196,      115.95545,      116.96117,      97.90540482,    84.95058,      85.94493,       86.9380672,
    87.93378,       88.9276487,     89.9240739,     90.9184254,     91.9152698,    92.9102460,     93.9096536,
    94.9076536,     95.9078680,     96.9063667,     97.9072124,     98.9062508,    99.9076539,     100.907309,
    101.9092097,    102.909176,     103.911425,     104.911655,     105.914358,    106.9154606,    107.9184957,
    108.920256,     109.923744,     110.925901,     111.9299458,    112.9325690,   113.93691,      114.93998,
    115.94476,      116.94806,      117.95299,      118.95666,      119.96187,     97.9072124,     86.95069,
    87.94160,       88.93762,       89.9303444,     90.9267419,     91.9202344,    92.9171044,     93.9113429,
    94.910406,      95.90759025,    96.9075471,     97.9052868,     98.9059341,    99.9042143,     100.9055769,
    101.9043441,    102.9063186,    103.9054275,    104.9077476,    105.9073291,   106.9099720,    107.9101880,
    108.9133260,    109.9140407,    110.917570,     111.918809,     112.922844,    113.9246136,    114.928820,
    115.9312192,    116.93610,      117.93853,      118.94357,      119.94631,     120.95164,      121.95447,
    122.95989,      123.96305,      101.9043441,    88.95058,       89.94422,      90.93688,       91.9323677,
    92.9259128,     93.9217305,     94.9158979,     95.914453,      96.911329,     97.910708,      98.9081282,
    99.908117,      100.9061606,    101.9068374,    102.9054980,    103.9066492,   104.9056885,    105.9072868,
    106.906748,     107.908714,     108.9087488,    109.911079,     110.9116423,   111.914403,     112.9154393,
    113.918718,     114.9203116,    115.924059,     116.9260354,    117.930340,    118.932557,     119.93686,
    120.93942,      121.94399,      122.94685,      123.95151,      124.95469,     125.95946,      102.9054980,
    90.95032,       91.94088,       92.93651,       93.9290376,     94.9248898,    95.9182151,     96.9164720,
    97.9126983,     98.9117748,     99.908505,      100.9082864,    101.9056022,   102.9060809,    103.9040305,
    104.9050796,    105.9034804,    106.9051282,    107.9038916,    108.9059504,   109.90517220,   110.90768968,
    111.9073297,    112.9102610,    113.9103686,    114.913659,     115.9142970,   116.9179547,    117.9190667,
    118.9233402,    119.9245511,    120.9289503,    121.930632,     122.93514,     123.93714,      124.94179,
    125.94416,      126.94907,      127.95183,      105.9034804,    92.95033,      93.94373,       94.93602,
    95.930744,      96.92397,       97.921560,      98.9176458,     99.9161154,    100.9126840,    101.9117047,
    102.9089631,    103.9086239,    104.9065256,    105.9066636,    106.9050916,   107.9059503,    108.9047553,
    109.9061102,    110.9052959,    111.9070486,    112.906573,     113.9088230,   114.908767,     115.9113868,
    116.911774,     117.9145955,    118.915570,     119.9187848,    120.920125,    121.923664,     122.925337,
    123.92893,      124.93105,      125.93475,      126.93711,      127.94106,     128.94395,      129.95070,
    106.9050916,    94.94994,       95.94034,       96.93510,       97.927389,     98.9249258,     99.9203488,
    100.9185862,    101.9144820,    102.9134165,    103.9098564,    104.9094639,   105.9064599,    106.9066121,
    107.9041834,    108.9049867,    109.90300661,   110.90418287,   111.90276287,  112.90440813,   113.90336509,
    114.90543751,   115.90476315,   116.9072260,    117.906922,     118.909847,    119.9098681,    120.9129637,
    121.9134591,    122.9168925,    123.9176574,    124.9212576,    125.9224291,   126.926472,     127.9278129,
    128.93182,      129.93394,      130.94060,      131.94604,      132.95285,     113.90336509,   96.94934,
    97.94214,       98.93411,       99.93096,       100.92634,      101.9241071,   102.9198819,    103.9182145,
    104.914502,     105.913464,     106.910290,     107.9096935,    108.9071514,   109.907170,     110.9051085,
    111.9055377,    112.90406184,   113.90491791,   114.903878776,  115.90525999,  116.9045157,    117.9063566,
    118.9058507,    119.907967,     120.907851,     121.910281,     122.910434,    123.913182,     124.913605,
    125.916507,     126.917446,     127.92040,      128.9218053,    129.924977,    130.9269715,    131.933001,
    132.93831,      133.94454,      134.95005,      114.903878776,  98.94853,      99.93850,       100.93526,
    101.93029,      102.928105,     103.9231052,    104.9212684,    105.9169574,   106.9157137,    107.9118943,
    108.9112921,    109.907845,     110.9077401,    111.90482387,   112.9051757,   113.9027827,    114.903344699,
    115.90174280,   116.90295398,   117.90160657,   118.90331117,   119.90220163,  120.9042426,    121.9034438,
    122.9057252,    123.9052766,    124.9077864,    125.907659,     126.910390,    127.910507,     128.913465,
    129.9139738,    130.9170450,    131.9178267,    132.9239134,    133.9286821,   134.9349086,    135.93999,
    136.94655,      137.95184,      119.90220163,   102.93969,      103.93648,     104.931276,     105.9286380,
    106.9241506,    107.9222267,    108.9181411,    109.9168543,    110.9132182,   111.912400,     112.909375,
    113.909290,     114.906598,     115.9067931,    116.9048415,    117.9055321,   118.9039455,    119.9050794,
    120.9038120,    121.9051699,    122.9042132,    123.9059350,    124.9052530,   125.907253,     126.9069243,
    127.909146,     128.909147,     129.911662,     130.9119888,    131.9145077,   132.9152732,    133.9205357,
    134.9251851,    135.9307459,    136.93555,      137.94145,      138.94655,     139.95283,      120.9038120,
    104.94330,      105.93750,      106.935012,     107.9293805,    108.9273045,   109.9224581,    110.9210006,
    111.9167279,    112.915891,     113.912089,     114.911902,     115.908460,    116.908646,     117.905854,
    118.9064071,    119.9040593,    120.904944,     121.9030435,    122.9042698,   123.9028171,    124.9044299,
    125.9033109,    126.9052257,    127.90446128,   128.90659646,   129.906222748, 130.908522213,  131.9085467,
    132.9109688,    133.9113940,    134.9165557,    135.9201006,    136.9255989,   137.9294722,    138.9353672,
    139.939499,     140.94580,      141.95022,      142.95676,      129.906222748, 106.94678,      107.94348,
    108.9380853,    109.935089,     110.9302692,    111.928005,     112.9236501,   113.92185,      114.918048,
    115.91681,      116.913648,     117.913074,     118.910074,     119.910087,    120.9074051,    121.9075888,
    122.9055885,    123.9062090,    124.9046294,    125.9056233,    126.9044719,   127.9058086,    128.9049837,
    129.9066702,    130.90612630,   131.9079935,    132.9077970,    133.9097588,   134.9100488,    135.914604,
    136.9180282,    137.9227264,    138.926506,     139.93173,      140.93569,     141.94120,      142.94565,
    143.95139,      144.95605,      126.9044719,    108.95043,      109.94426,     110.941607,     111.9355590,
    112.9332217,    113.927980,     114.926294,     115.921581,     116.920359,    117.916179,     118.915411,
    119.911784,     120.911453,     121.908368,     122.908482,     123.9058920,   124.9063944,    125.9042983,
    126.9051829,    127.9035310,    128.9047808611, 129.903509349,  130.90508406,  131.9041550856, 132.9059108,
    133.90539466,   134.9072278,    135.907214484,  136.91155778,   137.9141463,   138.9187922,    139.9216458,
    140.9267872,    141.9299731,    142.9353696,    143.9389451,    144.944720,    145.948518,     146.95426,
    147.95813,      131.9041550856, 111.950309,     112.9444291,    113.941296,    114.93591,      115.93337,
    116.928617,     117.926560,     118.922377,     119.920677,     120.917227,    121.916108,     122.912996,
    123.9122578,    124.9097280,    125.909446,     126.9074174,    127.9077487,   128.9060657,    129.9067093,
    130.9054649,    131.9064339,    132.9054519610, 133.906718503,  134.9059770,   135.9073114,    136.90708923,
    137.9110171,    138.9133638,    139.9172831,    140.9200455,    141.9242960,   142.927349,     143.932076,
    144.935527,     145.940344,     146.944156,     147.94923,      148.95302,     149.95833,      150.96258,
    132.9054519610, 113.95066,      114.94737,      115.94128,      116.93814,     117.93306,      118.93066,
    119.92605,      120.92405,      121.919904,     122.918781,     123.915094,    124.914472,     125.911250,
    126.911091,     127.9083420,    128.908681,     129.9063207,    130.9069410,   131.9050611,    132.9060074,
    133.90450818,   134.90568838,   135.90457573,   136.90582714,   137.90524700,  138.90884110,   139.9106057,
    140.9144033,    141.9164324,    142.9206253,    143.9229549,    144.9275184,   145.930284,     146.935304,
    147.938171,     148.94308,      149.94605,      150.95127,      151.95481,     152.96036,      137.90524700,
    115.95630,      116.94999,      117.94673,      118.94099,      119.93807,     120.93315,      121.93071,
    122.92630,      123.924574,     124.920816,     125.919513,     126.916375,    127.915592,     128.912694,
    129.912369,     130.910070,     131.910119,     132.908218,     133.908514,    134.906984,     135.907635,
    136.9064504,    137.9071149,    138.9063563,    139.9094806,    140.9109660,   141.9140909,    142.9160795,
    143.919646,     144.921808,     145.925875,     146.928418,     147.932679,    148.93535,      149.93947,
    150.94232,      151.94682,      152.95036,      153.95517,      154.95901,     138.9063563,    118.95271,
    119.94654,      120.94335,      121.93787,      122.93528,      123.93031,     124.92844,      125.923971,
    126.922727,     127.918911,     128.918102,     129.914736,     130.914429,    131.911464,     132.911520,
    133.908928,     134.909161,     135.90712921,   136.90776236,   137.905991,    138.9066551,    139.9054431,
    140.9082807,    141.9092504,    142.9123921,    143.9136529,    144.917265,    145.918802,     146.9226899,
    147.924424,     148.928427,     149.930384,     150.934272,     151.93660,     152.94093,      153.94380,
    154.94855,      155.95183,      156.95705,      139.9054431,    120.95532,     121.95175,      122.94596,
    123.94294,      124.93770,      125.93524,      126.93071,      127.928791,    128.925095,     129.923590,
    130.920235,     131.919255,     132.916331,     133.915697,     134.913112,    135.912677,     136.9106792,
    137.910754,     138.9089408,    139.9090803,    140.9076576,    141.9100496,   142.9108228,    143.9133109,
    144.9145182,    145.917680,     146.919008,     147.922130,     148.923736,    149.9266765,    150.928309,
    151.931553,     152.933904,     153.93753,      154.940509,     155.94464,     156.94789,      157.95241,
    158.95589,      140.9076576,    123.95220,      124.94890,      125.94311,     126.94038,      127.93525,
    128.93310,      129.928506,     130.927248,     131.923321,     132.922348,    133.918790,     134.918181,
    135.914976,     136.914562,     137.911950,     138.911954,     139.909550,    140.9096147,    141.9077290,
    142.9098200,    143.9100930,    144.9125793,    145.9131226,    146.9161061,   147.9168993,    148.9201548,
    149.9209022,    150.9238403,    151.924692,     152.9277180,    153.92948,     154.9331357,    155.93508,
    156.939386,     157.94197,      158.94653,      159.94940,      160.95428,     141.9077290,    125.95792,
    126.95192,      127.94870,      128.94323,      129.94053,      130.93567,     131.93384,      132.929782,
    133.928353,     134.924823,     135.923585,     136.920480,     137.919548,    138.916800,     139.916040,
    140.913555,     141.912890,     142.9109383,    143.9125964,    144.9127559,   145.9147024,    146.9151450,
    147.9174819,    148.9183423,    149.920991,     150.9212175,    151.923506,    152.9241567,    153.926472,
    154.9281370,    155.9311175,    156.9331214,    157.936565,     158.939287,    159.94310,      160.94607,
    161.95022,      162.95357,      144.9127559,    127.95842,      128.95476,     129.94900,      130.94618,
    131.94087,      132.93856,      133.93411,      134.93252,      135.928276,    136.926971,     137.923244,
    138.922297,     139.918995,     140.9184816,    141.9152044,    142.9146353,   143.9120065,    144.9134173,
    145.9130470,    146.9149044,    147.9148292,    148.9171921,    149.9172829,   150.9199398,    151.9197397,
    152.9221047,    153.9222169,    154.9246477,    155.925536,     156.9284187,   157.9299510,    158.9332172,
    159.9353353,    160.9391602,    161.94146,      162.94555,      163.94836,     164.95297,      151.9197397,
    129.96369,      130.95784,      131.95467,      132.94929,      133.94640,     134.94187,      135.93962,
    136.93546,      137.933709,     138.929792,     139.928088,     140.924932,    141.923442,     142.920299,
    143.918820,     144.9162726,    145.9172110,    146.9167527,    147.918089,    148.9179378,    149.9197077,
    150.9198578,    151.9217522,    152.9212380,    153.9229870,    154.9229011,   155.9247605,    156.9254334,
    157.927799,     158.9291001,    159.931851,     160.933664,     161.936989,    162.939196,     163.94274,
    164.94559,      165.94962,      166.95289,      152.9212380,    132.96133,     133.95566,      134.95245,
    135.94730,      136.94502,      137.94025,      138.93813,      139.933674,    140.932126,     141.928116,
    142.92675,      143.922963,     144.921713,     145.9183188,    146.9191014,   147.9181215,    148.9193481,
    149.9186644,    150.9203560,    151.9197995,    152.9217580,    153.9208741,   154.9226305,    155.9221312,
    156.9239686,    157.9241123,    158.9263970,    159.9270624,    160.9296775,   161.9309930,    162.9341769,
    163.93583,      164.93936,      165.94146,      166.94545,      167.94808,     168.95260,      157.9241123,
    134.96476,      135.96129,      136.95602,      137.95312,      138.94833,     139.94581,      140.94145,
    141.93928,      142.935137,     143.933045,     144.92882,      145.927253,    146.9240548,    147.924282,
    148.9232535,    149.9236649,    150.9231096,    151.924083,     152.9234424,   153.924685,     154.923511,
    155.9247552,    156.9240330,    157.9254209,    158.9253547,    159.9271756,   160.9275778,    161.929495,
    162.9306547,    163.93336,      164.93498,      165.937860,     166.93996,     167.94340,      168.94597,
    169.94984,      170.95273,      158.9253547,    137.96250,      138.95959,     139.95402,      140.95128,
    141.94619,      142.943994,     143.9392695,    144.9374740,    145.9328445,   146.9310827,    147.927157,
    148.927322,     149.9255933,    150.9261916,    151.9247253,    152.9257724,   153.9244293,    154.925759,
    155.9242847,    156.9254707,    157.9244159,    158.9257470,    159.9252046,   160.9269405,    161.9268056,
    162.9287383,    163.9291819,    164.9317105,    165.9328139,    166.935661,    167.93713,      168.94031,
    169.94239,      170.94612,      171.94846,      172.95283,      163.9291819,   139.96859,      140.96311,
    141.96001,      142.95486,      143.9521097,    144.9472674,    145.9449935,   146.9401423,    147.937744,
    148.933803,     149.933498,     150.9316983,    151.931724,     152.9302064,   153.9306068,    154.929104,
    155.929706,     156.928254,     157.928946,     158.9277197,    159.928737,    160.9278615,    161.9291023,
    162.9287410,    163.9302403,    164.9303288,    165.9322909,    166.9331385,   167.935522,     168.936878,
    169.939625,     170.94147,      171.94473,      172.94702,      173.95095,     174.95362,      164.9303288,
    141.97010,      142.96662,      143.96070,      144.95805,      145.9524184,   146.949964,     147.944735,
    148.942306,     149.937916,     150.937449,     151.935057,     152.935080,    153.9327908,    154.9332159,
    155.931067,     156.931949,     157.929893,     158.9306918,    159.929077,    160.9300046,    161.9287884,
    162.9300408,    163.9292088,    164.9307345,    165.9302995,    166.9320546,   167.9323767,    168.9345968,
    169.9354702,    170.9380357,    171.9393619,    172.94240,      173.94423,     174.94777,      175.94994,
    176.95399,      165.9302995,    143.97628,      144.97039,      145.96684,     146.9613799,    147.958384,
    148.95289,      149.95009,      150.945488,     151.944422,     152.942040,    153.941570,     154.939210,
    155.938992,     156.936944,     157.936980,     158.934975,     159.935263,    160.933549,     161.934002,
    162.9326592,    163.933544,     164.9324431,    165.933561,     166.9328562,   167.9341774,    168.9342179,
    169.9358060,    170.9364339,    171.9384055,    172.9396084,    173.942173,    174.943841,     175.94700,
    176.94904,      177.95264,      178.95534,      168.9342179,    147.96758,     148.96436,      149.95852,
    150.95540,      151.95027,      152.94932,      153.946396,     154.945783,    155.942825,     156.942645,
    157.9398705,    158.940055,     159.937557,     160.937907,     161.935774,    162.936340,     163.934495,
    164.935270,     165.9338747,    166.9349530,    167.9338896,    168.9351825,   169.9347664,    170.9363302,
    171.9363859,    172.9382151,    173.9388664,    174.9412808,    175.9425764,   176.9452656,    177.946651,
    178.95004,      179.95212,      180.95589,      173.9388664,    149.97355,     150.96768,      151.96412,
    152.95875,      153.95736,      154.954321,     155.953033,     156.950127,    157.949316,     158.946636,
    159.946033,     160.943572,     161.943283,     162.941179,     163.941339,    164.939407,     165.939859,
    166.938270,     167.938736,     168.9376441,    169.938478,     170.9379170,   171.9390891,    172.9389340,
    173.9403409,    174.9407752,    175.9426897,    176.9437615,    177.9459580,   178.9473309,    179.949888,
    180.95191,      181.95504,      182.957363,     183.96091,      184.96362,     174.9407752,    152.97069,
    153.96486,      154.96311,      155.95935,      156.95824,      157.954801,    158.953996,     159.950691,
    160.950278,     161.9472148,    162.947113,     163.944371,     164.944567,    165.942180,     166.942600,
    167.940568,     168.941259,     169.939609,     170.940492,     171.939450,    172.940513,     173.9400461,
    174.9415092,    175.9414076,    176.9432277,    177.9437058,    178.9458232,   179.9465570,    180.9491083,
    181.9505612,    182.953530,     183.955446,     184.958862,     185.960897,    186.96477,      187.96685,
    188.97084,      179.9465570,    154.97424,      155.97203,      156.96818,     157.96654,      158.963023,
    159.961488,     160.958452,     161.957294,     162.954337,     163.953534,    164.950781,     165.950512,
    166.948093,     167.948047,     168.946011,     169.946175,     170.944476,    171.944895,     172.943750,
    173.944454,     174.943737,     175.944857,     176.9444795,    177.945678,    178.9459366,    179.9474648,
    180.9479958,    181.9501519,    182.9513726,    183.954008,     184.955559,    185.958551,     186.960386,
    187.963916,     188.96583,      189.96939,      190.97156,      191.97514,     180.9479958,    156.97884,
    157.97456,      158.97264,      159.96846,      160.96720,      161.963499,    162.962524,     163.958961,
    164.958281,     165.955031,     166.954805,     167.951806,     168.951779,    169.949232,     170.949451,
    171.947292,     172.947689,     173.946079,     174.946717,     175.945634,    176.946643,     177.945883,
    178.947077,     179.9467108,    180.9481978,    181.94820394,   182.95022275,  183.95093092,   184.95341897,
    185.9543628,    186.9571588,    187.9584862,    188.961763,     189.963091,    190.966531,     191.96817,
    192.97178,      193.97367,      183.95093092,   158.98418,      159.98182,     160.97757,      161.97584,
    162.972080,     163.970453,     164.967103,     165.965761,     166.962595,    167.961573,     168.958766,
    169.958220,     170.955716,     171.955420,     172.953243,     173.953115,    174.951381,     175.951623,
    176.950328,     177.950989,     178.949989,     179.950792,     180.950058,    181.95121,      182.9508196,
    183.9525228,    184.9529545,    185.9549856,    186.9557501,    187.9581115,   188.9592260,    189.961744,
    190.963122,     191.966088,     192.967541,     193.97076,      194.97254,     195.97580,      196.97799,
    197.98160,      186.9557501,    160.98903,      161.98443,      162.98241,     163.97802,      164.97660,
    165.972692,     166.971549,     167.967808,     168.967018,     169.963578,    170.963174,     171.960017,
    172.959808,     173.957064,     174.956945,     175.954806,     176.954966,    177.953254,     178.953817,
    179.952375,     180.953247,     181.952110,     182.953125,     183.9524885,   184.9540417,    185.9538350,
    186.9557474,    187.9558352,    188.9581442,    189.9584437,    190.9609264,   191.9614770,    192.9641479,
    193.9651772,    194.968318,     195.969641,     196.97283,      197.97441,     198.97801,      199.97984,
    200.98364,      201.98595,      191.9614770,    163.99191,      164.98750,     165.98566,      166.981666,
    167.979907,     168.976298,     169.974922,     170.971640,     171.970607,    172.967506,     173.966861,
    174.964150,     175.963650,     176.961301,     177.961082,     178.959120,    179.959229,     180.957625,
    181.958076,     182.956840,     183.957476,     184.956698,     185.957944,    186.957542,     187.958828,
    188.958715,     189.9605412,    190.9605893,    191.9626002,    192.9629216,   193.9650735,    194.9659747,
    195.968397,     196.969655,     197.97228,      198.973805,     199.97680,     200.97864,      201.98199,
    202.98423,      203.98960,      192.9629216,    165.99486,      166.99269,     167.98813,      168.98657,
    169.982496,     170.981245,     171.977351,     172.976443,     173.972820,    174.972410,     175.968938,
    176.968470,     177.965650,     178.9653590,    179.963032,     180.963098,    181.961172,     182.961597,
    183.959915,     184.960614,     185.959351,     186.960617,     187.9593889,   188.960831,     189.9599297,
    190.9616729,    191.9610387,    192.9629824,    193.9626809,    194.9647917,   195.96495209,   196.96734069,
    197.9678949,    198.9705952,    199.971443,     200.974513,     201.975639,    202.97893,      203.98076,
    204.98608,      205.98966,      194.9647917,    168.99808,      169.99597,     170.991876,     171.989942,
    172.986241,     173.984717,     174.981304,     175.980250,     176.976870,    177.976032,     178.973174,
    179.972523,     180.970079,     181.969618,     182.967591,     183.967452,    184.965790,     185.965953,
    186.964543,     187.965349,     188.963948,     189.964698,     190.963702,    191.964814,     192.9641373,
    193.9654178,    194.9650352,    195.9665699,    196.96656879,   197.96824242,  198.96876528,   199.970756,
    200.9716575,    201.973856,     202.9751544,    203.97783,      204.97985,     205.98474,      206.98840,
    207.99345,      208.99735,      210.00250,      196.96656879,   171.00353,     171.99881,      172.99709,
    173.992865,     174.991441,     175.987361,     176.986277,     177.982484,    178.981831,     179.978260,
    180.977819,     181.974689,     182.9744448,    183.971714,     184.971899,    185.969362,     186.969814,
    187.967567,     188.968195,     189.966323,     190.967157,     191.965635,    192.966653,     193.9654491,
    194.966721,     195.9658326,    196.9672128,    197.96676860,   198.96828064,  199.96832659,   200.97030284,
    201.97064340,   202.9728728,    203.97349398,   204.9760734,    205.977514,    206.982300,     207.985759,
    208.99072,      209.99424,      210.99933,      212.00296,      213.00823,     214.01200,      215.01740,
    216.02132,      201.97064340,   176.000624,     176.996431,     177.99485,     178.991111,     179.990057,
    180.9862600,    181.985713,     182.982193,     183.981886,     184.978789,    185.978651,     186.9759063,
    187.976021,     188.973588,     189.973828,     190.9717842,    191.972225,    192.9705020,    193.971081,
    194.969774,     195.970481,     196.969576,     197.970483,     198.969877,    199.9709633,    200.970822,
    201.972102,     202.9723446,    203.9738639,    204.9744278,    205.9761106,   206.9774197,    207.9820190,
    208.9853594,    209.990074,     210.993475,     211.99834,      213.001915,    214.00694,      215.01064,
    216.01580,      217.01966,      218.02479,      204.9744278,    178.003831,    179.002201,     179.997928,
    180.996653,     181.992672,     182.991872,     183.988136,     184.987610,    185.984238,     186.9839109,
    187.980875,     188.980807,     189.978082,     190.978276,     191.975775,    192.976173,     193.974012,
    194.974543,     195.972774,     196.9734312,    197.972034,     198.972913,    199.971819,     200.972883,
    201.9721520,    202.9733911,    203.9730440,    204.9744822,    205.9744657,   206.9758973,    207.9766525,
    208.9810905,    209.9841889,    210.9887371,    211.9918977,    212.9965629,   213.9998059,    215.00474,
    216.00803,      217.01314,      218.01659,      219.02177,      220.02541,     207.9766525,    184.001275,
    184.997600,     185.996644,     186.993147,     187.992287,     188.989195,    189.988622,     190.9857866,
    191.985469,     192.982960,     193.982785,     194.9806488,    195.980667,    196.9788651,    197.979206,
    198.977673,     199.978131,     200.977010,     201.977734,     202.976893,    203.9778361,    204.9773867,
    205.9784993,    206.9784710,    207.9797425,    208.9803991,    209.9841207,   210.9872697,    211.9912860,
    212.9943851,    213.998712,     215.001770,     216.006306,     217.009372,    218.014188,     219.01748,
    220.02235,      221.02587,      222.03078,      223.03450,      224.03947,     208.9803991,    186.004393,
    187.003041,     187.999416,     188.998473,     189.995101,     190.9945585,   191.991336,     192.991026,
    193.988186,     194.988126,     195.985526,     196.985660,     197.983389,    198.983667,     199.981799,
    200.9822598,    201.980758,     202.9814161,    203.980310,     204.981203,    205.9804740,    206.9815938,
    207.9812461,    208.9824308,    209.9828741,    210.9866536,    211.9888684,   212.9928576,    213.9952017,
    214.9994201,    216.0019152,    217.0063182,    218.0089735,    219.013614,    220.016386,     221.021228,
    222.024140,     223.02907,      224.03211,      225.03707,      226.04031,     227.04539,      208.9824308,
    191.004148,     192.003152,     192.999927,     193.999236,     194.9962685,   195.995800,     196.993189,
    197.992784,     198.9905277,    199.990351,     200.9884171,    201.988630,    202.986943,     203.987251,
    204.986076,     205.986657,     206.985800,     207.9866133,    208.9861702,   209.9871479,    210.9874966,
    211.9907377,    212.9929370,    213.9963721,    214.9986528,    216.0024236,   217.0047192,    218.008695,
    219.0111618,    220.015433,     221.018017,     222.022494,     223.025151,    224.029749,     225.03263,
    226.03716,      227.04024,      228.04475,      229.04812,      209.9871479,   193.009708,     194.006144,
    195.005422,     196.002116,     197.001585,     197.998679,     198.998390,    199.995690,     200.995628,
    201.993264,     202.993388,     203.991430,     204.991719,     205.990214,    206.9907303,    207.989635,
    208.990415,     209.9896891,    210.9906011,    211.9907039,    212.9938831,   213.9953630,    214.9987459,
    216.0002719,    217.0039280,    218.0056016,    219.0094804,    220.0113941,   221.0155371,    222.0175782,
    223.0218893,    224.024096,     225.028486,     226.030861,     227.035304,    228.037835,     229.042257,
    230.04514,      231.04987,      222.0175782,    199.007259,     200.006586,    201.003867,     202.003320,
    203.0009407,    204.000652,     204.9985939,    205.998666,     206.996946,    207.997138,     208.995955,
    209.996422,     210.995556,     211.9962257,    212.9961860,    213.9989713,   215.0003418,    216.0031899,
    217.0046323,    218.0075787,    219.0092524,    220.0123277,    221.0142552,   222.017552,     223.0197360,
    224.023398,     225.025573,     226.029566,     227.031869,     228.035823,    229.038298,     230.042416,
    231.045158,     232.04937,      233.05264,      223.0197360,    201.01271,     202.009760,     203.009304,
    204.006492,     205.006268,     206.003828,     207.003799,     208.001841,    209.001990,     210.000494,
    211.0008932,    211.999787,     213.000384,     214.0000997,    215.0027204,   216.0035334,    217.0063207,
    218.007141,     219.0100855,    220.0110259,    221.0139177,    222.0153748,   223.0185023,    224.0202120,
    225.0236119,    226.0254103,    227.0291783,    228.0310707,    229.034942,    230.037055,     231.041027,
    232.0434753,    233.047582,     234.050342,     235.05497,      226.0254103,   206.014452,     207.011966,
    208.011550,     209.009495,     210.009436,     211.007732,     212.007813,    213.006609,     214.006918,
    215.006475,     216.008743,     217.009344,     218.011642,     219.012421,    220.0147549,    221.015592,
    222.0178442,    223.0191377,    224.0217232,    225.0232300,    226.0260984,   227.0277523,    228.0310215,
    229.032956,     230.036327,     231.038393,     232.042034,     233.044346,    234.048139,     235.050840,
    236.054988,     237.05827,      227.0277523,    208.017900,     209.017753,    210.015094,     211.014929,
    212.012988,     213.013009,     214.011500,     215.0117248,    216.011056,    217.013117,     218.013276,
    219.015537,     220.015748,     221.018184,     222.018469,     223.0208119,   224.021464,     225.0239514,
    226.0249034,    227.0277042,    228.0287413,    229.0317627,    230.0331341,   231.0363046,    232.0380558,
    233.0415823,    234.0436014,    235.047255,     236.049657,     237.053629,    238.05650,      239.06077,
    232.0380558,    212.023203,     213.021109,     214.020918,     215.019183,    216.019109,     217.018325,
    218.020059,     219.019904,     220.021705,     221.021875,     222.023784,    223.023963,     224.0256176,
    225.026131,     226.027948,     227.0288054,    228.0310517,    229.0320972,   230.0345410,    231.0358842,
    232.0385917,    233.0402472,    234.0433072,    235.045399,     236.048668,    237.051023,     238.054637,
    239.05726,      240.06098,      241.06408,      231.0358842,    217.02466,     218.023523,     219.024999,
    220.02462,      221.02628,      222.02600,      223.027739,     224.027605,    225.029391,     226.029339,
    227.031157,     228.031371,     229.0335063,    230.0339401,    231.0362939,   232.0371563,    233.0396355,
    234.0409523,    235.0439301,    236.0455682,    237.0487304,    238.0507884,   239.0542935,    240.0565934,
    241.06033,      242.06293,      243.06699,      238.0507884,    219.03143,     220.03254,      221.03204,
    222.03330,      223.03285,      224.03422,      225.033911,     226.035188,    227.034957,     228.036067,
    229.036264,     230.037828,     231.038245,     232.04011,      233.040741,    234.0428953,    235.0440635,
    236.046570,     237.0481736,    238.0509466,    239.0529392,    240.056165,    241.058253,     242.06164,
    243.064280,     244.06785,      245.07080,      237.0481736,    228.038732,    229.040144,     230.039650,
    231.041102,     232.041185,     233.042998,     234.0433174,    235.045286,    236.0460581,    237.0484098,
    238.0495601,    239.0521636,    240.0538138,    241.0568517,    242.0587428,   243.0620036,    244.0642053,
    245.067826,     246.070205,     247.07419,      244.0642053,    230.04609,     231.04556,      232.04645,
    233.04644,      234.04773,      235.047908,     236.04943,      237.049996,    238.051985,     239.0530247,
    240.055300,     241.0568293,    242.0595494,    243.0613813,    244.0642851,   245.0664548,    246.069775,
    247.07209,      248.07575,      249.07848,      243.0613813,    232.04982,     233.050770,     234.050160,
    235.05154,      236.051374,     237.052869,     238.053081,     239.054910,    240.0555297,    241.0576532,
    242.0588360,    243.0613893,    244.0627528,    245.0654915,    246.0672238,   247.0703541,    248.0723499,
    249.0759548,    250.078358,     251.082286,     252.08487,      247.0703541,   234.05727,      235.05658,
    236.05748,      237.05710,      238.05820,      239.05824,      240.05976,     241.06016,      242.06198,
    243.0630078,    244.065181,     245.0663618,    246.068673,     247.0703073,   248.073088,     249.0749877,
    250.0783167,    251.080762,     252.08431,      253.08688,      254.09060,     247.0703073,    237.062198,
    238.06149,      239.06253,      240.062256,     241.06369,      242.063754,    243.06548,      244.0660008,
    245.0680487,    246.0688055,    247.070965,     248.0721851,    249.0748539,   250.0764062,    251.0795886,
    252.0816272,    253.0851345,    254.087324,     255.09105,      256.09344,     251.0795886,    239.06823,
    240.06892,      241.06856,      242.06957,      243.06951,      244.07088,     245.07125,      246.07290,
    247.073622,     248.075471,     249.076411,     250.07861,      251.0799936,   252.082980,     253.0848257,
    254.0880222,    255.090275,     256.09360,      257.09598,      258.09952,     252.082980,     241.07421,
    242.07343,      243.07446,      244.07404,      245.07535,      246.075350,    247.07694,      248.0771865,
    249.0789275,    250.0795210,    251.081540,     252.0824671,    253.0851846,   254.0868544,    255.0899640,
    256.0917745,    257.0951061,    258.09708,      259.10060,      260.10281,     257.0951061,    245.08081,
    246.08171,      247.08152,      248.08282,      249.08291,      250.08441,     251.084774,     252.08643,
    253.087144,     254.08959,      255.0910841,    256.09389,      257.0955424,   258.0984315,    259.10051,
    260.10365,      261.10583,      262.10910,      258.0984315,    248.08655,     249.08780,      250.08756,
    251.08894,      252.088967,     253.0905641,    254.090956,     255.093191,    256.0942829,    257.0968878,
    258.09821,      259.10103,      260.10264,      261.10570,      262.10746,     263.11071,      264.11273,
    259.10103,      251.09418,      252.09526,      253.09509,      254.09648,     255.096562,     256.098494,
    257.099418,     258.10176,      259.102902,     260.10550,      261.10688,     262.10961,      263.11136,
    264.11420,      265.11619,      266.11983,      266.11983,      253.10044,     254.10005,      255.10127,
    256.101152,     257.102918,     258.103428,     259.105596,     260.10644,     261.108773,     262.10992,
    263.11249,      264.11388,      265.11668,      266.11817,      267.12179,     268.12397,      267.12179,
    255.10707,      256.10789,      257.10758,      258.10928,      259.109492,    260.11130,      261.11192,
    262.11407,      263.11499,      264.11741,      265.11861,      266.12103,     267.12247,      268.12567,
    269.12791,      270.13136,      268.12567,      258.11298,      259.11440,     260.114384,     261.115949,
    262.116337,     263.11829,      264.11893,      265.12109,      266.12198,     267.12436,      268.12539,
    269.12863,      270.13043,      271.13393,      272.13589,      273.13958,     271.13393,      260.12166,
    261.12145,      262.12297,      263.12292,      264.12459,      265.12491,     266.12679,      267.12750,
    268.12969,      269.13042,      270.13336,      271.13526,      272.13826,     273.14024,      274.14355,
    275.14567,      270.13336,      263.12852,      264.128357,     265.129793,    266.130046,     267.13167,
    268.13186,      269.13375,      270.13429,      271.13717,      272.13850,     273.14168,      274.14330,
    275.14667,      276.14846,      277.15190,      269.13375,      265.13600,     266.13737,      267.13719,
    268.13865,      269.13882,      270.14033,      271.14074,      272.14341,     273.14440,      274.14724,
    275.14882,      276.15159,      277.15327,      278.15631,      279.15808,     278.15631,      267.14377,
    268.14348,      269.144752,     270.144584,     271.14595,      272.14602,     273.14856,      274.14941,
    275.15203,      276.15303,      277.15591,      278.15704,      279.16010,     280.16131,      281.16451,
    281.16451,      272.15327,      273.15313,      274.15525,      275.15594,     276.15833,      277.15907,
    278.16149,      279.16272,      280.16514,      281.16636,      282.16912,     283.17054,      282.16912,
    276.16141,      277.16364,      278.16416,      279.16654,      280.16715,     281.16975,      282.17050,
    283.17327,      284.17416,      285.17712,      285.17712,      278.17058,     279.17095,      280.17293,
    281.17348,      282.17567,      283.17657,      284.17873,      285.17973,     286.18221,      287.18339,
    286.18221,      285.18364,      286.18423,      287.18678,      288.18757,     289.19042,      289.19042,
    287.19070,      288.19274,      289.19363,      290.19598,      291.19707,     289.19363,      289.19816,
    290.19864,      291.20108,      292.20174,      293.20449,      293.20449,     291.20553,      292.20746,
    293.20824,      294.21046,      294.21046};

#endif /* header guard */
