# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CachedImages(Model):
    """The cached image and OS type.

    All required parameters must be populated in order to send to Azure.

    :param id: The resource Id of the cached image.
    :type id: str
    :param os_type: Required. The OS type of the cached image.
    :type os_type: str
    :param image: Required. The cached image name.
    :type image: str
    """

    _validation = {
        'os_type': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CachedImages, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.os_type = kwargs.get('os_type', None)
        self.image = kwargs.get('image', None)
