# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ...operations._managed_instance_vulnerability_assessments_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_by_instance_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ManagedInstanceVulnerabilityAssessmentsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.aio.SqlManagementClient`'s
        :attr:`managed_instance_vulnerability_assessments` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        **kwargs: Any
    ) -> _models.ManagedInstanceVulnerabilityAssessment:
        """Gets the managed instance's vulnerability assessment.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessment is defined. Required.
        :type managed_instance_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :return: ManagedInstanceVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        cls: ClsType[_models.ManagedInstanceVulnerabilityAssessment] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ManagedInstanceVulnerabilityAssessment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        parameters: _models.ManagedInstanceVulnerabilityAssessment,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagedInstanceVulnerabilityAssessment:
        """Creates or updates the managed instance's vulnerability assessment. Learn more about setting
        SQL vulnerability assessment with managed identity -
        https://docs.microsoft.com/azure/azure-sql/database/sql-database-vulnerability-assessment-storage.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessment is defined. Required.
        :type managed_instance_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param parameters: The requested resource. Required.
        :type parameters: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ManagedInstanceVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagedInstanceVulnerabilityAssessment:
        """Creates or updates the managed instance's vulnerability assessment. Learn more about setting
        SQL vulnerability assessment with managed identity -
        https://docs.microsoft.com/azure/azure-sql/database/sql-database-vulnerability-assessment-storage.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessment is defined. Required.
        :type managed_instance_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param parameters: The requested resource. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ManagedInstanceVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        managed_instance_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        parameters: Union[_models.ManagedInstanceVulnerabilityAssessment, IO[bytes]],
        **kwargs: Any
    ) -> _models.ManagedInstanceVulnerabilityAssessment:
        """Creates or updates the managed instance's vulnerability assessment. Learn more about setting
        SQL vulnerability assessment with managed identity -
        https://docs.microsoft.com/azure/azure-sql/database/sql-database-vulnerability-assessment-storage.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessment is defined. Required.
        :type managed_instance_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :param parameters: The requested resource. Is either a ManagedInstanceVulnerabilityAssessment
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment or IO[bytes]
        :return: ManagedInstanceVulnerabilityAssessment or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ManagedInstanceVulnerabilityAssessment] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ManagedInstanceVulnerabilityAssessment")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ManagedInstanceVulnerabilityAssessment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        managed_instance_name: str,
        vulnerability_assessment_name: Union[str, _models.VulnerabilityAssessmentName],
        **kwargs: Any
    ) -> None:
        """Removes the managed instance's vulnerability assessment.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessment is defined. Required.
        :type managed_instance_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment. "default"
         Required.
        :type vulnerability_assessment_name: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentName
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            managed_instance_name=managed_instance_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_by_instance(
        self, resource_group_name: str, managed_instance_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceVulnerabilityAssessment"]:
        """Gets the managed instance's vulnerability assessment policies.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param managed_instance_name: The name of the managed instance for which the vulnerability
         assessments is defined. Required.
        :type managed_instance_name: str
        :return: An iterator like instance of either ManagedInstanceVulnerabilityAssessment or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2020-11-01-preview"))
        cls: ClsType[_models.ManagedInstanceVulnerabilityAssessmentListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_instance_request(
                    resource_group_name=resource_group_name,
                    managed_instance_name=managed_instance_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceVulnerabilityAssessmentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
