# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AvailabilityZoneMappings(_serialization.Model):
    """Availability zone mappings for the region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar logical_zone: The logical zone id for the availability zone.
    :vartype logical_zone: str
    :ivar physical_zone: The fully qualified physical zone id of availability zone to which logical
     zone id is mapped to.
    :vartype physical_zone: str
    """

    _validation = {
        "logical_zone": {"readonly": True},
        "physical_zone": {"readonly": True},
    }

    _attribute_map = {
        "logical_zone": {"key": "logicalZone", "type": "str"},
        "physical_zone": {"key": "physicalZone", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.logical_zone: Optional[str] = None
        self.physical_zone: Optional[str] = None


class AvailabilityZonePeers(_serialization.Model):
    """List of availability zones shared by the subscriptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar availability_zone: The availabilityZone.
    :vartype availability_zone: str
    :ivar peers: Details of shared availability zone.
    :vartype peers: list[~azure.mgmt.resource.subscriptions.models.Peers]
    """

    _validation = {
        "availability_zone": {"readonly": True},
    }

    _attribute_map = {
        "availability_zone": {"key": "availabilityZone", "type": "str"},
        "peers": {"key": "peers", "type": "[Peers]"},
    }

    def __init__(self, *, peers: Optional[List["_models.Peers"]] = None, **kwargs: Any) -> None:
        """
        :keyword peers: Details of shared availability zone.
        :paramtype peers: list[~azure.mgmt.resource.subscriptions.models.Peers]
        """
        super().__init__(**kwargs)
        self.availability_zone: Optional[str] = None
        self.peers = peers


class CheckResourceNameResult(_serialization.Model):
    """Resource Name valid if not a reserved word, does not contain a reserved word and does not start
    with a reserved word.

    :ivar name: Name of Resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar status: Is the resource name Allowed or Reserved. Known values are: "Allowed" and
     "Reserved".
    :vartype status: str or ~azure.mgmt.resource.subscriptions.models.ResourceNameStatus
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        status: Optional[Union[str, "_models.ResourceNameStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of Resource.
        :paramtype name: str
        :keyword type: Type of Resource.
        :paramtype type: str
        :keyword status: Is the resource name Allowed or Reserved. Known values are: "Allowed" and
         "Reserved".
        :paramtype status: str or ~azure.mgmt.resource.subscriptions.models.ResourceNameStatus
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.status = status


class CheckZonePeersRequest(_serialization.Model):
    """Check zone peers request parameters.

    :ivar location: The Microsoft location.
    :vartype location: str
    :ivar subscription_ids: The peer Microsoft Azure subscription ID.
    :vartype subscription_ids: list[str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "subscription_ids": {"key": "subscriptionIds", "type": "[str]"},
    }

    def __init__(
        self, *, location: Optional[str] = None, subscription_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: The Microsoft location.
        :paramtype location: str
        :keyword subscription_ids: The peer Microsoft Azure subscription ID.
        :paramtype subscription_ids: list[str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.subscription_ids = subscription_ids


class CheckZonePeersResult(_serialization.Model):
    """Result of the Check zone peers operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar location: the location of the subscription.
    :vartype location: str
    :ivar availability_zone_peers: The Availability Zones shared by the subscriptions.
    :vartype availability_zone_peers:
     list[~azure.mgmt.resource.subscriptions.models.AvailabilityZonePeers]
    """

    _validation = {
        "subscription_id": {"readonly": True},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "availability_zone_peers": {"key": "availabilityZonePeers", "type": "[AvailabilityZonePeers]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        availability_zone_peers: Optional[List["_models.AvailabilityZonePeers"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: the location of the subscription.
        :paramtype location: str
        :keyword availability_zone_peers: The Availability Zones shared by the subscriptions.
        :paramtype availability_zone_peers:
         list[~azure.mgmt.resource.subscriptions.models.AvailabilityZonePeers]
        """
        super().__init__(**kwargs)
        self.subscription_id: Optional[str] = None
        self.location = location
        self.availability_zone_peers = availability_zone_peers


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.subscriptions.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.subscriptions.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.subscriptions.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.subscriptions.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorResponse"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponseAutoGenerated(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resource.subscriptions.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.resource.subscriptions.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Location(_serialization.Model):
    """Location information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID of the location. For example,
     /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
    :vartype id: str
    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar name: The location name.
    :vartype name: str
    :ivar type: The location type. Known values are: "Region" and "EdgeZone".
    :vartype type: str or ~azure.mgmt.resource.subscriptions.models.LocationType
    :ivar display_name: The display name of the location.
    :vartype display_name: str
    :ivar regional_display_name: The display name of the location and its region.
    :vartype regional_display_name: str
    :ivar metadata: Metadata of the location, such as lat/long, paired region, and others.
    :vartype metadata: ~azure.mgmt.resource.subscriptions.models.LocationMetadata
    :ivar availability_zone_mappings: The availability zone mappings for this region.
    :vartype availability_zone_mappings:
     list[~azure.mgmt.resource.subscriptions.models.AvailabilityZoneMappings]
    """

    _validation = {
        "id": {"readonly": True},
        "subscription_id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "regional_display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "regional_display_name": {"key": "regionalDisplayName", "type": "str"},
        "metadata": {"key": "metadata", "type": "LocationMetadata"},
        "availability_zone_mappings": {"key": "availabilityZoneMappings", "type": "[AvailabilityZoneMappings]"},
    }

    def __init__(
        self,
        *,
        metadata: Optional["_models.LocationMetadata"] = None,
        availability_zone_mappings: Optional[List["_models.AvailabilityZoneMappings"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata of the location, such as lat/long, paired region, and others.
        :paramtype metadata: ~azure.mgmt.resource.subscriptions.models.LocationMetadata
        :keyword availability_zone_mappings: The availability zone mappings for this region.
        :paramtype availability_zone_mappings:
         list[~azure.mgmt.resource.subscriptions.models.AvailabilityZoneMappings]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.subscription_id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[Union[str, "_models.LocationType"]] = None
        self.display_name: Optional[str] = None
        self.regional_display_name: Optional[str] = None
        self.metadata = metadata
        self.availability_zone_mappings = availability_zone_mappings


class LocationListResult(_serialization.Model):
    """Location list operation response.

    :ivar value: An array of locations.
    :vartype value: list[~azure.mgmt.resource.subscriptions.models.Location]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Location]"},
    }

    def __init__(self, *, value: Optional[List["_models.Location"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of locations.
        :paramtype value: list[~azure.mgmt.resource.subscriptions.models.Location]
        """
        super().__init__(**kwargs)
        self.value = value


class LocationMetadata(_serialization.Model):
    """Location metadata information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region_type: The type of the region. Known values are: "Physical" and "Logical".
    :vartype region_type: str or ~azure.mgmt.resource.subscriptions.models.RegionType
    :ivar region_category: The category of the region. Known values are: "Recommended", "Extended",
     and "Other".
    :vartype region_category: str or ~azure.mgmt.resource.subscriptions.models.RegionCategory
    :ivar geography: The geography of the location.
    :vartype geography: str
    :ivar geography_group: The geography group of the location.
    :vartype geography_group: str
    :ivar longitude: The longitude of the location.
    :vartype longitude: str
    :ivar latitude: The latitude of the location.
    :vartype latitude: str
    :ivar physical_location: The physical location of the Azure location.
    :vartype physical_location: str
    :ivar paired_region: The regions paired to this region.
    :vartype paired_region: list[~azure.mgmt.resource.subscriptions.models.PairedRegion]
    :ivar home_location: The home location of an edge zone.
    :vartype home_location: str
    """

    _validation = {
        "region_type": {"readonly": True},
        "region_category": {"readonly": True},
        "geography": {"readonly": True},
        "geography_group": {"readonly": True},
        "longitude": {"readonly": True},
        "latitude": {"readonly": True},
        "physical_location": {"readonly": True},
        "home_location": {"readonly": True},
    }

    _attribute_map = {
        "region_type": {"key": "regionType", "type": "str"},
        "region_category": {"key": "regionCategory", "type": "str"},
        "geography": {"key": "geography", "type": "str"},
        "geography_group": {"key": "geographyGroup", "type": "str"},
        "longitude": {"key": "longitude", "type": "str"},
        "latitude": {"key": "latitude", "type": "str"},
        "physical_location": {"key": "physicalLocation", "type": "str"},
        "paired_region": {"key": "pairedRegion", "type": "[PairedRegion]"},
        "home_location": {"key": "homeLocation", "type": "str"},
    }

    def __init__(self, *, paired_region: Optional[List["_models.PairedRegion"]] = None, **kwargs: Any) -> None:
        """
        :keyword paired_region: The regions paired to this region.
        :paramtype paired_region: list[~azure.mgmt.resource.subscriptions.models.PairedRegion]
        """
        super().__init__(**kwargs)
        self.region_type: Optional[Union[str, "_models.RegionType"]] = None
        self.region_category: Optional[Union[str, "_models.RegionCategory"]] = None
        self.geography: Optional[str] = None
        self.geography_group: Optional[str] = None
        self.longitude: Optional[str] = None
        self.latitude: Optional[str] = None
        self.physical_location: Optional[str] = None
        self.paired_region = paired_region
        self.home_location: Optional[str] = None


class ManagedByTenant(_serialization.Model):
    """Information about a tenant managing the subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: The tenant ID of the managing tenant. This is a GUID.
    :vartype tenant_id: str
    """

    _validation = {
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tenant_id: Optional[str] = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.resource.subscriptions.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.resource.subscriptions.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.resource.subscriptions.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.resource.subscriptions.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationAutoGenerated(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.resource.subscriptions.models.OperationDisplayAutoGenerated
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.resource.subscriptions.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.resource.subscriptions.models.ActionType
    """

    _validation = {
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplayAutoGenerated"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplayAutoGenerated"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.resource.subscriptions.models.OperationDisplayAutoGenerated
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationDisplayAutoGenerated(_serialization.Model):
    """Localized display information for this particular operation.

    :ivar provider: Service provider: Microsoft.Resources.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Resources.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.resource.subscriptions.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class OperationListResultAutoGenerated(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.resource.subscriptions.models.OperationAutoGenerated]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationAutoGenerated]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OperationAutoGenerated"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.resource.subscriptions.models.OperationAutoGenerated]
        :keyword next_link: URL to get the next set of operation list results (if there are any).
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PairedRegion(_serialization.Model):
    """Information regarding paired region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the paired region.
    :vartype name: str
    :ivar id: The fully qualified ID of the location. For example,
     /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
    :vartype id: str
    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "subscription_id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.id: Optional[str] = None
        self.subscription_id: Optional[str] = None


class Peers(_serialization.Model):
    """Information about shared availability zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar availability_zone: The availabilityZone.
    :vartype availability_zone: str
    """

    _validation = {
        "subscription_id": {"readonly": True},
        "availability_zone": {"readonly": True},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "availability_zone": {"key": "availabilityZone", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.subscription_id: Optional[str] = None
        self.availability_zone: Optional[str] = None


class ResourceName(_serialization.Model):
    """Name and Type of the Resource.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the resource. Required.
    :vartype name: str
    :ivar type: The type of the resource. Required.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the resource. Required.
        :paramtype name: str
        :keyword type: The type of the resource. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Subscription(_serialization.Model):
    """Subscription information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the subscription. For example,
     /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74.
    :vartype id: str
    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar display_name: The subscription display name.
    :vartype display_name: str
    :ivar tenant_id: The subscription tenant ID.
    :vartype tenant_id: str
    :ivar state: The subscription state. Possible values are Enabled, Warned, PastDue, Disabled,
     and Deleted. Known values are: "Enabled", "Warned", "PastDue", "Disabled", and "Deleted".
    :vartype state: str or ~azure.mgmt.resource.subscriptions.models.SubscriptionState
    :ivar subscription_policies: The subscription policies.
    :vartype subscription_policies: ~azure.mgmt.resource.subscriptions.models.SubscriptionPolicies
    :ivar authorization_source: The authorization source of the request. Valid values are one or
     more combinations of Legacy, RoleBased, Bypassed, Direct and Management. For example, 'Legacy,
     RoleBased'.
    :vartype authorization_source: str
    :ivar managed_by_tenants: An array containing the tenants managing the subscription.
    :vartype managed_by_tenants: list[~azure.mgmt.resource.subscriptions.models.ManagedByTenant]
    :ivar tags: The tags attached to the subscription.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "subscription_id": {"readonly": True},
        "display_name": {"readonly": True},
        "tenant_id": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "subscription_policies": {"key": "subscriptionPolicies", "type": "SubscriptionPolicies"},
        "authorization_source": {"key": "authorizationSource", "type": "str"},
        "managed_by_tenants": {"key": "managedByTenants", "type": "[ManagedByTenant]"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        subscription_policies: Optional["_models.SubscriptionPolicies"] = None,
        authorization_source: Optional[str] = None,
        managed_by_tenants: Optional[List["_models.ManagedByTenant"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscription_policies: The subscription policies.
        :paramtype subscription_policies:
         ~azure.mgmt.resource.subscriptions.models.SubscriptionPolicies
        :keyword authorization_source: The authorization source of the request. Valid values are one or
         more combinations of Legacy, RoleBased, Bypassed, Direct and Management. For example, 'Legacy,
         RoleBased'.
        :paramtype authorization_source: str
        :keyword managed_by_tenants: An array containing the tenants managing the subscription.
        :paramtype managed_by_tenants: list[~azure.mgmt.resource.subscriptions.models.ManagedByTenant]
        :keyword tags: The tags attached to the subscription.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.subscription_id: Optional[str] = None
        self.display_name: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.state: Optional[Union[str, "_models.SubscriptionState"]] = None
        self.subscription_policies = subscription_policies
        self.authorization_source = authorization_source
        self.managed_by_tenants = managed_by_tenants
        self.tags = tags


class SubscriptionListResult(_serialization.Model):
    """Subscription list operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: An array of subscriptions.
    :vartype value: list[~azure.mgmt.resource.subscriptions.models.Subscription]
    :ivar next_link: The URL to get the next set of results. Required.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Subscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: str, value: Optional[List["_models.Subscription"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of subscriptions.
        :paramtype value: list[~azure.mgmt.resource.subscriptions.models.Subscription]
        :keyword next_link: The URL to get the next set of results. Required.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SubscriptionPolicies(_serialization.Model):
    """Subscription policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location_placement_id: The subscription location placement ID. The ID indicates which
     regions are visible for a subscription. For example, a subscription with a location placement
     Id of Public_2014-09-01 has access to Azure public regions.
    :vartype location_placement_id: str
    :ivar quota_id: The subscription quota ID.
    :vartype quota_id: str
    :ivar spending_limit: The subscription spending limit. Known values are: "On", "Off", and
     "CurrentPeriodOff".
    :vartype spending_limit: str or ~azure.mgmt.resource.subscriptions.models.SpendingLimit
    """

    _validation = {
        "location_placement_id": {"readonly": True},
        "quota_id": {"readonly": True},
        "spending_limit": {"readonly": True},
    }

    _attribute_map = {
        "location_placement_id": {"key": "locationPlacementId", "type": "str"},
        "quota_id": {"key": "quotaId", "type": "str"},
        "spending_limit": {"key": "spendingLimit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location_placement_id: Optional[str] = None
        self.quota_id: Optional[str] = None
        self.spending_limit: Optional[Union[str, "_models.SpendingLimit"]] = None


class TenantIdDescription(_serialization.Model):
    """Tenant Id information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID of the tenant. For example,
     /tenants/8d65815f-a5b6-402f-9298-045155da7d74.
    :vartype id: str
    :ivar tenant_id: The tenant ID. For example, 8d65815f-a5b6-402f-9298-045155da7d74.
    :vartype tenant_id: str
    :ivar tenant_category: Category of the tenant. Known values are: "Home", "ProjectedBy", and
     "ManagedBy".
    :vartype tenant_category: str or ~azure.mgmt.resource.subscriptions.models.TenantCategory
    :ivar country: Country/region name of the address for the tenant.
    :vartype country: str
    :ivar country_code: Country/region abbreviation for the tenant.
    :vartype country_code: str
    :ivar display_name: The display name of the tenant.
    :vartype display_name: str
    :ivar domains: The list of domains for the tenant.
    :vartype domains: list[str]
    :ivar default_domain: The default domain for the tenant.
    :vartype default_domain: str
    :ivar tenant_type: The tenant type. Only available for 'Home' tenant category.
    :vartype tenant_type: str
    :ivar tenant_branding_logo_url: The tenant's branding logo URL. Only available for 'Home'
     tenant category.
    :vartype tenant_branding_logo_url: str
    """

    _validation = {
        "id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "tenant_category": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "display_name": {"readonly": True},
        "domains": {"readonly": True},
        "default_domain": {"readonly": True},
        "tenant_type": {"readonly": True},
        "tenant_branding_logo_url": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "tenant_category": {"key": "tenantCategory", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "domains": {"key": "domains", "type": "[str]"},
        "default_domain": {"key": "defaultDomain", "type": "str"},
        "tenant_type": {"key": "tenantType", "type": "str"},
        "tenant_branding_logo_url": {"key": "tenantBrandingLogoUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.tenant_category: Optional[Union[str, "_models.TenantCategory"]] = None
        self.country: Optional[str] = None
        self.country_code: Optional[str] = None
        self.display_name: Optional[str] = None
        self.domains: Optional[List[str]] = None
        self.default_domain: Optional[str] = None
        self.tenant_type: Optional[str] = None
        self.tenant_branding_logo_url: Optional[str] = None


class TenantListResult(_serialization.Model):
    """Tenant Ids information.

    All required parameters must be populated in order to send to server.

    :ivar value: An array of tenants.
    :vartype value: list[~azure.mgmt.resource.subscriptions.models.TenantIdDescription]
    :ivar next_link: The URL to use for getting the next set of results. Required.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TenantIdDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, next_link: str, value: Optional[List["_models.TenantIdDescription"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of tenants.
        :paramtype value: list[~azure.mgmt.resource.subscriptions.models.TenantIdDescription]
        :keyword next_link: The URL to use for getting the next set of results. Required.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
