/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef FILTRATIONRULE_H
#define FILTRATIONRULE_H

#include <QList>
#include <QString>
#include <QByteArray>
#include <QSettings>

class Message;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class FiltrationRule
{
  private:
    QString m_name;
    bool    m_isRegExp;
    /// is rule activated now
    bool    m_activated;

    QList<quint16> m_packetType;
    QList<quint64> m_srcIp;
    QList<quint64> m_srcUid;
    QString        m_messageFilter;
    QList<QString> m_userName;
    QList<QString> m_compName;

  public:
    FiltrationRule();
    ~FiltrationRule();

   bool checkMessage(Message*);

   void setActivated(bool theValue){m_activated = theValue;}
   bool activated() const {return m_activated;}

   void setIsRegExp(bool theValue){m_isRegExp = theValue;}
   bool isRegExp() const {return m_isRegExp;}

   void setUserNames(const QString&);
   void setCompNames(const QString&);
   void setIPs   (const QString&);
   void setMessageFilter(const QString& value){m_messageFilter = value;}

   QString userNames    () const;
   QString compNames    () const;
   QString IPs          () const;
   const QString & messageFilter() const {return m_messageFilter;}

   void setName( const QString& theValue ){m_name = theValue;}
   QString name() const {return m_name;}

   void save(QSettings*) const;
   void load(QSettings*);
};

#endif
