/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QuteComAccountXMLSerializer.h"

#include <model/account/qutecom/QuteComAccount.h>

#include <util/Base64.h>
#include <util/Logger.h>
#include <util/String.h>

#include <tinyxml.h>

QuteComAccountXMLSerializer::QuteComAccountXMLSerializer(QuteComAccount & qutecomAccount)
	: _qutecomAccount(qutecomAccount) {
}

std::string QuteComAccountXMLSerializer::serialize() {
	std::string result;

	result += "<qutecomaccount>\n";

	result += "<login>" + _qutecomAccount.getQuteComLogin() + "</login>\n";

	result += "<password>" + Base64::encode(_qutecomAccount.getQuteComPassword()) + "</password>\n";

	result += "<rememberp>" + String::fromBoolean(_qutecomAccount.isPasswordRemembered()) + "</rememberp>\n";

	result += "<voicemail>" + _qutecomAccount.getVoicemailNumber() + "</voicemail>\n";
	
	result += "</qutecomaccount>\n";

	return result;
}

bool QuteComAccountXMLSerializer::unserialize(const std::string & data) {
	TiXmlDocument doc;

	doc.Parse(data.c_str());

	TiXmlHandle docHandle(&doc);
	TiXmlHandle qutecomaccount = docHandle.FirstChild("qutecomaccount");

	// Retrieving login
	TiXmlNode * login = qutecomaccount.FirstChild("login").Node();
	if (login && login->FirstChild()) {
		_qutecomAccount._qutecomLogin = login->FirstChild()->Value();
	} else {
		LOG_ERROR("Invalid QuteComAccount: no login set");
		return false;
	}
	////

	// Retrieving password
	TiXmlNode * password = qutecomaccount.FirstChild("password").Node();
	if (password && password->FirstChild()) {
		_qutecomAccount._qutecomPassword = Base64::decode(password->FirstChild()->Value());
	}
	////

	// Retrieving autologin
	TiXmlNode * rememberpassword = qutecomaccount.FirstChild("rememberp").Node();
	if (rememberpassword && rememberpassword->FirstChild()) {
		String rememberpasswordStr = rememberpassword->FirstChild()->Value();
		_qutecomAccount._rememberPassword = rememberpasswordStr.toBoolean();
	}
	////

	// Retrieving voicemail number
	TiXmlNode * voicemail = qutecomaccount.FirstChild("voicemail").FirstChild().Node();
	if (voicemail) {
		_qutecomAccount.setVoicemailNumber(voicemail->Value());
	}
	////
	
	return true;
}
