/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONRECTANGLE_P_H__
#define __QZIONRECTANGLE_P_H__

#include <QGraphicsItem>
#include <QGraphicsRectItem>
#include <QStyleOptionGraphicsItem>

#include "qzioncommon.h"
#include "qzionrectangle.h"

class QZionRectanglePrivate : public QGraphicsRectItem
{
public:
    QZionRectangle *owner;
    QSet<QZionObject*> clippees;
    QColor color;
    QRect effectiveRect;
    bool colorDirty;
    bool rectDirty;

    QZionRectanglePrivate(QGraphicsItem *parent = 0);

    void updateEffectiveColor();
    void updateEffectiveRect();
    void updateChildren();

    void paint(QPainter *painter,
               const QStyleOptionGraphicsItem *option, QWidget *widget);

    QGV_MOUSE_EVENT_HANDLERS();
    QGV_EFFECTIVE_SHAPE(QGraphicsRectItem);
};

inline QZionRectanglePrivate::QZionRectanglePrivate(QGraphicsItem *parent)
    : QGraphicsRectItem(parent), clippees(), colorDirty(false), rectDirty(false)
{
    setPen(Qt::NoPen);
    setFlag(QGraphicsItem::ItemClipsToShape, true);
    setAcceptHoverEvents(true);
}

inline void QZionRectanglePrivate::paint(QPainter *painter,
                                         const QStyleOptionGraphicsItem *option,
                                         QWidget *widget)
{
    if (owner->_clipReferences > 0)
        return;

    QGraphicsRectItem::paint(painter, option, widget);
}

inline void QZionRectanglePrivate::updateEffectiveColor()
{
    colorDirty = true;
    setBrush(QBrush(owner->effectiveColor()));
    colorDirty = false;
}

inline void QZionRectanglePrivate::updateEffectiveRect()
{
    rectDirty = true;
    effectiveRect = owner->effectiveRect();
    rectDirty = false;
}

inline void QZionRectanglePrivate::updateChildren()
{
    foreach(QZionObject* clippee, clippees) {
        clippee->setClipper(owner);
        clippee->changed();
    }
}

#endif
