% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset_groups}
\alias{subset_groups}
\title{Subset groups}
\usage{
subset_groups(object, groups)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{groups}{character vector with the groups names, numeric vector with the groups indices
or logical vector with the groups to be kept as TRUE.}
}
\value{
A \code{\link{MOFA}} object
}
\description{
Method to subset (or sort) groups
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Subset the first group
model <- subset_groups(model, groups = 1)
}
