% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.modelsum.R
\name{summary.modelsum}
\alias{summary.modelsum}
\alias{as.data.frame.summary.modelsum}
\title{Summarize a \code{modelsum} object.}
\usage{
\method{summary}{modelsum}(
  object,
  ...,
  labelTranslations = NULL,
  text = FALSE,
  title = NULL,
  term.name = "",
  adjustment.names = FALSE
)

\method{as.data.frame}{summary.modelsum}(
  x,
  ...,
  text = x$text,
  term.name = x$term.name,
  adjustment.names = x$adjustment.names,
  width = NULL,
  min.split = NULL,
  list.ok = FALSE
)
}
\arguments{
\item{object}{A \code{\link{modelsum}} object.}

\item{...}{For \code{summary.modelsum}, other arguments passed to \code{\link{as.data.frame.modelsum}}.
For \code{as.data.frame.summary.modelsum}, "width" and "min.split" are passed to \code{\link{smart.split}}.
For \code{print}ing the summary object, these are passed to both \code{as.data.frame.summary.modelsum} and
\code{\link[knitr]{kable}}.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering by the character string
value for the named element of the list, e.g., \code{list(age = "Age(Years)", meansd = "Mean(SD)")}.}

\item{text}{An argument denoting how to print the summary to the screen.
Default is \code{FALSE} (show markdown output). \code{TRUE} and \code{NULL} output a text-only version, with
the latter avoiding all formatting.
\code{"html"} uses the HTML tag \code{<strong>} instead of the markdown formatting, and \code{"latex"} uses
the LaTeX command \code{\\textbf}.}

\item{title}{Title/caption for the table, defaulting to \code{NULL} (no title). Passed to \code{\link[knitr]{kable}}.
Can be length > 1 if the more than one table is being printed.}

\item{term.name}{A character vector denoting the column name for the "terms" column. It should be the same length
as the number of tables or less (it will get recycled if needed). The special value \code{TRUE} will
use the y-variable's label for each table.}

\item{adjustment.names}{Logical, denoting whether the names of the adjustment models should be printed.}

\item{x}{An object of class \code{"summary.modelsum"}.}

\item{width}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{min.split}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{list.ok}{If the object has multiple by-variables, is it okay to return a list of data.frames instead of a single data.frame?
If \code{FALSE} but there are multiple by-variables, a warning is issued.}
}
\value{
An object of class \code{"summary.modelsum"}
}
\description{
Format the information in \code{object} as a table using Pandoc coding or plain text, and cat it to stdout.
}
\seealso{
\code{\link{modelsum}}, \code{\link{as.data.frame.modelsum}}
}
\author{
Ethan Heinzen, based on code originally by Greg Dougherty
}
