% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdb2sse.R
\name{pdb2sse}
\alias{pdb2sse}
\title{Obtain An SSE Sequence Vector From A PDB Object}
\usage{
pdb2sse(pdb, verbose = TRUE)
}
\arguments{
\item{pdb}{an object of class \code{pdb} as obtained from
function \code{\link{read.pdb}}.}

\item{verbose}{logical, if TRUE warnings and other messages will be printed.}
}
\value{
a character vector indicating SSE elements for each amino acide residue.
   The 'names' attribute of the vector contains 'resno', 'chain', 'insert', and
   'SSE segment number', seperated by the character '_'.
}
\description{
Results are similar to that returned by stride(pdb)$sse and dssp(pdb)$sse.
}
\details{
call for its effects.
}
\examples{
\donttest{
   #PDB server connection required - testing excluded

   pdb <- read.pdb("1a7l")
   sse <- pdb2sse(pdb)
   sse
} 
}
\author{
Barry Grant & Xin-Qiu Yao
}
\seealso{
\code{\link{dssp}}, \code{\link{stride}}, \code{\link{bounds.sse}}
}

