% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{bit_rangediff}
\alias{bit_rangediff}
\title{bit range difference}
\usage{
bit_rangediff(rx, y, revx = FALSE, revy = FALSE)
}
\arguments{
\item{rx}{range of integers given as \code{\link[=ri]{ri()}} or as a two-element \code{\link[=integer]{integer()}}}

\item{y}{an integer vector of elements to exclude}

\item{revx}{\code{FALSE} as is, \code{TRUE} to reverse the direction and sign of \code{rx}}

\item{revy}{\code{FALSE} as is, \code{TRUE} to reverse the direction and sign of \code{y}}
}
\value{
an integer vector
}
\description{
Fast version of \code{setdiff(rx[1]:rx[2], y)}.
}
\details{
determines the range of the integers \code{y} and checks if the density justifies use
of a bit vector; if yes, uses a bit vector for the set operation; if no,
falls back to a quicksort and \code{\link[=merge_rangediff]{merge_rangediff()}}
}
\examples{
bit_rangediff(c(1L, 6L), c(3L, 4L))
bit_rangediff(c(6L, 1L), c(3L, 4L))
bit_rangediff(c(6L, 1L), c(3L, 4L), revx=TRUE)
bit_rangediff(c(6L, 1L), c(3L, 4L), revx=TRUE, revy=TRUE)
}
\seealso{
\code{\link[=bit_setdiff]{bit_setdiff()}}, \code{\link[=merge_rangediff]{merge_rangediff()}}
}
