% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.R
\name{stamp}
\alias{stamp}
\alias{stamp_good}
\alias{stamp_bad}
\alias{stamp_wrong}
\alias{stamp_ugly}
\title{Stamp plots with a label, such as good, bad, or ugly.}
\usage{
stamp(p, label, color = "black", alpha = 1, vjust = 1.1, hjust = 1,
  size = 14, family = "", fontface = "bold", clip = "on", colour)

stamp_good(p, ...)

stamp_bad(p, ...)

stamp_wrong(p, ...)

stamp_ugly(p, ...)
}
\arguments{
\item{p}{The plot to stamp}

\item{label}{The text label used for the stamp}

\item{color, colour}{The color of the stamp}

\item{alpha}{Transparency level of the stamp}

\item{hjust, vjust}{Horizontal and vertical adjustment of the label}

\item{size}{Font size}

\item{family}{Font family}

\item{fontface}{Font face}

\item{clip}{Should figure be clipped (default is "on")}

\item{...}{Arguments handed off to \code{stamp()}.}
}
\description{
Stamp plots with a label, such as good, bad, or ugly.
}
\examples{
library(ggplot2)

p <- ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width)) +
  geom_point(aes(color = factor(Petal.Width)))

stamp_bad(p + guides(color = "none"))
stamp_ugly(p)
}
