% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means_by_group.R
\name{means_by_group}
\alias{means_by_group}
\alias{means_by_group.numeric}
\alias{means_by_group.data.frame}
\title{Summary of mean values by group}
\usage{
means_by_group(x, ...)

\method{means_by_group}{numeric}(x, group = NULL, ci = 0.95, weights = NULL, digits = NULL, ...)

\method{means_by_group}{data.frame}(
  x,
  select = NULL,
  group = NULL,
  ci = 0.95,
  weights = NULL,
  digits = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A vector or a data frame.}

\item{...}{Currently not used}

\item{group}{If \code{x} is a numeric vector, \code{group} should be a factor that
indicates the group-classifying categories. If \code{x} is a data frame, \code{group}
should be a character string, naming the variable in \code{x} that is used for
grouping. Numeric vectors are coerced to factors. Not that \code{group} should
only refer to a single variable.}

\item{ci}{Level of confidence interval for mean estimates. Default is \code{0.95}.
Use \code{ci = NA} to suppress confidence intervals.}

\item{weights}{If \code{x} is a numeric vector, \code{weights} should be a vector of
weights that will be applied to weight all observations. If \code{x} is a data
frame, \code{weights} can also be a character string indicating the name of the
variable in \code{x} that should be used for weighting. Default is \code{NULL}, so no
weights are used.}

\item{digits}{Optional scalar, indicating the amount of digits after decimal
point when rounding estimates and values.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-(Sepal.Width:Petal.Length)}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}

\item{verbose}{Toggle warnings.}
}
\value{
A data frame with information on mean and further summary statistics
for each sub-group.
}
\description{
Computes summary table of means by groups.
}
\details{
This function is comparable to \code{aggregate(x, group, mean)}, but provides
some further information, including summary statistics from a One-Way-ANOVA
using \code{x} as dependent and \code{group} as independent variable. \code{\link[emmeans:contrast]{emmeans::contrast()}}
is used to get p-values for each sub-group. P-values indicate whether each
group-mean is significantly different from the total mean.
}
\examples{
data(efc)
means_by_group(efc, "c12hour", "e42dep")

data(iris)
means_by_group(iris, "Sepal.Width", "Species")

# weighting
efc$weight <- abs(rnorm(n = nrow(efc), mean = 1, sd = .5))
means_by_group(efc, "c12hour", "e42dep", weights = "weight")
}
