% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_logistic.R
\name{dist_logistic}
\alias{dist_logistic}
\title{The Logistic distribution}
\usage{
dist_logistic(location, scale)
}
\arguments{
\item{location}{location and scale parameters.}

\item{scale}{location and scale parameters.}
}
\description{
\lifecycle{stable}
}
\details{
A continuous distribution on the real line. For binary outcomes
the model given by \eqn{P(Y = 1 | X) = F(X \beta)} where
\eqn{F} is the Logistic \code{\link[=cdf]{cdf()}} is called \emph{logistic regression}.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a Logistic random variable with
\code{location} = \eqn{\mu} and \code{scale} = \eqn{s}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: \eqn{\mu}

\strong{Variance}: \eqn{s^2 \pi^2 / 3}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{e^{-(\frac{x - \mu}{s})}}{s [1 + \exp(-(\frac{x - \mu}{s})) ]^2}
  }{
    f(x) = e^(-(t - \mu) / s) / (s (1 + e^(-(t - \mu) / s))^2)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(t) = \frac{1}{1 + e^{-(\frac{t - \mu}{s})}}
  }{
    F(t) = 1 / (1 +  e^(-(t - \mu) / s))
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\mu t} \beta(1 - st, 1 + st)
  }{
    E(e^(tX)) = = e^(\mu t) \beta(1 - st, 1 + st)
  }

where \eqn{\beta(x, y)} is the Beta function.
}
\examples{
dist <- dist_logistic(location = c(5,9,9,6,2), scale = c(2,3,4,2,1))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Logistic]{stats::Logistic}
}
