% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-class.R
\name{backend}
\alias{backend}
\title{Abstract class of a minimal keyring backend}
\description{
To implement a new keyring backend, you need to inherit from this
class and then redefine the \code{get}, \code{set}, \code{set_with_value} and \code{delete}
methods. Implementing the \code{list} method is optional. Additional methods
can be defined as well.
}
\details{
These are the semantics of the various methods:\preformatted{get(service, username = NULL, keyring = NULL)
get_raw(service, username = NULL, keyring = NULL)
set(service, username = NULL, keyring = NULL, prompt = "Password: ")
set_with_value(service, username = NULL, password = NULL,
               keyring = NULL)
set_with_raw_value(service, username = NULL, password = NULL,
               keyring = NULL)
delete(service, username = NULL, keyring = NULL)
list(service = NULL, keyring = NULL)
}

What these functions do:
\itemize{
\item \code{get()} queries the secret in a keyring item.
\item \code{get_raw()} is similar to \code{get()}, but returns the result as a raw
vector.
\item \code{set()} sets the secret in a keyring item. The secret itself is read
in interactively from the keyboard.
\item \code{set_with_value()} sets the secret in a keyring item to the specified
value.
\item \code{set_with_raw_value()} sets the secret in keyring item to the
byte sequence of a raw vector.
\item \code{delete()} remotes a keyring item.
\item \code{list()} lists keyring items.
}

The arguments:
\itemize{
\item \code{service} String, the name of a service. This is used to find the
secret later.
\item \code{username} String, the username associated with a secret. It can be
\code{NULL}, if no username belongs to the secret. It uses the value of
the \code{keyring_username}, if set.
\item \code{keyring} String, the name of the keyring to work with. This only makes
sense if the platform supports multiple keyrings. \code{NULL} selects the
default (and maybe only) keyring.
\item \code{password} The value of the secret, typically a password, or other
credential.
\item \code{prompt} String, the text to be displayed above the textbox.
}
}
\seealso{
Other keyring backend base classes: 
\code{\link{backend_keyrings}}
}
\concept{keyring backend base classes}
