% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_sp.R
\name{rl_sp}
\alias{rl_sp}
\alias{rl_sp_}
\title{Get species}
\usage{
rl_sp(page = 0, key = NULL, parse = TRUE, all = FALSE, quiet = FALSE, ...)

rl_sp_(page, key = NULL, all = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{page}{(integer/numeric) Page to get. Default: 0. you can
get up to 10,000 records per page. Paging is required because
it's too much burden on a server to just "get all the data"
in one request}

\item{key}{A IUCN API token. See \code{\link{rl_use_iucn}}.}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{all}{(logical) to get all results or not. Default: \code{FALSE}.
this means we do the paging internally for you. result is a list
of results, so you have to bind them together yourself into
a data.frame, see example}

\item{quiet}{(logical) give progress for download or not.
Default: \code{FALSE} (that is, give progress). ignored if
\code{all = FALSE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Get species
}
\examples{
\dontrun{
rl_sp(page = 3)

# get all results
out <- rl_sp(all = TRUE)
length(out)
vapply(out, "[[", 1, "count")
all_df <- do.call(rbind, lapply(out, "[[", "result"))
head(all_df)
NROW(all_df)
}
}
