% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{as.Graph}
\alias{as.Graph}
\alias{as.Graph.Matrix}
\alias{as.Graph.matrix}
\title{Convert a matrix (or Matrix) to the Graph class.}
\usage{
as.Graph(x, ...)

\method{as.Graph}{Matrix}(x, ...)

\method{as.Graph}{matrix}(x, ...)
}
\arguments{
\item{x}{The matrix to convert}

\item{...}{Arguments passed to other methods (ignored for now)}
}
\description{
Convert a matrix (or Matrix) to the Graph class.
}
\examples{
# converting sparse matrix
mat <- Matrix::rsparsematrix(nrow = 10, ncol = 10, density = 0.1)
rownames(x = mat) <- paste0("feature_", 1:10)
colnames(x = mat) <- paste0("cell_", 1:10)
g <- as.Graph(x = mat)

# converting dense matrix
mat <- matrix(data = 1:16, nrow = 4)
rownames(x = mat) <- paste0("feature_", 1:4)
colnames(x = mat) <- paste0("cell_", 1:4)
g <- as.Graph(x = mat)

}
