% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calendar.R
\name{stri_datetime_add}
\alias{stri_datetime_add}
\alias{stri_datetime_add<-}
\title{Date and Time Arithmetic}
\usage{
stri_datetime_add(
  time,
  value = 1L,
  units = "seconds",
  tz = NULL,
  locale = NULL
)

stri_datetime_add(time, units = "seconds", tz = NULL, locale = NULL) <- value
}
\arguments{
\item{time}{an object of class \code{\link{POSIXct}}
(\code{as.POSIXct} will be called on character vectors
and objects of class \code{POSIXlt}, \code{Date}, and \code{factor})}

\item{value}{integer vector; signed number of units to add to \code{time}}

\item{units}{single string; one of \code{'years'}, \code{'months'},
\code{'weeks'}, \code{'days'}, \code{'hours'}, \code{'minutes'},
\code{'seconds'}, or \code{'milliseconds'}}

\item{tz}{\code{NULL} or \code{''} for the default time zone
or a single string with a timezone identifier,}

\item{locale}{\code{NULL} or \code{''} for default locale,
or a single string with locale identifier; a non-Gregorian calendar
may be specified by setting the \code{@calendar=name} keyword}
}
\value{
Both functions return an object of class \code{\link{POSIXct}}.

The replacement version of \code{stri_datetime_add} modifies
the state of the \code{time} object.
}
\description{
Modifies a date-time object by adding a specific amount of time units.
}
\details{
Vectorized over \code{time} and \code{value}.


Note that, e.g., January, 31 + 1 month = February, 28 or 29.
}
\examples{
x <- stri_datetime_now()
stri_datetime_add(x, units='months') <- 2
print(x)
stri_datetime_add(x, -2, units='months')
stri_datetime_add(stri_datetime_create(2014, 4, 20), 1, units='years')
stri_datetime_add(stri_datetime_create(2014, 4, 20), 1, units='years', locale='@calendar=hebrew')

stri_datetime_add(stri_datetime_create(2016, 1, 31), 1, units='months')

}
\references{
\emph{Calendar Classes} - ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/datetime/calendar/}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other datetime: 
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
