/* Copyright (c) 1996-2004, Adaptec Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name of the Adaptec Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/****************************************************************************
*
* Created:  12/20/00
*
*****************************************************************************
*
* File Name:            setscfg.cpp
* Module:
* Contributors:         Edrick Estrada
* Description:
* Version Control:
*
* $Revision: 1 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "setscfg.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** EXTERNAL DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

setscfg::setscfg ()
{
   ENTER("setscfg::setscfg (");
   EXIT();
}



setscfg::~setscfg()
{
   ENTER( "setscfg::~setscfg()" );
   EXIT();
}

/*******************************************************
Main exe loop 
*******************************************************/
Command::Dpt_Error setscfg::execute(String_List **output)
{
	ENTER("Command::Dpt_Error setscfg::execute(String_List **output)");
   
	Dpt_Error err;

	Init_Engine();

	String_List *out;
	*output = out = new String_List();

	engine->Reset();
    if (engine->Send( MSG_RAID_HW_ENABLE ) == MSG_RTN_COMPLETED){

		out->add_Item("System Configuration set.");
		out->add_Item("\n");
	}
   return (err);
}

Command &setscfg::Clone() const
{
        ENTER("Command &setscfg::Clone() const");
        EXIT();
        return(*new setscfg(*this));
}