// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LuaService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.luaservice {

  public class ScriptState : ICloneable {
    public object Clone() {
      ScriptState copy = new ScriptState();
      copy.execState = this.execState;
      copy.exitType = this.exitType;
      copy.exitStatus = this.exitStatus;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["execState"] = (int)this.execState;
      json["exitType"] = (int)this.exitType;
      json["exitStatus"] = this.exitStatus;
      return json;
    }

    public static ScriptState Decode(LightJson.JsonObject json, Agent agent) {
      ScriptState inst = new ScriptState();
      inst.execState = (Com.Raritan.Idl.luaservice.ScriptState.ExecState)(int)json["execState"];
      inst.exitType = (Com.Raritan.Idl.luaservice.ScriptState.ExitType)(int)json["exitType"];
      inst.exitStatus = (int)json["exitStatus"];
      return inst;
    }


    public enum ExecState {
      STAT_NEW,
      STAT_RUNNING,
      STAT_TERMINATED,
      STAT_RESTARTING,
    }

    public enum ExitType {
      EXIT_CODE,
      SIGNAL,
    }
    public Com.Raritan.Idl.luaservice.ScriptState.ExecState execState = Com.Raritan.Idl.luaservice.ScriptState.ExecState.STAT_NEW;
    public Com.Raritan.Idl.luaservice.ScriptState.ExitType exitType = Com.Raritan.Idl.luaservice.ScriptState.ExitType.EXIT_CODE;
    public int exitStatus = 0;
  }
}
