#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char** argv) {
  environment rheolef (argc,argv);
  Float inv_lambda;
  field uh;
  din >> catchmark("inv_lambda") >> inv_lambda
      >> catchmark("u")          >> uh;
  const geo& omega = uh.get_geo();
  const space& Xh  = uh.get_space();
  string grad_approx = "P" + itos(Xh.degree()-1) + "d";
  space Th  (omega, grad_approx, "tensor");
  size_t d = omega.dimension();
  tensor I = tensor::eye (d);
  field sigma_h = (inv_lambda == 0) ?
      interpolate (Th, 2*D(uh)) :
      interpolate (Th, 2*D(uh) + (1/inv_lambda)*div(uh)*I);
  dout << catchmark("s") << sigma_h;
}
