///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*
 USAGE:
  mkgeo_grid -T 5 > boite-5.geo
  ./search_element_containing boite-5.geo 0.5 0.6 0.7
  gnuplot
  > splot 'output-elt.gdat' w lp, 'output-pt.gdat' w lp
*/
#include "rheolef/geo_tree.h"
#include "rheolef/geo.h"
#include "rheolef/geo-visu-aux.h"
using namespace rheolef;
using namespace std;

int main(int argc, char** argv)
{
    const geo g(argv[1]);
    geo_tree t (g.map_dimension(), g.xmin(), g.xmax(),
	g.n_vertice(), g.begin_node(),
	g.size(), g.begin());

    if (argc == 2) {
	t.put_gnuplot();
	return 0;
    }
    point x;
    x[0] = atof(argv[2]);
    x[1] = (argc > 3) ? atof(argv[3]) : 0;
    x[2] = (argc > 4) ? atof(argv[4]) : 0;
    bool no_plot = (argc > 5);
    size_t idx = t.search_element_containing(g.begin(), x);
    if (idx == numeric_limits<size_t>::max()) {
      cout << "no element contains" << endl;
      return 1;
    }
    cout << "element that contains : " << idx << endl;
    if (no_plot) return 0;
    const geo_element& K = *(g.begin() + idx);
    ofstream elt ("output-elt.gdat");
    cerr << "! file \"output-elt.gdat\" created." << endl;
    if (idx != numeric_limits<size_t>::max())
	gnuplot_element (elt, K, g.begin_node(), g.map_dimension());
    elt.close();

    ofstream pt ("output-pt.gdat");
    cerr << "! file \"output-pt.gdat\" created." << endl;
    x.put (pt, g.map_dimension());
    pt.close();
    return 0;
}
