#include "rheolef.h"
using namespace rheolef;
using namespace std;
void usage(string name) {
  cerr << name << ": usage: "
       << name << " "
       << "file[.mfield[.gz]] "
       << "[-check] "
       << "[-residue] "
       << "[-criteria] "
       << endl;
  exit (1);
}
field residue (Float p, const field& u0h) {
  const space& V0h = u0h.get_space();
  string grad_approx = (V0h.get_approx() == "P2") ? "P1d" : "P0";
  space Vh (V0h.get_geo(), V0h.get_approx());
  space Th (Vh.get_geo(), grad_approx, "vector");
  Vh.block ("boundary");
  field uh(Vh);
  for (size_t i = 0; i < uh.size(); i++) uh.at(i) = u0h.at(i);
  field fh (Vh, 1);
  form m     (Vh, Vh, "mass");
  form inv_mt(Th, Th, "inv_mass");
  form grad  (Vh, Th, "grad");
  field grad_uh = inv_mt*(grad*uh);
  field w0h = pow(euclidian_norm2(grad_uh), p/2 - 1);
  form a (Vh, Vh, "grad_grad", w0h);
  field mrh = a*uh - m*fh;
  mrh.b = 0;
  ssk<Float> fact_m = ldlt(m.uu);
  field rh (Vh);
  rh.u = fact_m.solve(mrh.u);
  rh.b = 0;
  return rh;
}
void check (Float p, const field& uh) {
  field rh = residue(p, uh);
  const space& Vh = rh.get_space();
  form m (Vh, Vh, "mass");
  Float res = sqrt(m(rh,rh));
  cerr << "check: residue = " << res << endl;
  check_macro (res < 1e-3, "unexpected residue");
}
field criteria (Float p, const field& uh) {
  if (uh.get_approx() == "P1") return abs(uh);
  const space& Vh = uh.get_space();
  string grad_approx = (Vh.get_approx() == "P2") ? "P1d" : "P0";
  space Th (Vh.get_geo(), grad_approx, "vector");
  form inv_mt(Th, Th, "inv_mass");
  form grad  (Vh, Th, "grad");
  field grad_uh = inv_mt*(grad*uh);
  field norm_grad_uh = euclidian_norm(grad_uh);
  return pow(norm_grad_uh, p/2);
}
int main(int argc, char**argv) {
  if (argc < 3) usage(argv[0]);
  Float p;
  field uh;
  if (strcmp (argv[1], "-") == 0)  {
    cin >> catchmark("p")     >> p
        >> catchmark("u")     >> uh;
  } else {
    irheostream in (argv[1], "mfield");
     in >> catchmark("p")     >> p
        >> catchmark("u")     >> uh;
  }
  for (int i = 2; i < argc; i++) {
    if (strcmp (argv[i], "-check") == 0) { check (p, uh); }
    else if (strcmp (argv[i], "-residue") == 0) { cout << catchmark("ru")   << residue (p, uh); }
    else if (strcmp (argv[i], "-criteria") == 0) { cout << catchmark("c")   << criteria (p, uh); }
    else {
       cerr << argv[0] << ": unknown option \'" << argv[i] << "'" << endl;
       usage(argv[0]);
    }
  }
  return 0;
}
