use itertools::Itertools;
use malachite_base::vecs::exhaustive::lex_k_compositions;

fn lex_k_compositions_helper(n: usize, k: usize, out: &[&[usize]]) {
    let xss = lex_k_compositions(n, k).collect_vec();
    assert_eq!(xss.iter().map(Vec::as_slice).collect_vec().as_slice(), out);
}

#[test]
fn test_lex_k_compositions() {
    lex_k_compositions_helper(0, 0, &[&[]]);
    lex_k_compositions_helper(0, 1, &[]);
    lex_k_compositions_helper(1, 0, &[]);
    lex_k_compositions_helper(1, 1, &[&[1]]);
    lex_k_compositions_helper(1, 2, &[]);
    lex_k_compositions_helper(2, 0, &[]);
    lex_k_compositions_helper(2, 1, &[&[2]]);
    lex_k_compositions_helper(2, 2, &[&[1, 1]]);
    lex_k_compositions_helper(2, 3, &[]);

    lex_k_compositions_helper(5, 0, &[]);
    lex_k_compositions_helper(5, 1, &[&[5]]);
    lex_k_compositions_helper(5, 2, &[&[1, 4], &[2, 3], &[3, 2], &[4, 1]]);
    lex_k_compositions_helper(
        5,
        3,
        &[&[1, 1, 3], &[1, 2, 2], &[1, 3, 1], &[2, 1, 2], &[2, 2, 1], &[3, 1, 1]],
    );
    lex_k_compositions_helper(
        5,
        4,
        &[&[1, 1, 1, 2], &[1, 1, 2, 1], &[1, 2, 1, 1], &[2, 1, 1, 1]],
    );
    lex_k_compositions_helper(5, 5, &[&[1, 1, 1, 1, 1]]);
    lex_k_compositions_helper(5, 6, &[]);

    lex_k_compositions_helper(
        10,
        5,
        &[
            &[1, 1, 1, 1, 6],
            &[1, 1, 1, 2, 5],
            &[1, 1, 1, 3, 4],
            &[1, 1, 1, 4, 3],
            &[1, 1, 1, 5, 2],
            &[1, 1, 1, 6, 1],
            &[1, 1, 2, 1, 5],
            &[1, 1, 2, 2, 4],
            &[1, 1, 2, 3, 3],
            &[1, 1, 2, 4, 2],
            &[1, 1, 2, 5, 1],
            &[1, 1, 3, 1, 4],
            &[1, 1, 3, 2, 3],
            &[1, 1, 3, 3, 2],
            &[1, 1, 3, 4, 1],
            &[1, 1, 4, 1, 3],
            &[1, 1, 4, 2, 2],
            &[1, 1, 4, 3, 1],
            &[1, 1, 5, 1, 2],
            &[1, 1, 5, 2, 1],
            &[1, 1, 6, 1, 1],
            &[1, 2, 1, 1, 5],
            &[1, 2, 1, 2, 4],
            &[1, 2, 1, 3, 3],
            &[1, 2, 1, 4, 2],
            &[1, 2, 1, 5, 1],
            &[1, 2, 2, 1, 4],
            &[1, 2, 2, 2, 3],
            &[1, 2, 2, 3, 2],
            &[1, 2, 2, 4, 1],
            &[1, 2, 3, 1, 3],
            &[1, 2, 3, 2, 2],
            &[1, 2, 3, 3, 1],
            &[1, 2, 4, 1, 2],
            &[1, 2, 4, 2, 1],
            &[1, 2, 5, 1, 1],
            &[1, 3, 1, 1, 4],
            &[1, 3, 1, 2, 3],
            &[1, 3, 1, 3, 2],
            &[1, 3, 1, 4, 1],
            &[1, 3, 2, 1, 3],
            &[1, 3, 2, 2, 2],
            &[1, 3, 2, 3, 1],
            &[1, 3, 3, 1, 2],
            &[1, 3, 3, 2, 1],
            &[1, 3, 4, 1, 1],
            &[1, 4, 1, 1, 3],
            &[1, 4, 1, 2, 2],
            &[1, 4, 1, 3, 1],
            &[1, 4, 2, 1, 2],
            &[1, 4, 2, 2, 1],
            &[1, 4, 3, 1, 1],
            &[1, 5, 1, 1, 2],
            &[1, 5, 1, 2, 1],
            &[1, 5, 2, 1, 1],
            &[1, 6, 1, 1, 1],
            &[2, 1, 1, 1, 5],
            &[2, 1, 1, 2, 4],
            &[2, 1, 1, 3, 3],
            &[2, 1, 1, 4, 2],
            &[2, 1, 1, 5, 1],
            &[2, 1, 2, 1, 4],
            &[2, 1, 2, 2, 3],
            &[2, 1, 2, 3, 2],
            &[2, 1, 2, 4, 1],
            &[2, 1, 3, 1, 3],
            &[2, 1, 3, 2, 2],
            &[2, 1, 3, 3, 1],
            &[2, 1, 4, 1, 2],
            &[2, 1, 4, 2, 1],
            &[2, 1, 5, 1, 1],
            &[2, 2, 1, 1, 4],
            &[2, 2, 1, 2, 3],
            &[2, 2, 1, 3, 2],
            &[2, 2, 1, 4, 1],
            &[2, 2, 2, 1, 3],
            &[2, 2, 2, 2, 2],
            &[2, 2, 2, 3, 1],
            &[2, 2, 3, 1, 2],
            &[2, 2, 3, 2, 1],
            &[2, 2, 4, 1, 1],
            &[2, 3, 1, 1, 3],
            &[2, 3, 1, 2, 2],
            &[2, 3, 1, 3, 1],
            &[2, 3, 2, 1, 2],
            &[2, 3, 2, 2, 1],
            &[2, 3, 3, 1, 1],
            &[2, 4, 1, 1, 2],
            &[2, 4, 1, 2, 1],
            &[2, 4, 2, 1, 1],
            &[2, 5, 1, 1, 1],
            &[3, 1, 1, 1, 4],
            &[3, 1, 1, 2, 3],
            &[3, 1, 1, 3, 2],
            &[3, 1, 1, 4, 1],
            &[3, 1, 2, 1, 3],
            &[3, 1, 2, 2, 2],
            &[3, 1, 2, 3, 1],
            &[3, 1, 3, 1, 2],
            &[3, 1, 3, 2, 1],
            &[3, 1, 4, 1, 1],
            &[3, 2, 1, 1, 3],
            &[3, 2, 1, 2, 2],
            &[3, 2, 1, 3, 1],
            &[3, 2, 2, 1, 2],
            &[3, 2, 2, 2, 1],
            &[3, 2, 3, 1, 1],
            &[3, 3, 1, 1, 2],
            &[3, 3, 1, 2, 1],
            &[3, 3, 2, 1, 1],
            &[3, 4, 1, 1, 1],
            &[4, 1, 1, 1, 3],
            &[4, 1, 1, 2, 2],
            &[4, 1, 1, 3, 1],
            &[4, 1, 2, 1, 2],
            &[4, 1, 2, 2, 1],
            &[4, 1, 3, 1, 1],
            &[4, 2, 1, 1, 2],
            &[4, 2, 1, 2, 1],
            &[4, 2, 2, 1, 1],
            &[4, 3, 1, 1, 1],
            &[5, 1, 1, 1, 2],
            &[5, 1, 1, 2, 1],
            &[5, 1, 2, 1, 1],
            &[5, 2, 1, 1, 1],
            &[6, 1, 1, 1, 1],
        ],
    );
}
