/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Rental : Vehicle rental
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Rental {
    /// Vehicle share system ID
    #[serde(rename = "systemId")]
    pub system_id: String,
    /// Vehicle share system name
    #[serde(rename = "systemName", skip_serializing_if = "Option::is_none")]
    pub system_name: Option<String>,
    /// URL of the vehicle share system
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// Name of the station
    #[serde(rename = "stationName", skip_serializing_if = "Option::is_none")]
    pub station_name: Option<String>,
    /// Rental URI for Android (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriAndroid", skip_serializing_if = "Option::is_none")]
    pub rental_uri_android: Option<String>,
    /// Rental URI for iOS (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriIOS", skip_serializing_if = "Option::is_none")]
    pub rental_uri_ios: Option<String>,
    /// Rental URI for web (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriWeb", skip_serializing_if = "Option::is_none")]
    pub rental_uri_web: Option<String>,
    #[serde(rename = "formFactor", skip_serializing_if = "Option::is_none")]
    pub form_factor: Option<models::RentalFormFactor>,
    #[serde(rename = "propulsionType", skip_serializing_if = "Option::is_none")]
    pub propulsion_type: Option<models::RentalPropulsionType>,
    #[serde(rename = "returnConstraint", skip_serializing_if = "Option::is_none")]
    pub return_constraint: Option<models::RentalReturnConstraint>,
}

impl Rental {
    /// Vehicle rental
    pub fn new(system_id: String) -> Rental {
        Rental {
            system_id,
            system_name: None,
            url: None,
            station_name: None,
            rental_uri_android: None,
            rental_uri_ios: None,
            rental_uri_web: None,
            form_factor: None,
            propulsion_type: None,
            return_constraint: None,
        }
    }
}

