/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TextEditDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/25
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "etc.h"
#include "culcfunc.h"
#define _TEXTEDITDLG_
#include "TextEditDlg.h"


/* -----------------------------------------------------------------------------
 * FileName
 */
void text_edit_dlg_FileName_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], FileName[256], dummy[256];
	
	/* text_edit_dlg->text_entry に入っている文字列を得る */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));
	
	strcpy(dummy, NowFile);
	strcpy(FileName, getFileName(dummy));
	cutExtName(FileName);
	
	strcat(FileName, str);
	
	/* text_edit_dlg->text_entry に文字列を設定する */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), FileName);
}


/* -----------------------------------------------------------------------------
 * φ
 */
void text_edit_dlg_Fai_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], fai_str[256];
	
	/* text_edit_dlg->text_entry に入っている文字列を得る */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));
	
	strcpy(fai_str, "φ");
	strcat(fai_str, str);
	
	/* text_edit_dlg->text_entry に文字列を設定する */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), fai_str);
}


/* -----------------------------------------------------------------------------
 * R
 */
void text_edit_dlg_R_pushed(GtkWidget *widget, TEXT_EDIT_DLG *text_edit_dlg)
{
	char str[256], fai_str[256];
	
	/* text_edit_dlg->text_entry に入っている文字列を得る */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(text_edit_dlg->entry_Text)));
	
	strcpy(fai_str, "R");
	strcat(fai_str, str);
	
	/* text_edit_dlg->text_entry に文字列を設定する */
	gtk_entry_set_text(GTK_ENTRY(text_edit_dlg->entry_Text), fai_str);
}


/* -----------------------------------------------------------------------------
 * CANCEL
 */
void text_edit_dlg_cancel_pushed(GtkWidget *widget, TEXT_EDIT_DLG *a)
{
	strcpy(a->Text, "");
	strcpy(a->UpperText, "");
	strcpy(a->LowerText, "");
	a->FontHeight = 0;
	a->FontSpace = 0;
	a->WordSpace = 0;
	a->FontOverLineSpace = 0;
	a->Angle = 0;
	a->SearchPointX = 0;
	a->SearchPointY = 0;
	a->FitPointX = 0;
	a->FitPointY = 0;
}


/* -----------------------------------------------------------------------------
 * OK
 */
void text_edit_dlg_ok_pushed(GtkWidget *widget, TEXT_EDIT_DLG *a)
{
	/* テキストエントリーから文字列を取得 */
	
	/* Text */
	strcpy(a->Text, gtk_entry_get_text(GTK_ENTRY(a->entry_Text)));
	/* UpperText */
	strcpy(a->UpperText, gtk_entry_get_text(GTK_ENTRY(a->entry_UpperText)));
	/* LowerText */
	strcpy(a->LowerText, gtk_entry_get_text(GTK_ENTRY(a->entry_LowerText)));
	
	/* FontHeight */
	a->FontHeight = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontHeight)));
	/* FontSpace */
	a->FontSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontSpace)));
	/* WordSpace */
	a->WordSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_WordSpace)));
	/* FontOverLineSpace */
	a->FontOverLineSpace = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FontOverLineSpace)));
	
	/* SearchPointX */
	a->SearchPointX = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_SearchPointX)));
	/* SearchPointY */
	a->SearchPointY = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_SearchPointY)));
	/* Angle */
	a->Angle = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_Angle)));
	/* FitPointX */
	a->FitPointX = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FitPointX)));
	/* FitPointY */
	a->FitPointY = atof(gtk_entry_get_text(GTK_ENTRY(a->entry_FitPointY)));
}


/* -----------------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint text_edit_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, TEXT_EDIT_DLG *text_edit_dlg)
{
	switch (event->keyval) {
	case GDK_Return:
	case GDK_KP_Enter:
		/* フォーカス entry_Text で Enter ならフォーカスを entry_UpperText に移す */
		if (GTK_WIDGET(text_edit_dlg->entry_Text) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_UpperText);
		}
		/* フォーカス entry_UpperText で Enter ならフォーカスを entry_LowerText に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_UpperText) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_LowerText);
		}
		/* フォーカス entry_LowerText で Enter ならフォーカスを entry_FontHeight に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_LowerText) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_FontHeight);
		}
		/* フォーカス entry_FontHeight で Enter ならフォーカスを entry_FontSpace に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_FontHeight) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_FontSpace);
		}
		/* フォーカス entry_FontSpace で Enter ならフォーカスを entry_WordSpace に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_FontSpace) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_WordSpace);
		}
		/* フォーカス entry_WordSpace で Enter ならフォーカスを entry_FontOverLineSpace に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_WordSpace) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_FontOverLineSpace);
		}
		/* フォーカス entry_FontOverLineSpace で Enter ならフォーカスを entry_SearchPointX に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_FontOverLineSpace) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_SearchPointX);
		}
		/* フォーカス entry_SearchPointX で Enter ならフォーカスを entry_SearchPointY に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_SearchPointX) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_SearchPointY);
		}
		/* フォーカス entry_SearchPointY で Enter ならフォーカスを entry_Angle に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_SearchPointY) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_Angle);
		}
		/* フォーカス entry_Angle で Enter ならフォーカスを entry_FitPointX に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_Angle) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_FitPointX);
		}
		/* フォーカス entry_FitPointX で Enter ならフォーカスを entry_FitPointY に移す */
		else if (GTK_WIDGET(text_edit_dlg->entry_FitPointX) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_FitPointY);
		}
		/* フォーカス entry_FitPointY で Enter なら終わり */
		else if (GTK_WIDGET(text_edit_dlg->entry_FitPointY) 
				== GTK_WINDOW(text_edit_dlg->dialog)->focus_widget) 
		{
			text_edit_dlg_ok_pushed(widget, text_edit_dlg);
			gtk_main_quit();
		}
		return TRUE;
		break;
	default:
		break;
	}
	return FALSE; 
}


/* -----------------------------------------------------------------------------
 * 寸法値設定ボックス
 */
gint make_box_text(GtkWidget *vbox_Text, TEXT_EDIT_DLG *a)
{
	GtkWidget *hbox_Text1;
	GtkWidget *label_Text;
	GtkWidget *hbox_Text2;
	GtkWidget *label_UpperText;
	GtkWidget *label_LowerText;
	
	/* パッキングボックス(hbox_Text1) 作成 */
	hbox_Text1 = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(vbox_Text), hbox_Text1, TRUE, TRUE, 0);
	gtk_widget_show(hbox_Text1);
	
			/* label_Text */
			label_Text = gtk_label_new( _("Size Value") );
			gtk_misc_set_alignment(GTK_MISC(label_Text), 0.0f, 1.0f);
			gtk_widget_set_size_request(label_Text, TED_LABEL_WIDTH, TED_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text1), label_Text, FALSE, TRUE, 0);
			gtk_widget_show(label_Text);
			
			/* entry_Text */
			a->entry_Text = gtk_entry_new();
			gtk_widget_set_size_request(a->entry_Text, TED_ENTRY_WIDTH, TED_HEIGHT);
			gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text1), a->entry_Text, FALSE, TRUE, 0);
			gtk_entry_set_max_length(GTK_ENTRY(a->entry_Text), 256);
			gtk_entry_set_text(GTK_ENTRY(a->entry_Text), a->Text);	/* 初期値設定 */
			gtk_widget_show(a->entry_Text);
			
			
	/* パッキングボックス(hbox_Text2) 作成 */
	hbox_Text2 = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(vbox_Text), hbox_Text2, TRUE, TRUE, 0);
	gtk_widget_show(hbox_Text2);
		
		/* label_UpperText */
		label_UpperText = gtk_label_new( _("Maximum") );
		gtk_misc_set_alignment(GTK_MISC(label_UpperText), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_UpperText, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), label_UpperText, FALSE, TRUE, 0);
		gtk_widget_show(label_UpperText);
		
		/* entry_UpperText */
		a->entry_UpperText = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_UpperText, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), a->entry_UpperText, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_UpperText), 256);
		gtk_entry_set_text(GTK_ENTRY(a->entry_UpperText), a->UpperText);	/* 初期値設定 */
		gtk_widget_show(a->entry_UpperText);
		
		/* label_LowerText */
		label_LowerText = gtk_label_new( _("Minimum") );
		gtk_misc_set_alignment(GTK_MISC(label_LowerText), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_LowerText, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), label_LowerText, FALSE, TRUE, 0);
		gtk_widget_show(label_LowerText);
		
		/* entry_LowerText */
		a->entry_LowerText = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_LowerText, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(hbox_Text2), a->entry_LowerText, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_LowerText), 256);
		gtk_entry_set_text(GTK_ENTRY(a->entry_LowerText), a->UpperText);	/* 初期値設定 */
		gtk_widget_show(a->entry_LowerText);
		
	return 1;
}


/* -----------------------------------------------------------------------------
 * その他設定ボックス
 */
gint make_box_etc(GtkWidget *hbox_etc, TEXT_EDIT_DLG *a)
{
	char str[256];
	
	GtkWidget *vbox_label_etc1;
	GtkWidget *label_FontHeight;
	GtkWidget *label_FontSpace;
	GtkWidget *label_WordSpace;
	GtkWidget *label_FontOverLineSpace;
	GtkWidget *vbox_entry_etc1;
	GtkWidget *vbox_label_etc2;
	GtkWidget *label_SearchPointX;
	GtkWidget *label_SearchPointY;
	GtkWidget *label_Angle;
	GtkWidget *label_FitPointX;
	GtkWidget *label_FitPointY;
	GtkWidget *vbox_entry_etc2;
	
	
	/* パッキングボックス(vbox_label_etc1) 作成 */
	vbox_label_etc1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_label_etc1, TRUE, TRUE, 0);
	gtk_widget_show(vbox_label_etc1);
	
		/* label_FontHeight */
		label_FontHeight = gtk_label_new( _("Height of the character") );
		gtk_misc_set_alignment(GTK_MISC(label_FontHeight), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_FontHeight, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontHeight, FALSE, TRUE, 0);
		gtk_widget_show(label_FontHeight);
		
		/* label_FontSpace */
		label_FontSpace = gtk_label_new( _("Interval of the character") );
		gtk_misc_set_alignment(GTK_MISC(label_FontSpace), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_FontSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_FontSpace);
		
		/* label_WordSpace */
		label_WordSpace = gtk_label_new( _("Interval of the word") );
		gtk_misc_set_alignment(GTK_MISC(label_WordSpace), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_WordSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_WordSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_WordSpace);
		
		/* label_FontOverLineSpace */
		label_FontOverLineSpace = gtk_label_new( _("The offset from the size line") );
		gtk_misc_set_alignment(GTK_MISC(label_FontOverLineSpace), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_FontOverLineSpace, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc1), label_FontOverLineSpace, FALSE, TRUE, 0);
		gtk_widget_show(label_FontOverLineSpace);
		
		
	/* パッキングボックス(vbox_entry_etc1) 作成 */
	vbox_entry_etc1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_entry_etc1, TRUE, TRUE, 0);
	gtk_widget_show(vbox_entry_etc1);
	
		/* entry_FontHeight */
		a->entry_FontHeight = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_FontHeight, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontHeight, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_FontHeight), 256);
		FloatOut_n(str, a->FontHeight, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontHeight), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_FontHeight);
		
		/* entry_FontSpace */
		a->entry_FontSpace = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_FontSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontSpace, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_FontSpace), 256);
		FloatOut_n(str, a->FontSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontSpace), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_FontSpace);
		
		/* entry_WordSpace */
		a->entry_WordSpace = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_WordSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_WordSpace, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_WordSpace), 256);
		FloatOut_n(str, a->WordSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_WordSpace), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_WordSpace);
		
		/* entry_FontOverLineSpace */
		a->entry_FontOverLineSpace = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_FontOverLineSpace, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc1), a->entry_FontOverLineSpace, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_FontOverLineSpace), 256);
		FloatOut_n(str, a->FontOverLineSpace, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FontOverLineSpace), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_FontOverLineSpace);
		
		
	/* パッキングボックス(vbox_label_etc2) 作成 */
	vbox_label_etc2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_label_etc2, TRUE, TRUE, 0);
	gtk_widget_show(vbox_label_etc2);
	
		/* label_SearchPointX */
		label_SearchPointX = gtk_label_new( _("Insertion point X") );
		gtk_misc_set_alignment(GTK_MISC(label_SearchPointX), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_SearchPointX, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_SearchPointX, FALSE, TRUE, 0);
		gtk_widget_show(label_SearchPointX);
		
		/* label_SearchPointY */
		label_SearchPointY = gtk_label_new( _("Insertion point Y") );
		gtk_misc_set_alignment(GTK_MISC(label_SearchPointY), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_SearchPointY, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_SearchPointY, FALSE, TRUE, 0);
		gtk_widget_show(label_SearchPointY);
		
		/* label_Angle */
		label_Angle = gtk_label_new( _("Angle") );
		gtk_misc_set_alignment(GTK_MISC(label_Angle), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_Angle, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_Angle, FALSE, TRUE, 0);
		gtk_widget_show(label_Angle);
		
		/* label_FitPointX */
		label_FitPointX = gtk_label_new( _("It adjusts in the horizontal."));
		gtk_misc_set_alignment(GTK_MISC(label_FitPointX), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_FitPointX, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_FitPointX, FALSE, TRUE, 0);
		gtk_widget_show(label_FitPointX);
		
		/* label_FitPointY */
		label_FitPointY = gtk_label_new( _("It adjusts in the vertical.") );
		gtk_misc_set_alignment(GTK_MISC(label_FitPointY), 0.0f, 1.0f);
		gtk_widget_set_size_request(label_FitPointY, TED_LABEL_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_label_etc2), label_FitPointY, FALSE, TRUE, 0);
		gtk_widget_show(label_FitPointY);
		
		
	/* パッキングボックス(vbox_entry_etc2) 作成 */
	vbox_entry_etc2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox_etc), vbox_entry_etc2, TRUE, TRUE, 0);
	gtk_widget_show(vbox_entry_etc2);
	
		/* entry_SearchPointX */
		a->entry_SearchPointX = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_SearchPointX, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_SearchPointX, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_SearchPointX), 256);
		FloatOut_n(str, a->SearchPointX, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_SearchPointX), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_SearchPointX);
		
		/* entry_SearchPointY */
		a->entry_SearchPointY = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_SearchPointY, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_SearchPointY, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_SearchPointY), 256);
		FloatOut_n(str, a->SearchPointY, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_SearchPointY), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_SearchPointY);
		
		/* entry_Angle */
		a->entry_Angle = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_Angle, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_Angle, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_Angle), 256);
		FloatOut_n(str, a->Angle, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(a->entry_Angle), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_Angle);
		
		/* entry_FitPointX */
		a->entry_FitPointX = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_FitPointX, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_FitPointX, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_FitPointX), 256);
		sprintf(str, "%d", a->FitPointX);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FitPointX), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_FitPointX);
		
		/* entry_FitPointY */
		a->entry_FitPointY = gtk_entry_new();
		gtk_widget_set_size_request(a->entry_FitPointY, TED_ETC_WIDTH, TED_HEIGHT);
		gtk_box_pack_start((GtkBox *)GTK_BOX(vbox_entry_etc2), a->entry_FitPointY, FALSE, TRUE, 0);
		gtk_entry_set_max_length(GTK_ENTRY(a->entry_FitPointY), 256);
		sprintf(str, "%d", a->FitPointY);
		gtk_entry_set_text(GTK_ENTRY(a->entry_FitPointY), str);	/* 初期値設定 */
		gtk_widget_show(a->entry_FitPointY);
		
	return 1;
}


/* -----------------------------------------------------------------------------
 * 寸法値設定ダイアログ
 * 
 */
gint TextEditDialog(TEXT_EDIT_DLG *text_edit_dlg)
{
	gint parent_x, parent_y;
	
	GtkWidget *main_vbox;
	GtkWidget *vbox_Text;
	GtkWidget *separator;
	GtkWidget *hbox_etc;
	GtkWidget *action_hbox;
	GtkWidget *file_name_button;
	GtkWidget *fai_button;
	GtkWidget *R_button;
	GtkWidget *cancel_button;
	GtkWidget *ok_button;
	
	/* ダイアログ(text_edit_dlg->dialog)生成 */
	text_edit_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(text_edit_dlg->dialog),  _("Text Setting") );
	
	//gtk_window_set_position(GTK_WINDOW(text_edit_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_get_position(GTK_WINDOW(text_edit_dlg->parent), &parent_x, &parent_y);
	gtk_window_move(GTK_WINDOW(text_edit_dlg->dialog), parent_x + 72, parent_y + 89);
	
	g_signal_connect( G_OBJECT(text_edit_dlg->dialog), "key_press_event",
						G_CALLBACK(text_edit_dlg_key_press_event), text_edit_dlg);
	
	
		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(text_edit_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(text_edit_dlg->dialog), 5);
		gtk_widget_show(main_vbox);
		
		
			/* -----------------------------------------------------
			 * パッキングボックス(main_vbox) に入れる
			 * パッキングボックス(vbox_Text & separator & action_hbox) を作成し
			 * 格納する
			 */
			/* パッキングボックス(vbox_Text) */
			vbox_Text = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), vbox_Text, TRUE, TRUE, 0);
			gtk_widget_show(vbox_Text);
			
				/*  */
				make_box_text(vbox_Text, text_edit_dlg);
				
			/* セパレーター(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);
			
			/* パッキングボックス(hbox_etc) */
			hbox_etc = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								hbox_etc, TRUE, TRUE, 0);
			gtk_widget_show(hbox_etc);
			
				/*  */
				make_box_etc(hbox_etc, text_edit_dlg);
				
			/* セパレーター(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);
			
			
			/* パッキングボックス(action_hbox) */
			action_hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox);
			
				/* -----------------------------------------------------
				 * パッキングボックス(action_hbox) に入れる
				 * ボタン
				 * file_name_button 
				 * fai_button 
				 * R_button 
				 * cancel_button 
				 * ok_button
				 * を作成し
				 * 格納する
				 */
				/* FileName ボタンの生成 */
				file_name_button = gtk_button_new_with_label( _("File Name") );
				gtk_widget_set_size_request(file_name_button, 80, 22);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), file_name_button, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(file_name_button), "clicked", 
									G_CALLBACK(text_edit_dlg_FileName_pushed), text_edit_dlg);
				gtk_widget_show(file_name_button);
				
				/* Φ ボタンの生成 */
				fai_button = gtk_button_new_with_label("φ");
				gtk_widget_set_size_request(fai_button, 30, 22);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), fai_button, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(fai_button), "clicked", 
									G_CALLBACK(text_edit_dlg_Fai_pushed), text_edit_dlg);
				gtk_widget_show(fai_button);
				
				/* R ボタンの生成 */
				R_button = gtk_button_new_with_label("R");
				gtk_widget_set_size_request(R_button, 30, 22);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), R_button, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(R_button), "clicked", 
									G_CALLBACK(text_edit_dlg_R_pushed), text_edit_dlg);
				gtk_widget_show(R_button);
				
				/* CANCELボタンの生成 */
				cancel_button = gtk_button_new_with_label("CANCEL");
				gtk_widget_set_size_request(cancel_button, 80, 22);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_button, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(cancel_button), "clicked", 
									G_CALLBACK(text_edit_dlg_cancel_pushed), text_edit_dlg);
				g_signal_connect( G_OBJECT(cancel_button), "clicked", 
									G_CALLBACK(gtk_main_quit), NULL);
				gtk_widget_show(cancel_button);
				
				/* OKボタンの生成 */
				ok_button = gtk_button_new_with_label("OK");
				gtk_widget_set_size_request(ok_button, 30, 22);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_button, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(ok_button), "clicked", 
									G_CALLBACK(text_edit_dlg_ok_pushed), text_edit_dlg);
				g_signal_connect( G_OBJECT(ok_button), "clicked", 
									G_CALLBACK(gtk_main_quit), NULL);
			//	  GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
			//	  gtk_widget_grab_default(ok_button);
				gtk_widget_show(ok_button);
				
				
	/*  フォーカスを entry_Text に設定 */
	gtk_window_set_focus(GTK_WINDOW(text_edit_dlg->dialog), text_edit_dlg->entry_Text);
	
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(text_edit_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(text_edit_dlg->dialog), GTK_WINDOW(text_edit_dlg->parent));
	
	
	/* ダイアログを可視状態へ */
	gtk_widget_show(text_edit_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(text_edit_dlg->dialog);
	return 0; 
}


/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TextEditDlg.c
 * ====================================================================
 */
