package net.sf.saxon.om;

/**
 * A set of declared notations (in the sense of XSD xs:notation)
 */
public interface NotationSet {

    /**
     * Ask whether a given notation name is present in this set of notations
     * @param uri the URI part of the notation name
     * @param local the local part of the notation name
     * @return true if the notation name is present
     */
    public boolean isDeclaredNotation(String uri, String local);
}

//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License.
//
// The Original Code is: all this file
//
// The Initial Developer of the Original Code is Saxonica Limited.
// Portions created by ___ are Copyright (C) ___. All rights reserved.
//
// Contributor(s):
//
