/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli \
 *     --scli-exclude='broadMauBasic' MAU-MIB
 *
 * Derived from MAU-MIB:
 *   Management information for 802.3 MAUs.
 *   
 *   The following reference is used throughout this MIB module:
 *   
 *   [IEEE802.3] refers to:
 *      IEEE Std 802.3, 2005 Edition: 'IEEE Standard for Information
 *      technology - Telecommunications and information exchange
 *      between systems - Local and metropolitan area networks -
 *      Specific requirements - Part 3: Carrier sense multiple
 *      access with collision detection (CSMA/CD) access method and
 *      physical layer specifications'.
 *   
 *      Of particular interest is Clause 30, 'Management'.
 *   
 *   Copyright (C) The IETF Trust (2007).
 *   This version of this MIB module is part of RFC 4836;
 *   see the RFC itself for full legal notices.
 *
 * Revision 2007-04-21 00:00:
 *   Updated to reference IANA maintaned textual
 *   conventions for MAU types, Media Availability state,
 *   Auto Negotiation capabilities, and jack types,
 *   instead of using internally defined values.
 *   
 *   This version is published as RFC 4836.
 *
 * Revision 2003-09-19 00:00:
 *   Updated to include support for 10 Gb/s MAUs.
 *   This resulted in the following revisions:
 *   - Added OBJECT-IDENTITY definitions for
 *     10 gigabit MAU types
 *   
 *   
 *   
 *   - Added fiberLC jack type to JackType TC
 *   - Extended ifMauTypeListBits with bits for
 *     the 10 gigabit MAU types
 *   - Added enumerations to ifMauMediaAvailable,
 *     and updated its DESCRIPTION to reflect
 *     behaviour at 10 Gb/s
 *   - Added 64-bit version of ifMauFalseCarriers
 *     and added mauIfGrpHCStats object group to
 *     contain the new object
 *   - Deprecated mauModIfCompl2 and replaced it
 *     with mauModIfCompl3, which includes the new
 *     object group
 *   
 *    This version published as RFC 3636.
 *
 * Revision 1999-08-24 04:00:
 *   This version published as RFC 2668.  Updated
 *   to include support for 1000 Mb/sec
 *   MAUs and flow control negotiation.
 *
 * Revision 1997-10-31 00:00:
 *   Version published as RFC 2239.
 *
 * Revision 1993-09-30 00:00:
 *   Initial version, published as RFC 1515.
 *
 * $Id: mau-mib.h 3180 2009-07-29 22:36:13Z schoenw $
 */

#ifndef _MAU_MIB_H_
#define _MAU_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define MAU_MIB_RPMAUSTATUS_OTHER       1
#define MAU_MIB_RPMAUSTATUS_UNKNOWN     2
#define MAU_MIB_RPMAUSTATUS_OPERATIONAL 3
#define MAU_MIB_RPMAUSTATUS_STANDBY     4
#define MAU_MIB_RPMAUSTATUS_SHUTDOWN    5
#define MAU_MIB_RPMAUSTATUS_RESET       6

extern GNetSnmpEnum const mau_mib_enums_rpMauStatus[];

#define MAU_MIB_RPMAUJABBERSTATE_OTHER     1
#define MAU_MIB_RPMAUJABBERSTATE_UNKNOWN   2
#define MAU_MIB_RPMAUJABBERSTATE_NOJABBER  3
#define MAU_MIB_RPMAUJABBERSTATE_JABBERING 4

extern GNetSnmpEnum const mau_mib_enums_rpMauJabberState[];

#define MAU_MIB_IFMAUSTATUS_OTHER       1
#define MAU_MIB_IFMAUSTATUS_UNKNOWN     2
#define MAU_MIB_IFMAUSTATUS_OPERATIONAL 3
#define MAU_MIB_IFMAUSTATUS_STANDBY     4
#define MAU_MIB_IFMAUSTATUS_SHUTDOWN    5
#define MAU_MIB_IFMAUSTATUS_RESET       6

extern GNetSnmpEnum const mau_mib_enums_ifMauStatus[];

#define MAU_MIB_IFMAUJABBERSTATE_OTHER     1
#define MAU_MIB_IFMAUJABBERSTATE_UNKNOWN   2
#define MAU_MIB_IFMAUJABBERSTATE_NOJABBER  3
#define MAU_MIB_IFMAUJABBERSTATE_JABBERING 4

extern GNetSnmpEnum const mau_mib_enums_ifMauJabberState[];

#define MAU_MIB_IFMAUAUTONEGADMINSTATUS_ENABLED  1
#define MAU_MIB_IFMAUAUTONEGADMINSTATUS_DISABLED 2

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegAdminStatus[];

#define MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_DETECTED    1
#define MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_NOTDETECTED 2

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteSignaling[];

#define MAU_MIB_IFMAUAUTONEGCONFIG_OTHER              1
#define MAU_MIB_IFMAUAUTONEGCONFIG_CONFIGURING        2
#define MAU_MIB_IFMAUAUTONEGCONFIG_COMPLETE           3
#define MAU_MIB_IFMAUAUTONEGCONFIG_DISABLED           4
#define MAU_MIB_IFMAUAUTONEGCONFIG_PARALLELDETECTFAIL 5

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegConfig[];

#define MAU_MIB_IFMAUAUTONEGRESTART_RESTART   1
#define MAU_MIB_IFMAUAUTONEGRESTART_NORESTART 2

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRestart[];

#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_NOERROR      1
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_OFFLINE      2
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_LINKFAILURE  3
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_AUTONEGERROR 4

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultAdvertised[];

#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_NOERROR      1
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_OFFLINE      2
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_LINKFAILURE  3
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_AUTONEGERROR 4

extern GNetSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultReceived[];

#define MAU_MIB_JACKTYPE_OTHER    1
#define MAU_MIB_JACKTYPE_RJ45     2
#define MAU_MIB_JACKTYPE_RJ45S    3
#define MAU_MIB_JACKTYPE_DB9      4
#define MAU_MIB_JACKTYPE_BNC      5
#define MAU_MIB_JACKTYPE_FAUI     6
#define MAU_MIB_JACKTYPE_MAUI     7
#define MAU_MIB_JACKTYPE_FIBERSC  8
#define MAU_MIB_JACKTYPE_FIBERMIC 9
#define MAU_MIB_JACKTYPE_FIBERST  10
#define MAU_MIB_JACKTYPE_TELCO    11
#define MAU_MIB_JACKTYPE_MTRJ     12
#define MAU_MIB_JACKTYPE_HSSDC    13
#define MAU_MIB_JACKTYPE_FIBERLC  14

extern GNetSnmpEnum const mau_mib_enums_JackType[];


/*
 * Tables to map notifications to strings and vice versa.
 */

#define MAU_MIB_RPMAUJABBERTRAP	1,3,6,1,2,1,26,0,1
#define MAU_MIB_IFMAUJABBERTRAP	1,3,6,1,2,1,26,0,2

extern GNetSnmpIdentity const mau_mib_notifications[];

/*
 * C type definitions for MAU-MIB::rpMauEntry.
 */

#define MAU_MIB_RPMAUGROUPINDEX               (1 << 0) 
#define MAU_MIB_RPMAUPORTINDEX                (1 << 1) 
#define MAU_MIB_RPMAUINDEX                    (1 << 2) 
#define MAU_MIB_RPMAUTYPE                     (1 << 3) 
#define MAU_MIB_RPMAUSTATUS                   (1 << 4) 
#define MAU_MIB_RPMAUMEDIAAVAILABLE           (1 << 5) 
#define MAU_MIB_RPMAUMEDIAAVAILABLESTATEEXITS (1 << 6) 
#define MAU_MIB_RPMAUJABBERSTATE              (1 << 7) 
#define MAU_MIB_RPMAUJABBERINGSTATEENTERS     (1 << 8) 
#define MAU_MIB_RPMAUFALSECARRIERS            (1 << 9) 

typedef struct {
    gint32   rpMauGroupIndex;                    /* ro */
    gint32   rpMauPortIndex;                     /* ro */
    gint32   rpMauIndex;                         /* ro */
    guint32  *rpMauType;                         /* ro SNMPv2-TC::AutonomousType */
#define MAU_MIB_RPMAUTYPEMINLENGTH 0
#define MAU_MIB_RPMAUTYPEMAXLENGTH 128
    guint16  _rpMauTypeLength;
    gint32   *rpMauStatus;                       /* rw */
    gint32   *rpMauMediaAvailable;               /* ro IANA-MAU-MIB::IANAifMauMediaAvailable */
    guint32  *rpMauMediaAvailableStateExits;     /* ro SNMPv2-SMI::Counter32 */
    gint32   *rpMauJabberState;                  /* ro */
    guint32  *rpMauJabberingStateEnters;         /* ro SNMPv2-SMI::Counter32 */
    guint32  *rpMauFalseCarriers;                /* ro SNMPv2-SMI::Counter32 */
} mau_mib_rpMauEntry_t;

extern void
mau_mib_get_rpMauTable(GNetSnmp *s, mau_mib_rpMauEntry_t ***rpMauEntry, gint64 mask, GError **error);

extern void
mau_mib_free_rpMauTable(mau_mib_rpMauEntry_t **rpMauEntry);

extern mau_mib_rpMauEntry_t *
mau_mib_new_rpMauEntry(void);

extern void
mau_mib_get_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t **rpMauEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint64 mask, GError **error);

extern void
mau_mib_set_rpMauEntry(GNetSnmp *s, mau_mib_rpMauEntry_t *rpMauEntry, gint64 mask, GError **error);

extern void
mau_mib_free_rpMauEntry(mau_mib_rpMauEntry_t *rpMauEntry);

/*
 * C type definitions for MAU-MIB::rpJackEntry.
 */

#define MAU_MIB_RPJACKTYPE (1 << 0) 

typedef struct {
    gint32   rpMauGroupIndex; /* ro */
    gint32   rpMauPortIndex;  /* ro */
    gint32   rpMauIndex;      /* ro */
    gint32   rpJackIndex;     /* na */
    gint32   *rpJackType;     /* ro IANA-MAU-MIB::IANAifJackType */
} mau_mib_rpJackEntry_t;

extern void
mau_mib_get_rpJackTable(GNetSnmp *s, mau_mib_rpJackEntry_t ***rpJackEntry, gint64 mask, GError **error);

extern void
mau_mib_free_rpJackTable(mau_mib_rpJackEntry_t **rpJackEntry);

extern mau_mib_rpJackEntry_t *
mau_mib_new_rpJackEntry(void);

extern void
mau_mib_get_rpJackEntry(GNetSnmp *s, mau_mib_rpJackEntry_t **rpJackEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex, gint64 mask, GError **error);

extern void
mau_mib_free_rpJackEntry(mau_mib_rpJackEntry_t *rpJackEntry);

/*
 * C type definitions for MAU-MIB::ifMauEntry.
 */

#define MAU_MIB_IFMAUIFINDEX                  (1 << 0) 
#define MAU_MIB_IFMAUINDEX                    (1 << 1) 
#define MAU_MIB_IFMAUTYPE                     (1 << 2) 
#define MAU_MIB_IFMAUSTATUS                   (1 << 3) 
#define MAU_MIB_IFMAUMEDIAAVAILABLE           (1 << 4) 
#define MAU_MIB_IFMAUMEDIAAVAILABLESTATEEXITS (1 << 5) 
#define MAU_MIB_IFMAUJABBERSTATE              (1 << 6) 
#define MAU_MIB_IFMAUJABBERINGSTATEENTERS     (1 << 7) 
#define MAU_MIB_IFMAUFALSECARRIERS            (1 << 8) 
#define MAU_MIB_IFMAUTYPELIST                 (1 << 9) 
#define MAU_MIB_IFMAUDEFAULTTYPE              (1 << 10) 
#define MAU_MIB_IFMAUAUTONEGSUPPORTED         (1 << 11) 
#define MAU_MIB_IFMAUTYPELISTBITS             (1 << 12) 
#define MAU_MIB_IFMAUHCFALSECARRIERS          (1 << 13) 

typedef struct {
    gint32   ifMauIfIndex;                       /* ro IF-MIB::InterfaceIndex */
    gint32   ifMauIndex;                         /* ro */
    guint32  *ifMauType;                         /* ro SNMPv2-TC::AutonomousType */
#define MAU_MIB_IFMAUTYPEMINLENGTH 0
#define MAU_MIB_IFMAUTYPEMAXLENGTH 128
    guint16  _ifMauTypeLength;
    gint32   *ifMauStatus;                       /* rw */
    gint32   *ifMauMediaAvailable;               /* ro IANA-MAU-MIB::IANAifMauMediaAvailable */
    guint32  *ifMauMediaAvailableStateExits;     /* ro SNMPv2-SMI::Counter32 */
    gint32   *ifMauJabberState;                  /* ro */
    guint32  *ifMauJabberingStateEnters;         /* ro SNMPv2-SMI::Counter32 */
    guint32  *ifMauFalseCarriers;                /* ro SNMPv2-SMI::Counter32 */
    gint32   *ifMauTypeList;                     /* ro Integer32 */
    guint32  *ifMauDefaultType;                  /* rw SNMPv2-TC::AutonomousType */
#define MAU_MIB_IFMAUDEFAULTTYPEMINLENGTH 0
#define MAU_MIB_IFMAUDEFAULTTYPEMAXLENGTH 128
    guint16  _ifMauDefaultTypeLength;
    gint32   *ifMauAutoNegSupported;             /* ro SNMPv2-TC::TruthValue */
    guchar   *ifMauTypeListBits;                 /* ro IANA-MAU-MIB::IANAifMauTypeListBits */
#define MAU_MIB_IFMAUTYPELISTBITSMINLENGTH 0
#define MAU_MIB_IFMAUTYPELISTBITSMAXLENGTH 7
    guint16  _ifMauTypeListBitsLength;
    guint64  *ifMauHCFalseCarriers;              /* ro SNMPv2-SMI::Counter64 */
} mau_mib_ifMauEntry_t;

extern void
mau_mib_get_ifMauTable(GNetSnmp *s, mau_mib_ifMauEntry_t ***ifMauEntry, gint64 mask, GError **error);

extern void
mau_mib_free_ifMauTable(mau_mib_ifMauEntry_t **ifMauEntry);

extern mau_mib_ifMauEntry_t *
mau_mib_new_ifMauEntry(void);

extern void
mau_mib_get_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t **ifMauEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask, GError **error);

extern void
mau_mib_set_ifMauEntry(GNetSnmp *s, mau_mib_ifMauEntry_t *ifMauEntry, gint64 mask, GError **error);

extern void
mau_mib_free_ifMauEntry(mau_mib_ifMauEntry_t *ifMauEntry);

/*
 * C type definitions for MAU-MIB::ifJackEntry.
 */

#define MAU_MIB_IFJACKTYPE (1 << 0) 

typedef struct {
    gint32   ifMauIfIndex;    /* ro IF-MIB::InterfaceIndex */
    gint32   ifMauIndex;      /* ro */
    gint32   ifJackIndex;     /* na */
    gint32   *ifJackType;     /* ro IANA-MAU-MIB::IANAifJackType */
} mau_mib_ifJackEntry_t;

extern void
mau_mib_get_ifJackTable(GNetSnmp *s, mau_mib_ifJackEntry_t ***ifJackEntry, gint64 mask, GError **error);

extern void
mau_mib_free_ifJackTable(mau_mib_ifJackEntry_t **ifJackEntry);

extern mau_mib_ifJackEntry_t *
mau_mib_new_ifJackEntry(void);

extern void
mau_mib_get_ifJackEntry(GNetSnmp *s, mau_mib_ifJackEntry_t **ifJackEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex, gint64 mask, GError **error);

extern void
mau_mib_free_ifJackEntry(mau_mib_ifJackEntry_t *ifJackEntry);

/*
 * C type definitions for MAU-MIB::ifMauAutoNegEntry.
 */

#define MAU_MIB_IFMAUAUTONEGADMINSTATUS           (1 << 0) 
#define MAU_MIB_IFMAUAUTONEGREMOTESIGNALING       (1 << 1) 
#define MAU_MIB_IFMAUAUTONEGCONFIG                (1 << 2) 
#define MAU_MIB_IFMAUAUTONEGCAPABILITY            (1 << 3) 
#define MAU_MIB_IFMAUAUTONEGCAPADVERTISED         (1 << 4) 
#define MAU_MIB_IFMAUAUTONEGCAPRECEIVED           (1 << 5) 
#define MAU_MIB_IFMAUAUTONEGRESTART               (1 << 6) 
#define MAU_MIB_IFMAUAUTONEGCAPABILITYBITS        (1 << 7) 
#define MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITS     (1 << 8) 
#define MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITS       (1 << 9) 
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED (1 << 10) 
#define MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED   (1 << 11) 

typedef struct {
    gint32   ifMauIfIndex;                           /* ro IF-MIB::InterfaceIndex */
    gint32   ifMauIndex;                             /* ro */
    gint32   *ifMauAutoNegAdminStatus;               /* rw */
    gint32   *ifMauAutoNegRemoteSignaling;           /* ro */
    gint32   *ifMauAutoNegConfig;                    /* ro */
    gint32   *ifMauAutoNegCapability;                /* ro Integer32 */
    gint32   *ifMauAutoNegCapAdvertised;             /* rw Integer32 */
    gint32   *ifMauAutoNegCapReceived;               /* ro Integer32 */
    gint32   *ifMauAutoNegRestart;                   /* rw */
    guchar   *ifMauAutoNegCapabilityBits;            /* ro IANA-MAU-MIB::IANAifMauAutoNegCapBits */
#define MAU_MIB_IFMAUAUTONEGCAPABILITYBITSMINLENGTH 0
#define MAU_MIB_IFMAUAUTONEGCAPABILITYBITSMAXLENGTH 2
    guint16  _ifMauAutoNegCapabilityBitsLength;
    guchar   *ifMauAutoNegCapAdvertisedBits;         /* rw IANA-MAU-MIB::IANAifMauAutoNegCapBits */
#define MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITSMINLENGTH 0
#define MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITSMAXLENGTH 2
    guint16  _ifMauAutoNegCapAdvertisedBitsLength;
    guchar   *ifMauAutoNegCapReceivedBits;           /* ro IANA-MAU-MIB::IANAifMauAutoNegCapBits */
#define MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITSMINLENGTH 0
#define MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITSMAXLENGTH 2
    guint16  _ifMauAutoNegCapReceivedBitsLength;
    gint32   *ifMauAutoNegRemoteFaultAdvertised;     /* rw */
    gint32   *ifMauAutoNegRemoteFaultReceived;       /* ro */
} mau_mib_ifMauAutoNegEntry_t;

extern void
mau_mib_get_ifMauAutoNegTable(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t ***ifMauAutoNegEntry, gint64 mask, GError **error);

extern void
mau_mib_free_ifMauAutoNegTable(mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry);

extern mau_mib_ifMauAutoNegEntry_t *
mau_mib_new_ifMauAutoNegEntry(void);

extern void
mau_mib_get_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint64 mask, GError **error);

extern void
mau_mib_set_ifMauAutoNegEntry(GNetSnmp *s, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry, gint64 mask, GError **error);

extern void
mau_mib_free_ifMauAutoNegEntry(mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry);


G_END_DECLS

#endif /* _MAU_MIB_H_ */
