/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ContentModelInferrer;
import com.thaiopensource.xml.infer.DatatypeInferrer;
import com.thaiopensource.xml.infer.DatatypeRepertoire;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.TextParticle;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementDeclInferrer {
    private final DatatypeRepertoire datatypes;
    private ContentModelInferrer contentModelInferrer;
    private final Map<Name, DatatypeInferrer> attributeTypeMap = new HashMap<Name, DatatypeInferrer>();
    private DatatypeInferrer valueInferrer;
    private final Set<Name> requiredAttributeNames = new HashSet<Name>();
    private Set<Name> mixedContentNames = null;

    ElementDeclInferrer(DatatypeRepertoire datatypeRepertoire, List<Name> list) {
        this.datatypes = datatypeRepertoire;
        this.requiredAttributeNames.addAll(list);
    }

    ElementDecl infer() {
        ElementDecl elementDecl = new ElementDecl();
        for (Map.Entry<Name, DatatypeInferrer> entry : this.attributeTypeMap.entrySet()) {
            elementDecl.getAttributeDecls().put(entry.getKey(), new AttributeDecl(entry.getValue().getTypeName(), !this.requiredAttributeNames.contains(entry.getKey())));
        }
        if (this.contentModelInferrer != null) {
            elementDecl.setContentModel(this.contentModelInferrer.inferContentModel());
        } else if (this.mixedContentNames != null) {
            elementDecl.setContentModel(this.makeMixedContentModel());
        } else if (this.valueInferrer.isAllWhiteSpace()) {
            elementDecl.setContentModel(new EmptyParticle());
        } else {
            Name name = this.valueInferrer.getTypeName();
            if (name == null) {
                elementDecl.setContentModel(new TextParticle());
            } else {
                elementDecl.setDatatype(name);
            }
        }
        return elementDecl;
    }

    private Particle makeMixedContentModel() {
        Particle particle = new TextParticle();
        for (Name name : this.mixedContentNames) {
            particle = new ChoiceParticle(particle, new ElementParticle(name));
        }
        return new OneOrMoreParticle(particle);
    }

    boolean wantValue() {
        return this.contentModelInferrer == null && this.mixedContentNames == null;
    }

    void addElement(Name name) {
        if (this.valueInferrer != null) {
            if (this.valueInferrer.isAllWhiteSpace()) {
                if (this.contentModelInferrer == null) {
                    this.contentModelInferrer = ContentModelInferrer.createContentModelInferrer();
                }
                this.contentModelInferrer.endSequence();
                this.valueInferrer = null;
            } else {
                this.useMixedContent();
            }
        }
        if (this.mixedContentNames != null) {
            this.mixedContentNames.add(name);
        } else {
            if (this.contentModelInferrer == null) {
                this.contentModelInferrer = ContentModelInferrer.createContentModelInferrer();
            }
            this.contentModelInferrer.addElement(name);
        }
    }

    void endSequence() {
        if (this.contentModelInferrer != null) {
            this.contentModelInferrer.endSequence();
        }
    }

    void addValue(String string) {
        if (this.valueInferrer == null) {
            this.valueInferrer = new DatatypeInferrer(this.datatypes, string);
        } else {
            this.valueInferrer.addValue(string);
        }
    }

    void addText() {
        this.useMixedContent();
    }

    private void useMixedContent() {
        if (this.mixedContentNames == null) {
            this.mixedContentNames = new HashSet<Name>();
            if (this.contentModelInferrer != null) {
                this.mixedContentNames.addAll(this.contentModelInferrer.getElementNames());
                this.contentModelInferrer = null;
            }
            this.valueInferrer = null;
        }
    }

    void addAttributeNames(List<Name> list) {
        this.requiredAttributeNames.retainAll(list);
    }

    void addAttributeValue(Name name, String string) {
        DatatypeInferrer datatypeInferrer = this.attributeTypeMap.get(name);
        if (datatypeInferrer == null) {
            datatypeInferrer = new DatatypeInferrer(this.datatypes, string);
            this.attributeTypeMap.put(name, datatypeInferrer);
        } else {
            datatypeInferrer.addValue(string);
        }
    }
}

