/* Public domain. */

#ifndef LIST1_H
#define LIST1_H

#include "gccattributes.h"
#include "diuintbunch.h"

#define LIST1_ZERO { GEN_BUNCH_ZERO, 0 }
#define list1_i(t, i) ((i) ? ((t)->x.x.s[i].right) : 0)
#define list1_len(t) ((t)->x.n - 1)
#define list1_head(t) ((t)->x.x.s[0].left)
#define list1_sethead(t, r) ((t)->x.x.s[0].left = (r))

typedef struct list1 list1, *list1_ref ;
struct list1
{
  diuintbunch x ;
  int (*cmp)(unsigned int, unsigned int) ;
} ;

extern void list1_free (list1_ref) ;
extern int list1_init (list1_ref, int (*)(unsigned int, unsigned int)) ;
extern unsigned int list1_search (list1 const *, unsigned int) gccattr_pure ;
extern unsigned int list1_push (list1_ref, unsigned int) ;
extern unsigned int list1_insert (list1_ref, unsigned int) ;
extern unsigned int list1_deletenext (list1_ref, unsigned int) ;
extern unsigned int list1_pop (list1_ref) ;
extern unsigned int list1_delete (list1_ref, unsigned int) ;
extern int list1_iter (list1_ref, int (*)(unsigned int, void *), void *) ;


#endif
