-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SPARK.Ada.Strings.Maps.Not_SPARK is
   --# hide SPARK.Ada.Strings.Maps.Not_SPARK;

   function To_Set (Ranges : Character_Ranges) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps.To_Set
           (Ranges => Standard.Ada.Strings.Maps.Character_Ranges (Ranges)));
   end To_Set;

   function To_Ranges (Set : Character_Set) return Character_Ranges is
   begin
      return Character_Ranges
        (Standard.Ada.Strings.Maps.To_Ranges
           (Set => Standard.Ada.Strings.Maps.Character_Set (Set)));
   end To_Ranges;

   function To_Sequence (Set : Character_Set) return Character_Sequence is
   begin
      return Standard.Ada.Strings.Maps.To_Sequence
        (Set => Standard.Ada.Strings.Maps.Character_Set (Set));
   end To_Sequence;

   function To_Domain
     (Map : Character_Mapping) return Character_Sequence is
   begin
      return Standard.Ada.Strings.Maps.To_Domain
        (Map => Standard.Ada.Strings.Maps.Character_Mapping (Map));
   end To_Domain;

   function To_Range
     (Map : Character_Mapping) return Character_Sequence is
   begin
      return Standard.Ada.Strings.Maps.To_Range
        (Map => Standard.Ada.Strings.Maps.Character_Mapping (Map));
   end To_Range;

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_Character_Set
     (From : Character_Set)
     return Standard.Ada.Strings.Maps.Character_Set is
   begin
      return Standard.Ada.Strings.Maps.Character_Set (From);
   end To_Character_Set;

   function To_Character_Range
     (From : Character_Range)
     return Standard.Ada.Strings.Maps.Character_Range is
   begin
      return Standard.Ada.Strings.Maps.Character_Range'(Low  => From.Low,
                                                        High => From.High);
   end To_Character_Range;

   function To_Character_Mapping
     (From : Character_Mapping)
     return Standard.Ada.Strings.Maps.Character_Mapping is
   begin
      return Standard.Ada.Strings.Maps.Character_Mapping (From);
   end To_Character_Mapping;

end SPARK.Ada.Strings.Maps.Not_SPARK;
