#! /bin/sh
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#               Further changes by Javier Fernandez-Sanguino <jfs@debian.org>
#               Modified for sphinx by Radu Spineanu <radu@debian.org>
#
#

### BEGIN INIT INFO
# Provides:          sphinxsearch
# Required-Start:    $local_fs $remote_fs $syslog $network $time
# Required-Stop:     $local_fs $remote_fs $syslog $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Fast standalone full-text SQL search engine
### END INIT INFO


PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/searchd
NAME=sphinxsearch
DESC=sphinxsearch

test -x $DAEMON || exit 0

LOGDIR=/var/log/sphinxsearch
PIDFILE=/var/run/sphinxsearch/searchd.pid
DODTIME=1                   # Time to wait for the server to die, in seconds
                            # If this value is set too low you might not
                            # let some servers to die gracefully and
                            # 'restart' will not work

STARTDELAY=0.5

# Include sphinxsearch defaults if available
if [ -f /etc/default/sphinxsearch ] ; then
    . /etc/default/sphinxsearch
fi

if [ "$START" != "yes" ]; then
  echo "To enable $NAME, edit /etc/default/sphinxsearch and set START=yes"
  exit 0
fi


set -e

# Make sure the pidfile directory exists with correct permissions
piddir=`dirname "$PIDFILE"`
if [ ! -d "$piddir" ]; then
    mkdir -p "$piddir"
    chown -R sphinxsearch "$piddir"
    chgrp -R sphinxsearch "$piddir"
fi


running_pid()
{
    # Check if a given process pid's cmdline matches a given name
    pid=$1
    name=$2
    [ -z "$pid" ] && return 1
    [ ! -d /proc/$pid ] &&  return 1
    cmd=`cat /proc/$pid/cmdline | tr "\000" "\n"|head -n 1 |cut -d : -f 1`
    # Is this the expected child?
    [ "$cmd" != "$name" ] &&  return 1
    return 0
}

running()
{
# Check if the process is running looking at /proc
# (works for all users)

    # No pidfile, probably no daemon present
    [ ! -f "$PIDFILE" ] && return 1
    # Obtain the pid and check it against the binary name
    pid=`cat $PIDFILE`
    running_pid $pid $DAEMON || return 1
    return 0
}

do_force_stop() {
# Forcefully kill the process
    [ ! -f "$PIDFILE" ] && return
    if running ; then
        kill -15 $pid
        # Is it really dead?
        [ -n "$DODTIME" ] && sleep "$DODTIME"s
        if running ; then
            kill -9 $pid
            [ -n "$DODTIME" ] && sleep "$DODTIME"s
            if running ; then
                echo "Cannot kill $NAME (pid=$pid)!"
                exit 1
            fi
        fi
    fi
    rm -f $PIDFILE
    return 0
}
do_start() {
        # Check if we have the configuration file
        if [ ! -f /etc/sphinxsearch/sphinx.conf ]; then
            echo "\n"
            echo "Please create an /etc/sphinxsearch/sphinx.conf configuration file."
            echo "A template is provided as /etc/sphinxsearch/sphinx.conf.sample."
            exit 1
        fi

        start-stop-daemon --start --pidfile $PIDFILE --chuid sphinxsearch --exec ${DAEMON}
}
do_stop() {
        start-stop-daemon --stop --quiet --oknodo --user sphinxsearch --pidfile $PIDFILE \
            --exec $DAEMON
}

case "$1" in
  start)
        echo -n "Starting $DESC: "
        do_start
        [ -n "$STARTDELAY" ] && sleep $STARTDELAY

        if running ; then
            echo "$NAME."
        else
            echo " ERROR."
        fi
        ;;
  stop)
        echo -n "Stopping $DESC: "
        do_stop
        echo "$NAME."
        ;;
  force-stop)
        echo -n "Forcefully stopping $DESC: "
        do_force_stop
        if ! running ; then
            echo "$NAME."
        else
            echo " ERROR."
        fi
        ;;
  restart|reload|force-reload)
    echo -n "Restarting $DESC: "
        do_stop
        [ -n "$DODTIME" ] && sleep $DODTIME
        do_start
        echo "$NAME."
        ;;

  status)
    echo -n "$NAME is "
    if running ;  then
        echo "running"
    else
        echo " not running."
        exit 1
    fi
    ;;
  *)
    N=/etc/init.d/$NAME
    # echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
    echo "Usage: $N {start|stop|restart|force-reload|status|force-stop}" >&2
    exit 1
    ;;
esac

exit 0
