/*===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */
#include <vdb/extern.h>
#include <insdc/insdc.h>
#include <klib/defs.h>
#include <klib/rc.h>
#include <vdb/table.h>
#include <vdb/xform.h>
#include <vdb/schema.h>
#include <kdb/meta.h>
#include <klib/data-buffer.h>
#include <bitstr.h>
#include <os-native.h>
#include <sysalloc.h>

#include <stdint.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <stdio.h>

static
rc_t CC sprintf_1 ( void *data, const VXformInfo *info, int64_t row_id,
                   VRowResult *rslt, uint32_t argc, const VRowData argv [] )
{
    rc_t rc;
    uint32_t const *val = argv[0].u.data.base;
    int n;
    int count;
    
    assert(argv[0].u.data.elem_bits == sizeof(val[0]) * 8);
    val += argv[0].u.data.first_elem;
    
    n = 11;
    rslt->data->elem_bits = rslt->elem_bits;

    /* loop up to 2 times for resize errors */
    for (count = 0; count != 2; ++count) {

        /* set buffer size */
        rc = KDataBufferResize(rslt->data, n);
        if (rc) return rc;
        
        /* try snprintf and check return */
        n = snprintf(rslt->data->base, n, "%u", val[0]);
        if ( n >= 0 && n < rslt->data->elem_count)
        {
            /* "n" is valid */
            rslt->elem_count = n;
            return 0;
        }

        /* "n" says we probably didn't have enough buffer space
           loop again */
        if ( n < 0 )
            n = rslt->data->elem_count * 2;
    }
    return RC(rcXF, rcFunction, rcExecuting, rcConstraint, rcViolated);
}

static
rc_t CC sprintf_3 ( void *data, const VXformInfo *info, int64_t row_id,
    VRowResult *rslt, uint32_t argc, const VRowData argv [] )
{
    rc_t rc;
    char const *str = argv[0].u.data.base;
    uint32_t const *len = argv[1].u.data.base;
    uint32_t const *val = argv[2].u.data.base;
    int n;
    int count;
    
    assert(argv[0].u.data.elem_bits == sizeof(str[0]) * 8);
    assert(argv[1].u.data.elem_bits == sizeof(len[0]) * 8);
    assert(argv[2].u.data.elem_bits == sizeof(val[0]) * 8);

    str += argv[0].u.data.first_elem;
    len += argv[1].u.data.first_elem;
    val += argv[2].u.data.first_elem;
    
    if (argv[0].u.data.elem_count == 0 && len[0] == 0) {
        rslt->elem_count = 0;
        return 0;
    }

    n = argv[0].u.data.elem_count + len[0] + 1;
    rslt->data->elem_bits = rslt->elem_bits;

    for (count = 0; count != 2; ++count) {

        rc = KDataBufferResize(rslt->data, n);
        if (rc) return rc;

        if (len[0]) {
            n = snprintf(rslt->data->base, n, "%.*s%0*u",
                     (int)argv[0].u.data.elem_count, str,
                     (int)len[0], val[0]);
        }
        else {
            /* snprintf puts '\0' when len[0] == 0
               and adds this characted into returned count */
            n = snprintf(rslt->data->base, n, "%.*s",
                     (int)argv[0].u.data.elem_count, str);
        }
        if (n >= 0 && n < rslt->data->elem_count)
        {
            rslt->elem_count = n;
            return 0;
        }

        if ( n < 0 )
            n = ( argv[0].u.data.elem_count + len[0] + 1 ) * 2;
    }
    return RC(rcXF, rcFunction, rcExecuting, rcConstraint, rcViolated);
}

VTRANSFACT_IMPL ( vdb_sprintf, 1, 0, 0 ) ( const void *Self, const VXfactInfo *info,
    VFuncDesc *rslt, const VFactoryParams *cp, const VFunctionParams *dp )
{
    switch (dp->argc) {
    case 1:
        rslt->u.rf = sprintf_1;
        break;
    case 3:
        rslt->u.rf = sprintf_3;
        break;
    default:
        return RC(rcXF, rcFunction, rcConstructing, rcParam, rcUnsupported);
        break;
    }
    rslt->variant = vftRow;
    return 0;
}
